/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.crypto.tls;

import com.sansec.crypto.agreement.DHStandardGroups;
import com.sansec.crypto.params.DHParameters;
import com.sansec.crypto.tls.AbstractTlsServer;
import com.sansec.crypto.tls.DefaultTlsCipherFactory;
import com.sansec.crypto.tls.TlsCipherFactory;
import com.sansec.crypto.tls.TlsCredentials;
import com.sansec.crypto.tls.TlsEncryptionCredentials;
import com.sansec.crypto.tls.TlsFatalAlert;
import com.sansec.crypto.tls.TlsKeyExchange;
import com.sansec.crypto.tls.TlsPSKIdentityManager;
import com.sansec.crypto.tls.TlsPSKKeyExchange;
import com.sansec.crypto.tls.TlsUtils;
import java.io.IOException;

public class PSKTlsServer
extends AbstractTlsServer {
    protected TlsPSKIdentityManager pskIdentityManager;

    public PSKTlsServer(TlsPSKIdentityManager pskIdentityManager) {
        this(new DefaultTlsCipherFactory(), pskIdentityManager);
    }

    public PSKTlsServer(TlsCipherFactory cipherFactory, TlsPSKIdentityManager pskIdentityManager) {
        super(cipherFactory);
        this.pskIdentityManager = pskIdentityManager;
    }

    protected TlsEncryptionCredentials getRSAEncryptionCredentials() throws IOException {
        throw new TlsFatalAlert(80);
    }

    protected DHParameters getDHParameters() {
        return DHStandardGroups.rfc5114_2048_256;
    }

    @Override
    protected int[] getCipherSuites() {
        return new int[]{49207, 49205, 178, 144};
    }

    @Override
    public TlsCredentials getCredentials() throws IOException {
        int keyExchangeAlgorithm = TlsUtils.getKeyExchangeAlgorithm(this.selectedCipherSuite);
        switch (keyExchangeAlgorithm) {
            case 13: 
            case 14: 
            case 24: {
                return null;
            }
            case 15: {
                return this.getRSAEncryptionCredentials();
            }
        }
        throw new TlsFatalAlert(80);
    }

    @Override
    public TlsKeyExchange getKeyExchange() throws IOException {
        int keyExchangeAlgorithm = TlsUtils.getKeyExchangeAlgorithm(this.selectedCipherSuite);
        switch (keyExchangeAlgorithm) {
            case 13: 
            case 14: 
            case 15: 
            case 24: {
                return this.createPSKKeyExchange(keyExchangeAlgorithm);
            }
        }
        throw new TlsFatalAlert(80);
    }

    protected TlsKeyExchange createPSKKeyExchange(int keyExchange) {
        return new TlsPSKKeyExchange(keyExchange, this.supportedSignatureAlgorithms, null, this.pskIdentityManager, this.getDHParameters(), this.namedCurves, this.clientECPointFormats, this.serverECPointFormats);
    }
}

