/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.crypto.tls;

import com.sansec.crypto.DSA;
import com.sansec.crypto.params.AsymmetricKeyParameter;
import com.sansec.crypto.params.ECPublicKeyParameters;
import com.sansec.crypto.signers.ECDSASigner;
import com.sansec.crypto.signers.HMacDSAKCalculator;
import com.sansec.crypto.tls.TlsDSASigner;
import com.sansec.crypto.tls.TlsUtils;

public class TlsECDSASigner
extends TlsDSASigner {
    @Override
    public boolean isValidPublicKey(AsymmetricKeyParameter publicKey) {
        return publicKey instanceof ECPublicKeyParameters;
    }

    @Override
    protected DSA createDSAImpl(short hashAlgorithm) {
        return new ECDSASigner(new HMacDSAKCalculator(TlsUtils.createHash(hashAlgorithm)));
    }

    @Override
    protected short getSignatureAlgorithm() {
        return 3;
    }
}

