/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.crypto.util;

import com.sansec.asn1.ASN1Integer;
import com.sansec.asn1.ASN1ObjectIdentifier;
import com.sansec.asn1.ASN1Set;
import com.sansec.asn1.DERBitString;
import com.sansec.asn1.DERNull;
import com.sansec.asn1.DEROctetString;
import com.sansec.asn1.cryptopro.CryptoProObjectIdentifiers;
import com.sansec.asn1.cryptopro.GOST3410PublicKeyAlgParameters;
import com.sansec.asn1.edec.EdECObjectIdentifiers;
import com.sansec.asn1.pkcs.PKCSObjectIdentifiers;
import com.sansec.asn1.pkcs.PrivateKeyInfo;
import com.sansec.asn1.pkcs.RSAPrivateKey;
import com.sansec.asn1.rosstandart.RosstandartObjectIdentifiers;
import com.sansec.asn1.sec.ECPrivateKey;
import com.sansec.asn1.x509.AlgorithmIdentifier;
import com.sansec.asn1.x509.DSAParameter;
import com.sansec.asn1.x9.X962Parameters;
import com.sansec.asn1.x9.X9ECParameters;
import com.sansec.asn1.x9.X9ECPoint;
import com.sansec.asn1.x9.X9ObjectIdentifiers;
import com.sansec.crypto.params.AsymmetricKeyParameter;
import com.sansec.crypto.params.DSAParameters;
import com.sansec.crypto.params.DSAPrivateKeyParameters;
import com.sansec.crypto.params.ECDomainParameters;
import com.sansec.crypto.params.ECGOST3410Parameters;
import com.sansec.crypto.params.ECNamedDomainParameters;
import com.sansec.crypto.params.ECPrivateKeyParameters;
import com.sansec.crypto.params.Ed25519PrivateKeyParameters;
import com.sansec.crypto.params.Ed448PrivateKeyParameters;
import com.sansec.crypto.params.RSAKeyParameters;
import com.sansec.crypto.params.RSAPrivateCrtKeyParameters;
import com.sansec.crypto.params.X25519PrivateKeyParameters;
import com.sansec.crypto.params.X448PrivateKeyParameters;
import com.sansec.math.ec.ECPoint;
import com.sansec.math.ec.FixedPointCombMultiplier;
import java.io.IOException;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.Set;

public class PrivateKeyInfoFactory {
    private static Set cryptoProOids = new HashSet(5);

    private PrivateKeyInfoFactory() {
    }

    public static PrivateKeyInfo createPrivateKeyInfo(AsymmetricKeyParameter privateKey) throws IOException {
        return PrivateKeyInfoFactory.createPrivateKeyInfo(privateKey, null);
    }

    public static PrivateKeyInfo createPrivateKeyInfo(AsymmetricKeyParameter privateKey, ASN1Set attributes) throws IOException {
        if (privateKey instanceof RSAKeyParameters) {
            RSAPrivateCrtKeyParameters priv = (RSAPrivateCrtKeyParameters)privateKey;
            return new PrivateKeyInfo(new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, DERNull.INSTANCE), new RSAPrivateKey(priv.getModulus(), priv.getPublicExponent(), priv.getExponent(), priv.getP(), priv.getQ(), priv.getDP(), priv.getDQ(), priv.getQInv()), attributes);
        }
        if (privateKey instanceof DSAPrivateKeyParameters) {
            DSAPrivateKeyParameters priv = (DSAPrivateKeyParameters)privateKey;
            DSAParameters params = priv.getParameters();
            return new PrivateKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_dsa, new DSAParameter(params.getP(), params.getQ(), params.getG())), new ASN1Integer(priv.getX()), attributes);
        }
        if (privateKey instanceof ECPrivateKeyParameters) {
            int orderBitLength;
            X962Parameters params;
            ECPrivateKeyParameters priv = (ECPrivateKeyParameters)privateKey;
            ECDomainParameters domainParams = priv.getParameters();
            if (domainParams == null) {
                params = new X962Parameters(DERNull.INSTANCE);
                orderBitLength = priv.getD().bitLength();
            } else {
                if (domainParams instanceof ECGOST3410Parameters) {
                    ASN1ObjectIdentifier identifier;
                    int size;
                    GOST3410PublicKeyAlgParameters gostParams = new GOST3410PublicKeyAlgParameters(((ECGOST3410Parameters)domainParams).getPublicKeyParamSet(), ((ECGOST3410Parameters)domainParams).getDigestParamSet(), ((ECGOST3410Parameters)domainParams).getEncryptionParamSet());
                    if (cryptoProOids.contains(gostParams.getPublicKeyParamSet())) {
                        size = 32;
                        identifier = CryptoProObjectIdentifiers.gostR3410_2001;
                    } else {
                        boolean is512 = priv.getD().bitLength() > 256;
                        identifier = is512 ? RosstandartObjectIdentifiers.id_tc26_gost_3410_12_512 : RosstandartObjectIdentifiers.id_tc26_gost_3410_12_256;
                        size = is512 ? 64 : 32;
                    }
                    byte[] encKey = new byte[size];
                    PrivateKeyInfoFactory.extractBytes(encKey, size, 0, priv.getD());
                    return new PrivateKeyInfo(new AlgorithmIdentifier(identifier, gostParams), new DEROctetString(encKey));
                }
                if (domainParams instanceof ECNamedDomainParameters) {
                    params = new X962Parameters(((ECNamedDomainParameters)domainParams).getName());
                    orderBitLength = domainParams.getN().bitLength();
                } else {
                    X9ECParameters ecP = new X9ECParameters(domainParams.getCurve(), new X9ECPoint(domainParams.getG(), false), domainParams.getN(), domainParams.getH(), domainParams.getSeed());
                    params = new X962Parameters(ecP);
                    orderBitLength = domainParams.getN().bitLength();
                }
            }
            ECPoint q = new FixedPointCombMultiplier().multiply(domainParams.getG(), priv.getD());
            DERBitString publicKey = new DERBitString(q.getEncoded(false));
            return new PrivateKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, params), new ECPrivateKey(orderBitLength, priv.getD(), publicKey, params), attributes);
        }
        if (privateKey instanceof X448PrivateKeyParameters) {
            X448PrivateKeyParameters key = (X448PrivateKeyParameters)privateKey;
            return new PrivateKeyInfo(new AlgorithmIdentifier(EdECObjectIdentifiers.id_X448), new DEROctetString(key.getEncoded()), attributes, key.generatePublicKey().getEncoded());
        }
        if (privateKey instanceof X25519PrivateKeyParameters) {
            X25519PrivateKeyParameters key = (X25519PrivateKeyParameters)privateKey;
            return new PrivateKeyInfo(new AlgorithmIdentifier(EdECObjectIdentifiers.id_X25519), new DEROctetString(key.getEncoded()), attributes, key.generatePublicKey().getEncoded());
        }
        if (privateKey instanceof Ed448PrivateKeyParameters) {
            Ed448PrivateKeyParameters key = (Ed448PrivateKeyParameters)privateKey;
            return new PrivateKeyInfo(new AlgorithmIdentifier(EdECObjectIdentifiers.id_Ed448), new DEROctetString(key.getEncoded()), attributes, key.generatePublicKey().getEncoded());
        }
        if (privateKey instanceof Ed25519PrivateKeyParameters) {
            Ed25519PrivateKeyParameters key = (Ed25519PrivateKeyParameters)privateKey;
            return new PrivateKeyInfo(new AlgorithmIdentifier(EdECObjectIdentifiers.id_Ed25519), new DEROctetString(key.getEncoded()), attributes, key.generatePublicKey().getEncoded());
        }
        throw new IOException("key parameters not recognized");
    }

    private static void extractBytes(byte[] encKey, int size, int offSet, BigInteger bI) {
        byte[] val = bI.toByteArray();
        if (val.length < size) {
            byte[] tmp = new byte[size];
            System.arraycopy(val, 0, tmp, tmp.length - val.length, val.length);
            val = tmp;
        }
        for (int i = 0; i != size; ++i) {
            encKey[offSet + i] = val[val.length - 1 - i];
        }
    }

    static {
        cryptoProOids.add(CryptoProObjectIdentifiers.gostR3410_2001_CryptoPro_A);
        cryptoProOids.add(CryptoProObjectIdentifiers.gostR3410_2001_CryptoPro_B);
        cryptoProOids.add(CryptoProObjectIdentifiers.gostR3410_2001_CryptoPro_C);
        cryptoProOids.add(CryptoProObjectIdentifiers.gostR3410_2001_CryptoPro_XchA);
        cryptoProOids.add(CryptoProObjectIdentifiers.gostR3410_2001_CryptoPro_XchB);
    }
}

