/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.crypto.util;

import com.sansec.asn1.ASN1Encodable;
import com.sansec.asn1.ASN1InputStream;
import com.sansec.asn1.ASN1Integer;
import com.sansec.asn1.ASN1ObjectIdentifier;
import com.sansec.asn1.ASN1Primitive;
import com.sansec.asn1.DEROctetString;
import com.sansec.asn1.oiw.ElGamalParameter;
import com.sansec.asn1.oiw.OIWObjectIdentifiers;
import com.sansec.asn1.pkcs.DHParameter;
import com.sansec.asn1.pkcs.GBObjectIdentifiers;
import com.sansec.asn1.pkcs.PKCSObjectIdentifiers;
import com.sansec.asn1.pkcs.SM2PublicKeyStructure;
import com.sansec.asn1.x509.AlgorithmIdentifier;
import com.sansec.asn1.x509.DSAParameter;
import com.sansec.asn1.x509.RSAPublicKeyStructure;
import com.sansec.asn1.x509.SubjectPublicKeyInfo;
import com.sansec.asn1.x509.X509ObjectIdentifiers;
import com.sansec.asn1.x9.DHPublicKey;
import com.sansec.asn1.x9.DomainParameters;
import com.sansec.asn1.x9.ECNamedCurveTable;
import com.sansec.asn1.x9.ValidationParams;
import com.sansec.asn1.x9.X962Parameters;
import com.sansec.asn1.x9.X9ECParameters;
import com.sansec.asn1.x9.X9ECPoint;
import com.sansec.asn1.x9.X9ObjectIdentifiers;
import com.sansec.crypto.ec.CustomNamedCurves;
import com.sansec.crypto.params.AsymmetricKeyParameter;
import com.sansec.crypto.params.DHParameters;
import com.sansec.crypto.params.DHPublicKeyParameters;
import com.sansec.crypto.params.DHValidationParameters;
import com.sansec.crypto.params.DSAParameters;
import com.sansec.crypto.params.DSAPublicKeyParameters;
import com.sansec.crypto.params.ECDomainParameters;
import com.sansec.crypto.params.ECNamedDomainParameters;
import com.sansec.crypto.params.ECPublicKeyParameters;
import com.sansec.crypto.params.ElGamalParameters;
import com.sansec.crypto.params.ElGamalPublicKeyParameters;
import com.sansec.crypto.params.RSAKeyParameters;
import com.sansec.crypto.params.SM2KeyParameters;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;

public class PublicKeyFactory {
    public static AsymmetricKeyParameter createKey(byte[] keyInfoData) throws IOException {
        return PublicKeyFactory.createKey(SubjectPublicKeyInfo.getInstance(ASN1Primitive.fromByteArray(keyInfoData)));
    }

    public static AsymmetricKeyParameter createKey(InputStream inStr) throws IOException {
        return PublicKeyFactory.createKey(SubjectPublicKeyInfo.getInstance(new ASN1InputStream(inStr).readObject()));
    }

    public static AsymmetricKeyParameter createKey(SubjectPublicKeyInfo keyInfo) throws IOException {
        AlgorithmIdentifier algId = keyInfo.getAlgorithm();
        if (algId.getAlgorithm().equals(PKCSObjectIdentifiers.rsaEncryption) || algId.getAlgorithm().equals(X509ObjectIdentifiers.id_ea_rsa)) {
            RSAPublicKeyStructure pubKey = RSAPublicKeyStructure.getInstance(keyInfo.parsePublicKey());
            return new RSAKeyParameters(false, pubKey.getModulus(), pubKey.getPublicExponent());
        }
        if (algId.getAlgorithm().equals(X9ObjectIdentifiers.dhpublicnumber)) {
            DHPublicKey dhPublicKey = DHPublicKey.getInstance(keyInfo.parsePublicKey());
            BigInteger y = dhPublicKey.getY();
            DomainParameters dhParams = DomainParameters.getInstance(algId.getParameters());
            BigInteger p = dhParams.getP();
            BigInteger g = dhParams.getG();
            BigInteger q = dhParams.getQ();
            BigInteger j = null;
            if (dhParams.getJ() != null) {
                j = dhParams.getJ();
            }
            DHValidationParameters validation = null;
            ValidationParams dhValidationParms = dhParams.getValidationParams();
            if (dhValidationParms != null) {
                byte[] seed = dhValidationParms.getSeed();
                BigInteger pgenCounter = dhValidationParms.getPgenCounter();
                validation = new DHValidationParameters(seed, pgenCounter.intValue());
            }
            return new DHPublicKeyParameters(y, new DHParameters(p, g, q, j, validation));
        }
        if (algId.getAlgorithm().equals(PKCSObjectIdentifiers.dhKeyAgreement)) {
            DHParameter params = DHParameter.getInstance(algId.getParameters());
            ASN1Integer derY = (ASN1Integer)keyInfo.parsePublicKey();
            BigInteger lVal = params.getL();
            int l = lVal == null ? 0 : lVal.intValue();
            DHParameters dhParams = new DHParameters(params.getP(), params.getG(), null, l);
            return new DHPublicKeyParameters(derY.getValue(), dhParams);
        }
        if (algId.getAlgorithm().equals(OIWObjectIdentifiers.elGamalAlgorithm)) {
            ElGamalParameter params = ElGamalParameter.getInstance(algId.getParameters());
            ASN1Integer derY = (ASN1Integer)keyInfo.parsePublicKey();
            return new ElGamalPublicKeyParameters(derY.getValue(), new ElGamalParameters(params.getP(), params.getG()));
        }
        if (algId.getAlgorithm().equals(X9ObjectIdentifiers.id_dsa) || algId.getAlgorithm().equals(OIWObjectIdentifiers.dsaWithSHA1)) {
            ASN1Integer derY = (ASN1Integer)keyInfo.parsePublicKey();
            ASN1Encodable de = algId.getParameters();
            DSAParameters parameters = null;
            if (de != null) {
                DSAParameter params = DSAParameter.getInstance(de.toASN1Primitive());
                parameters = new DSAParameters(params.getP(), params.getQ(), params.getG());
            }
            return new DSAPublicKeyParameters(derY.getValue(), parameters);
        }
        if (algId.getAlgorithm().equals(X9ObjectIdentifiers.id_ecPublicKey)) {
            ECDomainParameters dParams;
            X9ECParameters x9;
            ASN1ObjectIdentifier paramOID;
            ASN1Encodable parameters = algId.getParameters();
            if (parameters != null && parameters instanceof ASN1ObjectIdentifier && (paramOID = (ASN1ObjectIdentifier)parameters).equals(GBObjectIdentifiers.sm2)) {
                SM2PublicKeyStructure pubKey = new SM2PublicKeyStructure(keyInfo.getPublicKeyData());
                return new SM2KeyParameters(256, false, pubKey.getQ().getAffineX(), pubKey.getQ().getAffineX());
            }
            X962Parameters params = X962Parameters.getInstance(algId.getParameters());
            if (params.isNamedCurve()) {
                ASN1ObjectIdentifier oid = (ASN1ObjectIdentifier)params.getParameters();
                x9 = CustomNamedCurves.getByOID(oid);
                if (x9 == null) {
                    x9 = ECNamedCurveTable.getByOID(oid);
                }
                dParams = new ECNamedDomainParameters(oid, x9.getCurve(), x9.getG(), x9.getN(), x9.getH(), x9.getSeed());
            } else {
                x9 = X9ECParameters.getInstance(params.getParameters());
                dParams = new ECDomainParameters(x9.getCurve(), x9.getG(), x9.getN(), x9.getH(), x9.getSeed());
            }
            DEROctetString key = new DEROctetString(keyInfo.getPublicKeyData().getBytes());
            X9ECPoint derQ = new X9ECPoint(x9.getCurve(), key);
            return new ECPublicKeyParameters(derQ.getPoint(), dParams);
        }
        throw new RuntimeException("algorithm identifier in key not recognised");
    }
}

