/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.jcajce.provider.asymmetric;

import com.sansec.asn1.bsi.BSIObjectIdentifiers;
import com.sansec.asn1.eac.EACObjectIdentifiers;
import com.sansec.asn1.nist.NISTObjectIdentifiers;
import com.sansec.asn1.sec.SECObjectIdentifiers;
import com.sansec.asn1.teletrust.TeleTrusTObjectIdentifiers;
import com.sansec.asn1.x9.X9ObjectIdentifiers;
import com.sansec.jcajce.provider.asymmetric.ec.KeyFactorySpi;
import com.sansec.jcajce.provider.config.ConfigurableProvider;
import com.sansec.jcajce.provider.util.AsymmetricAlgorithmProvider;
import com.sansec.util.Properties;

public class EC {
    private static final String PREFIX = "com.sansec.jcajce.provider.asymmetric.ec.";

    public static class Mappings
    extends AsymmetricAlgorithmProvider {
        @Override
        public void configure(ConfigurableProvider provider) {
            provider.addAlgorithm("AlgorithmParameters.EC", "com.sansec.jcajce.provider.asymmetric.ec.ECAlgorithmParametersSpi");
            provider.addAlgorithm("KeyAgreement.ECDH", "com.sansec.jcajce.provider.asymmetric.ec.KeyAgreementSpi$DH");
            provider.addAlgorithm("KeyAgreement.ECDHC", "com.sansec.jcajce.provider.asymmetric.ec.KeyAgreementSpi$DHC");
            provider.addAlgorithm("KeyAgreement.ECCDH", "com.sansec.jcajce.provider.asymmetric.ec.KeyAgreementSpi$DHC");
            provider.addAlgorithm("KeyAgreement." + X9ObjectIdentifiers.dhSinglePass_stdDH_sha1kdf_scheme, "com.sansec.jcajce.provider.asymmetric.ec.KeyAgreementSpi$DHwithSHA1KDFAndSharedInfo");
            provider.addAlgorithm("KeyAgreement." + X9ObjectIdentifiers.dhSinglePass_cofactorDH_sha1kdf_scheme, "com.sansec.jcajce.provider.asymmetric.ec.KeyAgreementSpi$CDHwithSHA1KDFAndSharedInfo");
            provider.addAlgorithm("KeyAgreement." + SECObjectIdentifiers.dhSinglePass_stdDH_sha224kdf_scheme, "com.sansec.jcajce.provider.asymmetric.ec.KeyAgreementSpi$DHwithSHA224KDFAndSharedInfo");
            provider.addAlgorithm("KeyAgreement." + SECObjectIdentifiers.dhSinglePass_cofactorDH_sha224kdf_scheme, "com.sansec.jcajce.provider.asymmetric.ec.KeyAgreementSpi$CDHwithSHA224KDFAndSharedInfo");
            provider.addAlgorithm("KeyAgreement." + SECObjectIdentifiers.dhSinglePass_stdDH_sha256kdf_scheme, "com.sansec.jcajce.provider.asymmetric.ec.KeyAgreementSpi$DHwithSHA256KDFAndSharedInfo");
            provider.addAlgorithm("KeyAgreement." + SECObjectIdentifiers.dhSinglePass_cofactorDH_sha256kdf_scheme, "com.sansec.jcajce.provider.asymmetric.ec.KeyAgreementSpi$CDHwithSHA256KDFAndSharedInfo");
            provider.addAlgorithm("KeyAgreement." + SECObjectIdentifiers.dhSinglePass_stdDH_sha384kdf_scheme, "com.sansec.jcajce.provider.asymmetric.ec.KeyAgreementSpi$DHwithSHA384KDFAndSharedInfo");
            provider.addAlgorithm("KeyAgreement." + SECObjectIdentifiers.dhSinglePass_cofactorDH_sha384kdf_scheme, "com.sansec.jcajce.provider.asymmetric.ec.KeyAgreementSpi$CDHwithSHA384KDFAndSharedInfo");
            provider.addAlgorithm("KeyAgreement." + SECObjectIdentifiers.dhSinglePass_stdDH_sha512kdf_scheme, "com.sansec.jcajce.provider.asymmetric.ec.KeyAgreementSpi$DHwithSHA512KDFAndSharedInfo");
            provider.addAlgorithm("KeyAgreement." + SECObjectIdentifiers.dhSinglePass_cofactorDH_sha512kdf_scheme, "com.sansec.jcajce.provider.asymmetric.ec.KeyAgreementSpi$CDHwithSHA512KDFAndSharedInfo");
            provider.addAlgorithm("KeyAgreement.ECDHWITHSHA1KDF", "com.sansec.jcajce.provider.asymmetric.ec.KeyAgreementSpi$DHwithSHA1KDF");
            provider.addAlgorithm("KeyAgreement.ECCDHWITHSHA1CKDF", "com.sansec.jcajce.provider.asymmetric.ec.KeyAgreementSpi$DHwithSHA1CKDF");
            provider.addAlgorithm("KeyAgreement.ECCDHWITHSHA256CKDF", "com.sansec.jcajce.provider.asymmetric.ec.KeyAgreementSpi$DHwithSHA256CKDF");
            provider.addAlgorithm("KeyAgreement.ECCDHWITHSHA384CKDF", "com.sansec.jcajce.provider.asymmetric.ec.KeyAgreementSpi$DHwithSHA384CKDF");
            provider.addAlgorithm("KeyAgreement.ECCDHWITHSHA512CKDF", "com.sansec.jcajce.provider.asymmetric.ec.KeyAgreementSpi$DHwithSHA512CKDF");
            this.registerOid(provider, X9ObjectIdentifiers.id_ecPublicKey, "EC", new KeyFactorySpi.EC());
            this.registerOid(provider, X9ObjectIdentifiers.dhSinglePass_cofactorDH_sha1kdf_scheme, "EC", new KeyFactorySpi.EC());
            this.registerOid(provider, X9ObjectIdentifiers.mqvSinglePass_sha1kdf_scheme, "ECMQV", new KeyFactorySpi.ECMQV());
            this.registerOid(provider, SECObjectIdentifiers.dhSinglePass_stdDH_sha224kdf_scheme, "EC", new KeyFactorySpi.EC());
            this.registerOid(provider, SECObjectIdentifiers.dhSinglePass_cofactorDH_sha224kdf_scheme, "EC", new KeyFactorySpi.EC());
            this.registerOid(provider, SECObjectIdentifiers.dhSinglePass_stdDH_sha256kdf_scheme, "EC", new KeyFactorySpi.EC());
            this.registerOid(provider, SECObjectIdentifiers.dhSinglePass_cofactorDH_sha256kdf_scheme, "EC", new KeyFactorySpi.EC());
            this.registerOid(provider, SECObjectIdentifiers.dhSinglePass_stdDH_sha384kdf_scheme, "EC", new KeyFactorySpi.EC());
            this.registerOid(provider, SECObjectIdentifiers.dhSinglePass_cofactorDH_sha384kdf_scheme, "EC", new KeyFactorySpi.EC());
            this.registerOid(provider, SECObjectIdentifiers.dhSinglePass_stdDH_sha512kdf_scheme, "EC", new KeyFactorySpi.EC());
            this.registerOid(provider, SECObjectIdentifiers.dhSinglePass_cofactorDH_sha512kdf_scheme, "EC", new KeyFactorySpi.EC());
            this.registerOidAlgorithmParameters(provider, X9ObjectIdentifiers.id_ecPublicKey, "EC");
            this.registerOidAlgorithmParameters(provider, X9ObjectIdentifiers.dhSinglePass_stdDH_sha1kdf_scheme, "EC");
            this.registerOidAlgorithmParameters(provider, X9ObjectIdentifiers.dhSinglePass_cofactorDH_sha1kdf_scheme, "EC");
            this.registerOidAlgorithmParameters(provider, SECObjectIdentifiers.dhSinglePass_stdDH_sha224kdf_scheme, "EC");
            this.registerOidAlgorithmParameters(provider, SECObjectIdentifiers.dhSinglePass_cofactorDH_sha224kdf_scheme, "EC");
            this.registerOidAlgorithmParameters(provider, SECObjectIdentifiers.dhSinglePass_stdDH_sha256kdf_scheme, "EC");
            this.registerOidAlgorithmParameters(provider, SECObjectIdentifiers.dhSinglePass_cofactorDH_sha256kdf_scheme, "EC");
            this.registerOidAlgorithmParameters(provider, SECObjectIdentifiers.dhSinglePass_stdDH_sha384kdf_scheme, "EC");
            this.registerOidAlgorithmParameters(provider, SECObjectIdentifiers.dhSinglePass_cofactorDH_sha384kdf_scheme, "EC");
            this.registerOidAlgorithmParameters(provider, SECObjectIdentifiers.dhSinglePass_stdDH_sha512kdf_scheme, "EC");
            this.registerOidAlgorithmParameters(provider, SECObjectIdentifiers.dhSinglePass_cofactorDH_sha512kdf_scheme, "EC");
            if (!Properties.isOverrideSet("com.sansec.ec.disable_mqv")) {
                provider.addAlgorithm("KeyAgreement.ECMQV", "com.sansec.jcajce.provider.asymmetric.ec.KeyAgreementSpi$MQV");
                provider.addAlgorithm("KeyAgreement.ECMQVWITHSHA1CKDF", "com.sansec.jcajce.provider.asymmetric.ec.KeyAgreementSpi$MQVwithSHA1CKDF");
                provider.addAlgorithm("KeyAgreement.ECMQVWITHSHA224CKDF", "com.sansec.jcajce.provider.asymmetric.ec.KeyAgreementSpi$MQVwithSHA224CKDF");
                provider.addAlgorithm("KeyAgreement.ECMQVWITHSHA256CKDF", "com.sansec.jcajce.provider.asymmetric.ec.KeyAgreementSpi$MQVwithSHA256CKDF");
                provider.addAlgorithm("KeyAgreement.ECMQVWITHSHA384CKDF", "com.sansec.jcajce.provider.asymmetric.ec.KeyAgreementSpi$MQVwithSHA384CKDF");
                provider.addAlgorithm("KeyAgreement.ECMQVWITHSHA512CKDF", "com.sansec.jcajce.provider.asymmetric.ec.KeyAgreementSpi$MQVwithSHA512CKDF");
                provider.addAlgorithm("KeyAgreement." + X9ObjectIdentifiers.mqvSinglePass_sha1kdf_scheme, "com.sansec.jcajce.provider.asymmetric.ec.KeyAgreementSpi$MQVwithSHA1KDFAndSharedInfo");
                provider.addAlgorithm("KeyAgreement." + SECObjectIdentifiers.mqvSinglePass_sha224kdf_scheme, "com.sansec.jcajce.provider.asymmetric.ec.KeyAgreementSpi$MQVwithSHA224KDFAndSharedInfo");
                provider.addAlgorithm("KeyAgreement." + SECObjectIdentifiers.mqvSinglePass_sha256kdf_scheme, "com.sansec.jcajce.provider.asymmetric.ec.KeyAgreementSpi$MQVwithSHA256KDFAndSharedInfo");
                provider.addAlgorithm("KeyAgreement." + SECObjectIdentifiers.mqvSinglePass_sha384kdf_scheme, "com.sansec.jcajce.provider.asymmetric.ec.KeyAgreementSpi$MQVwithSHA384KDFAndSharedInfo");
                provider.addAlgorithm("KeyAgreement." + SECObjectIdentifiers.mqvSinglePass_sha512kdf_scheme, "com.sansec.jcajce.provider.asymmetric.ec.KeyAgreementSpi$MQVwithSHA512KDFAndSharedInfo");
                this.registerOid(provider, X9ObjectIdentifiers.dhSinglePass_stdDH_sha1kdf_scheme, "EC", new KeyFactorySpi.EC());
                this.registerOidAlgorithmParameters(provider, X9ObjectIdentifiers.mqvSinglePass_sha1kdf_scheme, "EC");
                this.registerOid(provider, SECObjectIdentifiers.mqvSinglePass_sha224kdf_scheme, "ECMQV", new KeyFactorySpi.ECMQV());
                this.registerOidAlgorithmParameters(provider, SECObjectIdentifiers.mqvSinglePass_sha256kdf_scheme, "EC");
                this.registerOid(provider, SECObjectIdentifiers.mqvSinglePass_sha256kdf_scheme, "ECMQV", new KeyFactorySpi.ECMQV());
                this.registerOidAlgorithmParameters(provider, SECObjectIdentifiers.mqvSinglePass_sha224kdf_scheme, "EC");
                this.registerOid(provider, SECObjectIdentifiers.mqvSinglePass_sha384kdf_scheme, "ECMQV", new KeyFactorySpi.ECMQV());
                this.registerOidAlgorithmParameters(provider, SECObjectIdentifiers.mqvSinglePass_sha384kdf_scheme, "EC");
                this.registerOid(provider, SECObjectIdentifiers.mqvSinglePass_sha512kdf_scheme, "ECMQV", new KeyFactorySpi.ECMQV());
                this.registerOidAlgorithmParameters(provider, SECObjectIdentifiers.mqvSinglePass_sha512kdf_scheme, "EC");
                provider.addAlgorithm("KeyFactory.ECMQV", "com.sansec.jcajce.provider.asymmetric.ec.KeyFactorySpi$ECMQV");
                provider.addAlgorithm("KeyPairGenerator.ECMQV", "com.sansec.jcajce.provider.asymmetric.ec.KeyPairGeneratorSpi$ECMQV");
            }
            provider.addAlgorithm("KeyFactory.EC", "com.sansec.jcajce.provider.asymmetric.ec.KeyFactorySpi$EC");
            provider.addAlgorithm("KeyFactory.ECDSA", "com.sansec.jcajce.provider.asymmetric.ec.KeyFactorySpi$ECDSA");
            provider.addAlgorithm("KeyFactory.ECDH", "com.sansec.jcajce.provider.asymmetric.ec.KeyFactorySpi$ECDH");
            provider.addAlgorithm("KeyFactory.ECDHC", "com.sansec.jcajce.provider.asymmetric.ec.KeyFactorySpi$ECDHC");
            provider.addAlgorithm("KeyPairGenerator.EC", "com.sansec.jcajce.provider.asymmetric.ec.KeyPairGeneratorSpi$EC");
            provider.addAlgorithm("KeyPairGenerator.ECDSA", "com.sansec.jcajce.provider.asymmetric.ec.KeyPairGeneratorSpi$ECDSA");
            provider.addAlgorithm("KeyPairGenerator.ECDH", "com.sansec.jcajce.provider.asymmetric.ec.KeyPairGeneratorSpi$ECDH");
            provider.addAlgorithm("KeyPairGenerator.ECDHWITHSHA1KDF", "com.sansec.jcajce.provider.asymmetric.ec.KeyPairGeneratorSpi$ECDH");
            provider.addAlgorithm("KeyPairGenerator.ECDHC", "com.sansec.jcajce.provider.asymmetric.ec.KeyPairGeneratorSpi$ECDHC");
            provider.addAlgorithm("KeyPairGenerator.ECIES", "com.sansec.jcajce.provider.asymmetric.ec.KeyPairGeneratorSpi$ECDH");
            provider.addAlgorithm("Cipher.ECIES", "com.sansec.jcajce.provider.asymmetric.ec.IESCipher$ECIES");
            provider.addAlgorithm("Cipher.ECIESwithAES", "com.sansec.jcajce.provider.asymmetric.ec.IESCipher$ECIESwithAES");
            provider.addAlgorithm("Cipher.ECIESWITHAES", "com.sansec.jcajce.provider.asymmetric.ec.IESCipher$ECIESwithAES");
            provider.addAlgorithm("Cipher.ECIESwithDESEDE", "com.sansec.jcajce.provider.asymmetric.ec.IESCipher$ECIESwithDESede");
            provider.addAlgorithm("Cipher.ECIESWITHDESEDE", "com.sansec.jcajce.provider.asymmetric.ec.IESCipher$ECIESwithDESede");
            provider.addAlgorithm("Cipher.ECIESwithAES-CBC", "com.sansec.jcajce.provider.asymmetric.ec.IESCipher$ECIESwithAESCBC");
            provider.addAlgorithm("Cipher.ECIESWITHAES-CBC", "com.sansec.jcajce.provider.asymmetric.ec.IESCipher$ECIESwithAESCBC");
            provider.addAlgorithm("Cipher.ECIESwithDESEDE-CBC", "com.sansec.jcajce.provider.asymmetric.ec.IESCipher$ECIESwithDESedeCBC");
            provider.addAlgorithm("Cipher.ECIESWITHDESEDE-CBC", "com.sansec.jcajce.provider.asymmetric.ec.IESCipher$ECIESwithDESedeCBC");
            provider.addAlgorithm("Cipher.OldECIES", "com.sansec.jcajce.provider.asymmetric.ec.IESCipher$OldECIES");
            provider.addAlgorithm("Cipher.OldECIESwithAES", "com.sansec.jcajce.provider.asymmetric.ec.IESCipher$OldECIESwithAES");
            provider.addAlgorithm("Cipher.OldECIESWITHAES", "com.sansec.jcajce.provider.asymmetric.ec.IESCipher$OldECIESwithAES");
            provider.addAlgorithm("Cipher.OldECIESwithDESEDE", "com.sansec.jcajce.provider.asymmetric.ec.IESCipher$OldECIESwithDESede");
            provider.addAlgorithm("Cipher.OldECIESWITHDESEDE", "com.sansec.jcajce.provider.asymmetric.ec.IESCipher$OldECIESwithDESede");
            provider.addAlgorithm("Cipher.OldECIESwithAES-CBC", "com.sansec.jcajce.provider.asymmetric.ec.IESCipher$OldECIESwithAESCBC");
            provider.addAlgorithm("Cipher.OldECIESWITHAES-CBC", "com.sansec.jcajce.provider.asymmetric.ec.IESCipher$OldECIESwithAESCBC");
            provider.addAlgorithm("Cipher.OldECIESwithDESEDE-CBC", "com.sansec.jcajce.provider.asymmetric.ec.IESCipher$OldECIESwithDESedeCBC");
            provider.addAlgorithm("Cipher.OldECIESWITHDESEDE-CBC", "com.sansec.jcajce.provider.asymmetric.ec.IESCipher$OldECIESwithDESedeCBC");
            provider.addAlgorithm("Signature.ECDSA", "com.sansec.jcajce.provider.asymmetric.ec.SignatureSpi$ecDSA");
            provider.addAlgorithm("Signature.NONEwithECDSA", "com.sansec.jcajce.provider.asymmetric.ec.SignatureSpi$ecDSAnone");
            provider.addAlgorithm("Alg.Alias.Signature.SHA1withECDSA", "ECDSA");
            provider.addAlgorithm("Alg.Alias.Signature.ECDSAwithSHA1", "ECDSA");
            provider.addAlgorithm("Alg.Alias.Signature.SHA1WITHECDSA", "ECDSA");
            provider.addAlgorithm("Alg.Alias.Signature.ECDSAWITHSHA1", "ECDSA");
            provider.addAlgorithm("Alg.Alias.Signature.SHA1WithECDSA", "ECDSA");
            provider.addAlgorithm("Alg.Alias.Signature.ECDSAWithSHA1", "ECDSA");
            provider.addAlgorithm("Alg.Alias.Signature.1.2.840.10045.4.1", "ECDSA");
            provider.addAlgorithm("Alg.Alias.Signature." + TeleTrusTObjectIdentifiers.ecSignWithSha1, "ECDSA");
            provider.addAlgorithm("Signature.ECDDSA", "com.sansec.jcajce.provider.asymmetric.ec.SignatureSpi$ecDetDSA");
            provider.addAlgorithm("Signature.SHA1WITHECDDSA", "com.sansec.jcajce.provider.asymmetric.ec.SignatureSpi$ecDetDSA");
            provider.addAlgorithm("Signature.SHA224WITHECDDSA", "com.sansec.jcajce.provider.asymmetric.ec.SignatureSpi$ecDetDSA224");
            provider.addAlgorithm("Signature.SHA256WITHECDDSA", "com.sansec.jcajce.provider.asymmetric.ec.SignatureSpi$ecDetDSA256");
            provider.addAlgorithm("Signature.SHA384WITHECDDSA", "com.sansec.jcajce.provider.asymmetric.ec.SignatureSpi$ecDetDSA384");
            provider.addAlgorithm("Signature.SHA512WITHECDDSA", "com.sansec.jcajce.provider.asymmetric.ec.SignatureSpi$ecDetDSA512");
            provider.addAlgorithm("Signature.SHA3-224WITHECDDSA", "com.sansec.jcajce.provider.asymmetric.ec.SignatureSpi$ecDetDSASha3_224");
            provider.addAlgorithm("Signature.SHA3-256WITHECDDSA", "com.sansec.jcajce.provider.asymmetric.ec.SignatureSpi$ecDetDSASha3_256");
            provider.addAlgorithm("Signature.SHA3-384WITHECDDSA", "com.sansec.jcajce.provider.asymmetric.ec.SignatureSpi$ecDetDSASha3_384");
            provider.addAlgorithm("Signature.SHA3-512WITHECDDSA", "com.sansec.jcajce.provider.asymmetric.ec.SignatureSpi$ecDetDSASha3_512");
            provider.addAlgorithm("Alg.Alias.Signature.DETECDSA", "ECDDSA");
            provider.addAlgorithm("Alg.Alias.Signature.SHA1WITHDETECDSA", "SHA1WITHECDDSA");
            provider.addAlgorithm("Alg.Alias.Signature.SHA224WITHDETECDSA", "SHA224WITHECDDSA");
            provider.addAlgorithm("Alg.Alias.Signature.SHA256WITHDETECDSA", "SHA256WITHECDDSA");
            provider.addAlgorithm("Alg.Alias.Signature.SHA384WITHDETECDSA", "SHA384WITHECDDSA");
            provider.addAlgorithm("Alg.Alias.Signature.SHA512WITHDETECDSA", "SHA512WITHECDDSA");
            this.addSignatureAlgorithm(provider, "SHA224", "ECDSA", "com.sansec.jcajce.provider.asymmetric.ec.SignatureSpi$ecDSA224", X9ObjectIdentifiers.ecdsa_with_SHA224);
            this.addSignatureAlgorithm(provider, "SHA256", "ECDSA", "com.sansec.jcajce.provider.asymmetric.ec.SignatureSpi$ecDSA256", X9ObjectIdentifiers.ecdsa_with_SHA256);
            this.addSignatureAlgorithm(provider, "SHA384", "ECDSA", "com.sansec.jcajce.provider.asymmetric.ec.SignatureSpi$ecDSA384", X9ObjectIdentifiers.ecdsa_with_SHA384);
            this.addSignatureAlgorithm(provider, "SHA512", "ECDSA", "com.sansec.jcajce.provider.asymmetric.ec.SignatureSpi$ecDSA512", X9ObjectIdentifiers.ecdsa_with_SHA512);
            this.addSignatureAlgorithm(provider, "SHA3-224", "ECDSA", "com.sansec.jcajce.provider.asymmetric.ec.SignatureSpi$ecDSASha3_224", NISTObjectIdentifiers.id_ecdsa_with_sha3_224);
            this.addSignatureAlgorithm(provider, "SHA3-256", "ECDSA", "com.sansec.jcajce.provider.asymmetric.ec.SignatureSpi$ecDSASha3_256", NISTObjectIdentifiers.id_ecdsa_with_sha3_256);
            this.addSignatureAlgorithm(provider, "SHA3-384", "ECDSA", "com.sansec.jcajce.provider.asymmetric.ec.SignatureSpi$ecDSASha3_384", NISTObjectIdentifiers.id_ecdsa_with_sha3_384);
            this.addSignatureAlgorithm(provider, "SHA3-512", "ECDSA", "com.sansec.jcajce.provider.asymmetric.ec.SignatureSpi$ecDSASha3_512", NISTObjectIdentifiers.id_ecdsa_with_sha3_512);
            this.addSignatureAlgorithm(provider, "RIPEMD160", "ECDSA", "com.sansec.jcajce.provider.asymmetric.ec.SignatureSpi$ecDSARipeMD160", TeleTrusTObjectIdentifiers.ecSignWithRipemd160);
            provider.addAlgorithm("Signature.SHA1WITHECNR", "com.sansec.jcajce.provider.asymmetric.ec.SignatureSpi$ecNR");
            provider.addAlgorithm("Signature.SHA224WITHECNR", "com.sansec.jcajce.provider.asymmetric.ec.SignatureSpi$ecNR224");
            provider.addAlgorithm("Signature.SHA256WITHECNR", "com.sansec.jcajce.provider.asymmetric.ec.SignatureSpi$ecNR256");
            provider.addAlgorithm("Signature.SHA384WITHECNR", "com.sansec.jcajce.provider.asymmetric.ec.SignatureSpi$ecNR384");
            provider.addAlgorithm("Signature.SHA512WITHECNR", "com.sansec.jcajce.provider.asymmetric.ec.SignatureSpi$ecNR512");
            this.addSignatureAlgorithm(provider, "SHA1", "CVC-ECDSA", "com.sansec.jcajce.provider.asymmetric.ec.SignatureSpi$ecCVCDSA", EACObjectIdentifiers.id_TA_ECDSA_SHA_1);
            this.addSignatureAlgorithm(provider, "SHA224", "CVC-ECDSA", "com.sansec.jcajce.provider.asymmetric.ec.SignatureSpi$ecCVCDSA224", EACObjectIdentifiers.id_TA_ECDSA_SHA_224);
            this.addSignatureAlgorithm(provider, "SHA256", "CVC-ECDSA", "com.sansec.jcajce.provider.asymmetric.ec.SignatureSpi$ecCVCDSA256", EACObjectIdentifiers.id_TA_ECDSA_SHA_256);
            this.addSignatureAlgorithm(provider, "SHA384", "CVC-ECDSA", "com.sansec.jcajce.provider.asymmetric.ec.SignatureSpi$ecCVCDSA384", EACObjectIdentifiers.id_TA_ECDSA_SHA_384);
            this.addSignatureAlgorithm(provider, "SHA512", "CVC-ECDSA", "com.sansec.jcajce.provider.asymmetric.ec.SignatureSpi$ecCVCDSA512", EACObjectIdentifiers.id_TA_ECDSA_SHA_512);
            this.addSignatureAlgorithm(provider, "SHA1", "PLAIN-ECDSA", "com.sansec.jcajce.provider.asymmetric.ec.SignatureSpi$ecCVCDSA", BSIObjectIdentifiers.ecdsa_plain_SHA1);
            this.addSignatureAlgorithm(provider, "SHA224", "PLAIN-ECDSA", "com.sansec.jcajce.provider.asymmetric.ec.SignatureSpi$ecCVCDSA224", BSIObjectIdentifiers.ecdsa_plain_SHA224);
            this.addSignatureAlgorithm(provider, "SHA256", "PLAIN-ECDSA", "com.sansec.jcajce.provider.asymmetric.ec.SignatureSpi$ecCVCDSA256", BSIObjectIdentifiers.ecdsa_plain_SHA256);
            this.addSignatureAlgorithm(provider, "SHA384", "PLAIN-ECDSA", "com.sansec.jcajce.provider.asymmetric.ec.SignatureSpi$ecCVCDSA384", BSIObjectIdentifiers.ecdsa_plain_SHA384);
            this.addSignatureAlgorithm(provider, "SHA512", "PLAIN-ECDSA", "com.sansec.jcajce.provider.asymmetric.ec.SignatureSpi$ecCVCDSA512", BSIObjectIdentifiers.ecdsa_plain_SHA512);
            this.addSignatureAlgorithm(provider, "RIPEMD160", "PLAIN-ECDSA", "com.sansec.jcajce.provider.asymmetric.ec.SignatureSpi$ecPlainDSARP160", BSIObjectIdentifiers.ecdsa_plain_RIPEMD160);
        }
    }
}

