/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.jcajce.provider.asymmetric.dsa;

import com.sansec.crypto.AsymmetricCipherKeyPair;
import com.sansec.crypto.generators.DSAHsmKeyPairGenerator;
import com.sansec.crypto.generators.DSAKeyPairGenerator;
import com.sansec.crypto.generators.DSAParametersGenerator;
import com.sansec.crypto.params.DSAKeyGenerationParameters;
import com.sansec.crypto.params.DSAParameters;
import com.sansec.crypto.params.DSAPrivateKeyParameters;
import com.sansec.crypto.params.DSAPublicKeyParameters;
import com.sansec.jcajce.provider.asymmetric.dsa.SwJCEDSAPrivateKey;
import com.sansec.jcajce.provider.asymmetric.dsa.SwJCEDSAPublicKey;
import com.sansec.jce.provider.SwxaProvider;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.DSAParameterSpec;

public class KeyPairGeneratorSpi
extends KeyPairGenerator {
    DSAKeyGenerationParameters param;
    DSAKeyPairGenerator engine = new DSAKeyPairGenerator();
    int strength = 1024;
    int certainty = 20;
    SecureRandom random = new SecureRandom();
    boolean initialised = false;
    boolean isHsm = SwxaProvider.isHsm(null, "KeyPairGenerator", "DSA");

    public KeyPairGeneratorSpi() {
        super("DSA");
        if (this.isHsm) {
            this.engine = new DSAHsmKeyPairGenerator();
        }
    }

    @Override
    public void initialize(int strength, SecureRandom random) {
        if (!this.isHsm && (strength < 512 || strength > 4096 || strength < 1024 && strength % 64 != 0 || strength >= 1024 && strength % 1024 != 0)) {
            throw new InvalidParameterException("strength must be from 512 - 4096 and a multiple of 1024 above 1024");
        }
        this.strength = strength;
        this.random = random;
        DSAParametersGenerator pGen = new DSAParametersGenerator();
        pGen.init(1024, this.certainty, random);
        this.param = new DSAKeyGenerationParameters(random, pGen.generateParameters());
        this.param.setStrength(strength);
        this.engine.init(this.param);
        this.initialised = true;
    }

    @Override
    public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        if (!(params instanceof DSAParameterSpec)) {
            throw new InvalidAlgorithmParameterException("parameter object not a DSAParameterSpec");
        }
        DSAParameterSpec dsaParams = (DSAParameterSpec)params;
        this.param = new DSAKeyGenerationParameters(random, new DSAParameters(dsaParams.getP(), dsaParams.getQ(), dsaParams.getG()));
        this.engine.init(this.param);
        this.initialised = true;
    }

    @Override
    public KeyPair generateKeyPair() {
        if (!this.initialised) {
            DSAParametersGenerator pGen = new DSAParametersGenerator();
            pGen.init(this.strength, this.certainty, this.random);
            this.param = new DSAKeyGenerationParameters(this.random, pGen.generateParameters());
            this.engine.init(this.param);
            this.initialised = true;
        }
        AsymmetricCipherKeyPair pair = this.engine.generateKeyPair();
        DSAPublicKeyParameters pub = (DSAPublicKeyParameters)pair.getPublic();
        DSAPrivateKeyParameters priv = (DSAPrivateKeyParameters)pair.getPrivate();
        return new KeyPair(new SwJCEDSAPublicKey(pub), new SwJCEDSAPrivateKey(priv));
    }
}

