/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.jcajce.provider.asymmetric.dsa;

import com.sansec.asn1.pkcs.PrivateKeyInfo;
import com.sansec.crypto.params.DSAPrivateKeyParameters;
import com.sansec.crypto.params.SwKeyParams;
import com.sansec.jcajce.provider.asymmetric.dsa.JCEDSAPrivateKey;
import com.sansec.util.KeyIndexUtil;
import java.io.IOException;
import java.math.BigInteger;
import java.security.interfaces.DSAPrivateKey;
import java.security.spec.DSAPrivateKeySpec;

public class SwJCEDSAPrivateKey
extends JCEDSAPrivateKey
implements SwKeyParams {
    private static final long serialVersionUID = 2883451835712788964L;
    private int keyIndex;
    private int keyType;
    private int bits;

    @Override
    public int getKeyIndex() {
        return this.keyIndex;
    }

    @Override
    public int getKeyType() {
        return this.keyType;
    }

    @Override
    public int getBits() {
        return this.bits;
    }

    SwJCEDSAPrivateKey(DSAPrivateKeyParameters key) {
        super(key);
        this.keyIndex = key.getKeyIndex();
        this.keyType = key.getKeyType();
        this.bits = key.getBits();
        this.isSW();
    }

    SwJCEDSAPrivateKey(DSAPrivateKeySpec spec) {
        super(spec);
        this.isSW();
    }

    SwJCEDSAPrivateKey(DSAPrivateKey key) {
        super(key);
        this.isSW();
    }

    SwJCEDSAPrivateKey(PrivateKeyInfo info) throws IOException {
        super(info);
        this.isSW();
    }

    private void isSW() {
        BigInteger d = super.getX();
        int dint = d.intValue();
        if (dint > 0 && dint <= 100 && d.bitLength() < 32) {
            try {
                KeyIndexUtil.KeyIndexStruct struct = KeyIndexUtil.parse2KeyIndex(dint);
                this.keyIndex = struct.keyIndex;
                this.keyType = struct.keyType;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public String toString() {
        if (this.keyIndex == 0) {
            return "External DSA PrivateKey[ Bits = " + this.bits + ", X = " + this.getX() + " ]";
        }
        return "Internal DSA PrivateKey[ KeyIndex = " + this.keyIndex + ", KeyType = " + this.keyType + ",Bits=" + this.bits + " ]";
    }
}

