/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.jcajce.provider.asymmetric.ec;

import com.sansec.asn1.ASN1Encodable;
import com.sansec.asn1.ASN1Integer;
import com.sansec.asn1.ASN1ObjectIdentifier;
import com.sansec.asn1.ASN1Primitive;
import com.sansec.asn1.DERBitString;
import com.sansec.asn1.pkcs.PrivateKeyInfo;
import com.sansec.asn1.x509.AlgorithmIdentifier;
import com.sansec.asn1.x509.SubjectPublicKeyInfo;
import com.sansec.asn1.x9.X962Parameters;
import com.sansec.asn1.x9.X9ObjectIdentifiers;
import com.sansec.crypto.params.ECDomainParameters;
import com.sansec.crypto.params.ECPrivateKeyParameters;
import com.sansec.jcajce.provider.asymmetric.ec.ECUtils;
import com.sansec.jcajce.provider.asymmetric.ec.JCEECPublicKey;
import com.sansec.jcajce.provider.asymmetric.util.EC5Util;
import com.sansec.jcajce.provider.asymmetric.util.ECUtil;
import com.sansec.jcajce.provider.asymmetric.util.PKCS12BagAttributeCarrierImpl;
import com.sansec.jcajce.provider.config.ProviderConfiguration;
import com.sansec.jce.interfaces.ECPointEncoder;
import com.sansec.jce.interfaces.ECPrivateKey;
import com.sansec.jce.interfaces.PKCS12BagAttributeCarrier;
import com.sansec.jce.provider.SwxaProvider;
import com.sansec.jce.spec.ECNamedCurveSpec;
import com.sansec.jce.spec.ECParameterSpec;
import com.sansec.math.ec.ECCurve;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.EllipticCurve;
import java.util.Enumeration;

public class JCEECPrivateKey
implements java.security.interfaces.ECPrivateKey,
ECPrivateKey,
PKCS12BagAttributeCarrier,
ECPointEncoder {
    static final long serialVersionUID = 994553197664784084L;
    private String algorithm = "EC";
    private boolean withCompression;
    private transient BigInteger d;
    private transient java.security.spec.ECParameterSpec ecSpec;
    private transient ProviderConfiguration configuration;
    private transient DERBitString publicKey;
    private transient PKCS12BagAttributeCarrierImpl attrCarrier = new PKCS12BagAttributeCarrierImpl();

    protected JCEECPrivateKey() {
    }

    public JCEECPrivateKey(java.security.interfaces.ECPrivateKey key, ProviderConfiguration configuration) {
        this.d = key.getS();
        this.algorithm = key.getAlgorithm();
        this.ecSpec = key.getParams();
        this.configuration = configuration;
    }

    public JCEECPrivateKey(String algorithm, com.sansec.jce.spec.ECPrivateKeySpec spec, ProviderConfiguration configuration) {
        this.algorithm = algorithm;
        this.d = spec.getD();
        if (spec.getParams() != null) {
            ECCurve curve = spec.getParams().getCurve();
            EllipticCurve ellipticCurve = EC5Util.convertCurve(curve, spec.getParams().getSeed());
            this.ecSpec = EC5Util.convertSpec(ellipticCurve, spec.getParams());
        } else {
            this.ecSpec = null;
        }
        this.configuration = configuration;
    }

    public JCEECPrivateKey(String algorithm, ECPrivateKeySpec spec, ProviderConfiguration configuration) {
        this.algorithm = algorithm;
        this.d = spec.getS();
        this.ecSpec = spec.getParams();
        this.configuration = configuration;
    }

    public JCEECPrivateKey(String algorithm, JCEECPrivateKey key) {
        this.algorithm = algorithm;
        this.d = key.d;
        this.ecSpec = key.ecSpec;
        this.withCompression = key.withCompression;
        this.attrCarrier = key.attrCarrier;
        this.publicKey = key.publicKey;
        this.configuration = key.configuration;
    }

    public JCEECPrivateKey(String algorithm, ECPrivateKeyParameters params, JCEECPublicKey pubKey, java.security.spec.ECParameterSpec spec, ProviderConfiguration configuration) {
        this.algorithm = algorithm;
        this.d = params.getD();
        this.configuration = configuration;
        if (spec == null) {
            ECDomainParameters dp = params.getParameters();
            EllipticCurve ellipticCurve = EC5Util.convertCurve(dp.getCurve(), dp.getSeed());
            this.ecSpec = new java.security.spec.ECParameterSpec(ellipticCurve, EC5Util.convertPoint(dp.getG()), dp.getN(), dp.getH().intValue());
        } else {
            this.ecSpec = spec;
        }
        this.publicKey = this.getPublicKeyDetails(pubKey);
    }

    public JCEECPrivateKey(String algorithm, ECPrivateKeyParameters params, JCEECPublicKey pubKey, ECParameterSpec spec, ProviderConfiguration configuration) {
        this.algorithm = algorithm;
        this.d = params.getD();
        this.configuration = configuration;
        if (spec == null) {
            ECDomainParameters dp = params.getParameters();
            EllipticCurve ellipticCurve = EC5Util.convertCurve(dp.getCurve(), dp.getSeed());
            this.ecSpec = new java.security.spec.ECParameterSpec(ellipticCurve, EC5Util.convertPoint(dp.getG()), dp.getN(), dp.getH().intValue());
        } else {
            EllipticCurve ellipticCurve = EC5Util.convertCurve(spec.getCurve(), spec.getSeed());
            this.ecSpec = EC5Util.convertSpec(ellipticCurve, spec);
        }
        try {
            this.publicKey = this.getPublicKeyDetails(pubKey);
        }
        catch (Exception e) {
            this.publicKey = null;
        }
    }

    public JCEECPrivateKey(String algorithm, ECPrivateKeyParameters params, ProviderConfiguration configuration) {
        this.algorithm = algorithm;
        this.d = params.getD();
        this.ecSpec = null;
        this.configuration = configuration;
    }

    JCEECPrivateKey(String algorithm, PrivateKeyInfo info, ProviderConfiguration configuration) throws IOException {
        this.algorithm = algorithm;
        this.configuration = configuration;
        this.populateFromPrivKeyInfo(info);
    }

    private void populateFromPrivKeyInfo(PrivateKeyInfo info) throws IOException {
        X962Parameters params = X962Parameters.getInstance(info.getPrivateKeyAlgorithm().getParameters());
        ECCurve curve = EC5Util.getCurve(this.configuration, params);
        this.ecSpec = EC5Util.convertToSpec(params, curve);
        ASN1Encodable privKey = info.parsePrivateKey();
        if (privKey instanceof ASN1Integer) {
            ASN1Integer derD = ASN1Integer.getInstance(privKey);
            this.d = derD.getValue();
        } else {
            com.sansec.asn1.sec.ECPrivateKey ec = com.sansec.asn1.sec.ECPrivateKey.getInstance(privKey);
            this.d = ec.getKey();
            this.publicKey = ec.getPublicKey();
        }
    }

    @Override
    public String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public String getFormat() {
        return "PKCS#8";
    }

    @Override
    public byte[] getEncoded() {
        X962Parameters params = ECUtils.getDomainParametersFromName(this.ecSpec, this.withCompression);
        int orderBitLength = this.ecSpec == null ? ECUtil.getOrderBitLength(this.configuration, null, this.getS()) : ECUtil.getOrderBitLength(this.configuration, this.ecSpec.getOrder(), this.getS());
        com.sansec.asn1.sec.ECPrivateKey keyStructure = this.publicKey != null ? new com.sansec.asn1.sec.ECPrivateKey(orderBitLength, this.getS(), this.publicKey, params) : new com.sansec.asn1.sec.ECPrivateKey(orderBitLength, this.getS(), (ASN1Encodable)params);
        try {
            PrivateKeyInfo info = new PrivateKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, params), keyStructure);
            return info.getEncoded("DER");
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public java.security.spec.ECParameterSpec getParams() {
        return this.ecSpec;
    }

    @Override
    public ECParameterSpec getParameters() {
        if (this.ecSpec == null) {
            return null;
        }
        return EC5Util.convertSpec(this.ecSpec);
    }

    ECParameterSpec engineGetSpec() {
        if (this.ecSpec != null) {
            return EC5Util.convertSpec(this.ecSpec);
        }
        return this.configuration.getEcImplicitlyCa();
    }

    @Override
    public BigInteger getS() {
        return this.d;
    }

    @Override
    public BigInteger getD() {
        return this.d;
    }

    @Override
    public int getKeyIndex() {
        return 0;
    }

    @Override
    public int getKeyType() {
        return 0;
    }

    @Override
    public int getBits() {
        String curName = ((ECNamedCurveSpec)this.ecSpec).getName();
        if (curName.equalsIgnoreCase("w-192")) {
            return 192;
        }
        return Integer.parseInt(curName.substring(curName.length() - 5, curName.length() - 2));
    }

    @Override
    public int getCurveType() {
        return ECUtils.getSwCurveType(((ECNamedCurveSpec)this.ecSpec).getName());
    }

    @Override
    public void setBagAttribute(ASN1ObjectIdentifier oid, ASN1Encodable attribute) {
        this.attrCarrier.setBagAttribute(oid, attribute);
    }

    @Override
    public ASN1Encodable getBagAttribute(ASN1ObjectIdentifier oid) {
        return this.attrCarrier.getBagAttribute(oid);
    }

    @Override
    public Enumeration getBagAttributeKeys() {
        return this.attrCarrier.getBagAttributeKeys();
    }

    @Override
    public void setPointFormat(String style) {
        this.withCompression = !"UNCOMPRESSED".equalsIgnoreCase(style);
    }

    public boolean equals(Object o) {
        if (!(o instanceof JCEECPrivateKey)) {
            return false;
        }
        JCEECPrivateKey other = (JCEECPrivateKey)o;
        return this.getD().equals(other.getD()) && this.engineGetSpec().equals(other.engineGetSpec());
    }

    public int hashCode() {
        return this.getD().hashCode() ^ this.engineGetSpec().hashCode();
    }

    public String toString() {
        return ECUtil.privateKeyToString("EC", this.d, this.engineGetSpec());
    }

    private DERBitString getPublicKeyDetails(JCEECPublicKey pub) {
        try {
            SubjectPublicKeyInfo info = SubjectPublicKeyInfo.getInstance(ASN1Primitive.fromByteArray(pub.getEncoded()));
            return info.getPublicKeyData();
        }
        catch (IOException e) {
            return null;
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        byte[] enc = (byte[])in.readObject();
        this.populateFromPrivKeyInfo(PrivateKeyInfo.getInstance(ASN1Primitive.fromByteArray(enc)));
        this.configuration = SwxaProvider.CONFIGURATION;
        this.attrCarrier = new PKCS12BagAttributeCarrierImpl();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.getEncoded());
    }
}

