/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.jcajce.provider.asymmetric.ec;

import com.sansec.asn1.ASN1ObjectIdentifier;
import com.sansec.asn1.x9.ECNamedCurveTable;
import com.sansec.asn1.x9.X9ECParameters;
import com.sansec.crypto.AsymmetricCipherKeyPair;
import com.sansec.crypto.generators.ECHsmKeyPairGenerator;
import com.sansec.crypto.generators.ECKeyPairGenerator;
import com.sansec.crypto.params.ECDomainParameters;
import com.sansec.crypto.params.ECKeyGenerationParameters;
import com.sansec.crypto.params.ECPrivateKeyParameters;
import com.sansec.crypto.params.ECPublicKeyParameters;
import com.sansec.jcajce.provider.asymmetric.ec.ECUtils;
import com.sansec.jcajce.provider.asymmetric.ec.JCEECPrivateKey;
import com.sansec.jcajce.provider.asymmetric.ec.JCEECPublicKey;
import com.sansec.jcajce.provider.asymmetric.ec.SwECGenParameterSpec;
import com.sansec.jcajce.provider.asymmetric.ec.SwJCEECPrivateKey;
import com.sansec.jcajce.provider.asymmetric.ec.SwJCEECPublicKey;
import com.sansec.jcajce.provider.asymmetric.util.EC5Util;
import com.sansec.jcajce.provider.config.ProviderConfiguration;
import com.sansec.jce.provider.SwxaProvider;
import com.sansec.jce.spec.ECNamedCurveGenParameterSpec;
import com.sansec.jce.spec.ECNamedCurveSpec;
import com.sansec.jce.spec.ECParameterSpec;
import com.sansec.math.ec.ECCurve;
import com.sansec.math.ec.ECPoint;
import com.sansec.util.Integers;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECGenParameterSpec;
import java.util.Hashtable;

public abstract class KeyPairGeneratorSpi
extends KeyPairGenerator {
    public KeyPairGeneratorSpi(String algorithmName) {
        super(algorithmName);
    }

    private String getCurveFromSwTypr(int swCurveType) {
        return null;
    }

    public static class ECMQV
    extends EC {
        public ECMQV() {
            super("ECMQV", SwxaProvider.CONFIGURATION);
        }
    }

    public static class ECDHC
    extends EC {
        public ECDHC() {
            super("ECDHC", SwxaProvider.CONFIGURATION);
        }
    }

    public static class ECDH
    extends EC {
        public ECDH() {
            super("ECDH", SwxaProvider.CONFIGURATION);
        }
    }

    public static class ECDSA
    extends EC {
        public ECDSA() {
            super("ECDSA", SwxaProvider.CONFIGURATION);
        }
    }

    public static class EC
    extends KeyPairGeneratorSpi {
        ECKeyGenerationParameters param;
        ECKeyPairGenerator engine = null;
        Object ecParams = null;
        int strength = 0;
        int certainty = 50;
        SecureRandom random = new SecureRandom();
        boolean initialised = false;
        String algorithm;
        ProviderConfiguration configuration;
        boolean isSwKey = false;
        String curveName = null;
        private static Hashtable<Integer, ECGenParameterSpec> ecParameters = new Hashtable();

        public EC() {
            super("EC");
            this.algorithm = "EC";
            this.configuration = SwxaProvider.CONFIGURATION;
        }

        public EC(String algorithm, ProviderConfiguration configuration) {
            super(algorithm);
            this.algorithm = algorithm;
            this.configuration = configuration;
        }

        @Override
        public void initialize(int strength, SecureRandom random) {
            this.strength = strength;
            this.random = random;
            AlgorithmParameterSpec ecParams = null;
            ecParams = strength >= 65536 ? new SwECGenParameterSpec("P-224") : ecParameters.get(Integers.valueOf(strength));
            if (ecParams == null) {
                throw new InvalidParameterException("unknown key size.");
            }
            try {
                this.initialize(ecParams, random);
            }
            catch (InvalidAlgorithmParameterException e) {
                throw new InvalidParameterException("key size not configurable.");
            }
        }

        @Override
        public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
            if (params == null) {
                ECParameterSpec implicitCA = this.configuration.getEcImplicitlyCa();
                if (implicitCA == null) {
                    throw new InvalidAlgorithmParameterException("null parameter passed but no implicitCA set");
                }
                this.ecParams = null;
                this.param = this.createKeyGenParamsBC(implicitCA, random);
            } else if (params instanceof SwECGenParameterSpec) {
                this.isSwKey = true;
                String curveName = ((SwECGenParameterSpec)params).getName();
                this.initializeNamedCurve(curveName, random);
                if (this.strength == 0) {
                    this.strength = ECUtils.getKeyBits(curveName);
                }
                this.curveName = curveName;
            } else if (params instanceof ECParameterSpec) {
                this.ecParams = params;
                this.param = this.createKeyGenParamsBC((ECParameterSpec)params, random);
            } else if (params instanceof java.security.spec.ECParameterSpec) {
                this.ecParams = params;
                this.param = this.createKeyGenParamsJCE(null, (java.security.spec.ECParameterSpec)params, random);
            } else if (params instanceof ECGenParameterSpec) {
                String cureName = ((ECGenParameterSpec)params).getName();
                if (ECUtils.isSwCurveType(cureName)) {
                    this.isSwKey = true;
                    this.initializeNamedCurve(cureName, random);
                    this.strength = ECUtils.getKeyBits(cureName);
                    this.curveName = this.curveName;
                } else {
                    this.initializeNamedCurve(((ECGenParameterSpec)params).getName(), random);
                }
            } else if (params instanceof ECNamedCurveGenParameterSpec) {
                this.initializeNamedCurve(((ECNamedCurveGenParameterSpec)params).getName(), random);
            } else {
                throw new InvalidAlgorithmParameterException("parameter object not a ECParameterSpec");
            }
            if (this.strength == 0) {
                this.strength = this.param.getDomainParameters().getN().bitLength();
            }
            if (this.strength != 0) {
                this.param.setStrength(this.strength);
            }
            this.engine = new ECKeyPairGenerator();
            if (SwxaProvider.isHsm(null, "KeyPairGenerator", this.algorithm) && this.isSwKey) {
                this.engine = new ECHsmKeyPairGenerator();
            }
            this.engine.init(this.param);
            this.initialised = true;
        }

        @Override
        public KeyPair generateKeyPair() {
            if (!this.initialised) {
                if (this.strength == 0) {
                    this.strength = 256;
                }
                this.initialize(this.strength, new SecureRandom());
            }
            AsymmetricCipherKeyPair pair = this.engine.generateKeyPair();
            ECPublicKeyParameters pub = (ECPublicKeyParameters)pair.getPublic();
            ECPrivateKeyParameters priv = (ECPrivateKeyParameters)pair.getPrivate();
            if (this.isSwKey) {
                String curveName = this.curveName;
                if (pub.getCurveType() != 0 && pub.getBits() != 0) {
                    curveName = ECUtils.getCurveTypeName(pub.getCurveType(), pub.getBits());
                }
                ECNamedCurveSpec namedCurve = null;
                try {
                    namedCurve = this.createNamedCurveSpec(curveName);
                }
                catch (InvalidAlgorithmParameterException e) {
                    throw new RuntimeException("CurveType:" + pub.getCurveType() + "," + e.getMessage());
                }
                this.ecParams = namedCurve;
                java.security.spec.ECParameterSpec p = (java.security.spec.ECParameterSpec)this.ecParams;
                SwJCEECPublicKey pubKey = new SwJCEECPublicKey(pub.getKeyIndex(), pub.getKeyType(), pub.getBits(), pub.getCurveType(), this.algorithm, pub, p, this.configuration);
                return new KeyPair(pubKey, new SwJCEECPrivateKey(pub.getKeyIndex(), pub.getKeyType(), pub.getBits(), pub.getCurveType(), this.algorithm, priv, pubKey, p, this.configuration));
            }
            if (this.ecParams instanceof ECParameterSpec) {
                ECParameterSpec p = (ECParameterSpec)this.ecParams;
                JCEECPublicKey pubKey = new JCEECPublicKey(this.algorithm, pub, p, this.configuration);
                return new KeyPair(pubKey, new JCEECPrivateKey(this.algorithm, priv, pubKey, p, this.configuration));
            }
            if (this.ecParams == null) {
                return new KeyPair(new JCEECPublicKey(this.algorithm, pub, this.configuration), new JCEECPrivateKey(this.algorithm, priv, this.configuration));
            }
            java.security.spec.ECParameterSpec p = (java.security.spec.ECParameterSpec)this.ecParams;
            JCEECPublicKey pubKey = new JCEECPublicKey(this.algorithm, pub, p, this.configuration);
            return new KeyPair(pubKey, new JCEECPrivateKey(this.algorithm, priv, pubKey, p, this.configuration));
        }

        protected ECKeyGenerationParameters createKeyGenParamsBC(ECParameterSpec p, SecureRandom r) {
            return new ECKeyGenerationParameters(new ECDomainParameters(p.getCurve(), p.getG(), p.getN()), r);
        }

        protected ECKeyGenerationParameters createKeyGenParamsJCE(String curveName, java.security.spec.ECParameterSpec p, SecureRandom r) {
            ECCurve curve = EC5Util.convertCurve(p.getCurve());
            ECPoint g = EC5Util.convertPoint(curve, p.getGenerator());
            BigInteger n = p.getOrder();
            BigInteger h = BigInteger.valueOf(p.getCofactor());
            ECDomainParameters dp = new ECDomainParameters(curve, g, n, h);
            return new ECKeyGenerationParameters(curveName, dp, r);
        }

        protected ECNamedCurveSpec createNamedCurveSpec(String curveName) throws InvalidAlgorithmParameterException {
            X9ECParameters p = ECUtils.getDomainParametersFromName(curveName);
            if (p == null) {
                try {
                    p = ECNamedCurveTable.getByOID(new ASN1ObjectIdentifier(curveName));
                    if (p == null) {
                        throw new InvalidAlgorithmParameterException("unknown curve OID: " + curveName);
                    }
                }
                catch (IllegalArgumentException ex) {
                    throw new InvalidAlgorithmParameterException("unknown curve name: " + curveName);
                }
            }
            byte[] seed = null;
            return new ECNamedCurveSpec(curveName, p.getCurve(), p.getG(), p.getN(), p.getH(), seed);
        }

        protected void initializeNamedCurve(String curveName, SecureRandom random) throws InvalidAlgorithmParameterException {
            ECNamedCurveSpec namedCurve = this.createNamedCurveSpec(curveName);
            this.ecParams = namedCurve;
            this.param = this.createKeyGenParamsJCE(curveName, namedCurve, random);
        }

        static {
            ecParameters.put(Integers.valueOf(192), new ECGenParameterSpec("prime192v1"));
            ecParameters.put(Integers.valueOf(239), new ECGenParameterSpec("prime239v1"));
            ecParameters.put(Integers.valueOf(256), new ECGenParameterSpec("prime256v1"));
            ecParameters.put(Integers.valueOf(224), new ECGenParameterSpec("P-224"));
            ecParameters.put(Integers.valueOf(384), new ECGenParameterSpec("P-384"));
            ecParameters.put(Integers.valueOf(521), new ECGenParameterSpec("P-521"));
        }
    }
}

