/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.jcajce.provider.asymmetric.ec;

import com.sansec.asn1.pkcs.PrivateKeyInfo;
import com.sansec.crypto.params.ECPrivateKeyParameters;
import com.sansec.jcajce.provider.asymmetric.ec.JCEECPrivateKey;
import com.sansec.jcajce.provider.asymmetric.ec.JCEECPublicKey;
import com.sansec.jcajce.provider.config.ProviderConfiguration;
import com.sansec.jce.interfaces.ECPrivateKey;
import com.sansec.util.KeyIndexUtil;
import com.sansec.util.Strings;
import java.io.IOException;
import java.math.BigInteger;
import java.security.spec.ECParameterSpec;

public class SwJCEECPrivateKey
extends JCEECPrivateKey
implements ECPrivateKey {
    private transient BigInteger d;
    private int keyIndex;
    private int keyType;
    private int bits;
    private int curveType;

    @Override
    public int getKeyIndex() {
        return this.keyIndex;
    }

    @Override
    public int getKeyType() {
        return this.keyType;
    }

    @Override
    public int getBits() {
        return this.bits;
    }

    @Override
    public int getCurveType() {
        return this.curveType;
    }

    public SwJCEECPrivateKey(int keyIndex, int keyType, int bits, int curveType, String algorithm, ECPrivateKeyParameters params, JCEECPublicKey pubKey, ECParameterSpec spec, ProviderConfiguration configuration) {
        super(algorithm, params, pubKey, spec, configuration);
        this.d = params.getD();
        this.keyIndex = keyIndex;
        this.keyType = keyType;
        this.bits = bits;
        this.curveType = curveType;
    }

    public SwJCEECPrivateKey(String algorithm, PrivateKeyInfo info, ProviderConfiguration configuration) throws IOException {
        super(algorithm, info, configuration);
        this.d = super.getD();
        this.bits = super.getBits();
        this.curveType = super.getCurveType();
        this.isSW();
    }

    private void isSW() {
        BigInteger d = super.getD();
        int dint = d.intValue();
        if (dint >= 0 && dint <= 100 && d.bitLength() < 32) {
            try {
                KeyIndexUtil.KeyIndexStruct struct = KeyIndexUtil.parse2KeyIndex(dint);
                this.keyIndex = struct.keyIndex;
                this.keyType = struct.keyType;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    public String toString() {
        if (this.keyIndex == 0) {
            StringBuffer buf = new StringBuffer();
            String nl = Strings.lineSeparator();
            buf.append("External EC Private Key").append(nl);
            buf.append("Bits:").append(this.bits).append(nl);
            buf.append("CurveTypex:").append(this.curveType).append(nl);
            buf.append("S:").append(this.d.toString(16)).append(nl);
            return buf.toString();
        }
        return "Internal EC PrivateKey[ KeyIndex = " + this.keyIndex + " ,KeyType = " + this.keyType + " ,Bits= " + this.bits + " ,CurveType= " + this.curveType + "]";
    }
}

