/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.jcajce.provider.asymmetric.rsa;

import com.sansec.asn1.ASN1ObjectIdentifier;
import com.sansec.asn1.pkcs.PKCSObjectIdentifiers;
import com.sansec.asn1.x509.X509ObjectIdentifiers;
import com.sansec.crypto.params.RSAKeyParameters;
import com.sansec.crypto.params.RSAPrivateCrtKeyParameters;
import com.sansec.jcajce.provider.asymmetric.rsa.SwJCERSAPrivateCrtKey;
import com.sansec.jcajce.provider.asymmetric.rsa.SwJCERSAPublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;

public class RSAUtil {
    public static final ASN1ObjectIdentifier[] rsaOids = new ASN1ObjectIdentifier[]{PKCSObjectIdentifiers.rsaEncryption, X509ObjectIdentifiers.id_ea_rsa, PKCSObjectIdentifiers.id_RSAES_OAEP, PKCSObjectIdentifiers.id_RSASSA_PSS};

    public static boolean isRsaOid(ASN1ObjectIdentifier algOid) {
        for (int i = 0; i != rsaOids.length; ++i) {
            if (!algOid.equals(rsaOids[i])) continue;
            return true;
        }
        return false;
    }

    static RSAKeyParameters generatePublicKeyParameter(RSAPublicKey key) {
        if (key instanceof SwJCERSAPublicKey) {
            SwJCERSAPublicKey swKey = (SwJCERSAPublicKey)key;
            if (swKey.getKeyIndex() > 0) {
                return new RSAKeyParameters(swKey.getKeyIndex(), swKey.getKeyType(), swKey.getBits(), false, key.getModulus(), key.getPublicExponent());
            }
            if (swKey.getKeyLabel() != null && swKey.getKeyLabel().length() > 0) {
                return new RSAKeyParameters(swKey.getKeyIndex(), swKey.getKeyLabel(), swKey.getKeyType(), swKey.getBits(), false, key.getModulus(), key.getPublicExponent());
            }
            return new RSAKeyParameters(swKey.getBits(), false, key.getModulus(), key.getPublicExponent());
        }
        return new RSAKeyParameters(false, key.getModulus(), key.getPublicExponent());
    }

    static RSAKeyParameters generatePrivateKeyParameter(RSAPrivateKey key) {
        if (key instanceof SwJCERSAPrivateCrtKey) {
            SwJCERSAPrivateCrtKey swKey = (SwJCERSAPrivateCrtKey)key;
            if (swKey.getKeyIndex() > 0) {
                return new RSAPrivateCrtKeyParameters(swKey.getKeyIndex(), swKey.getKeyType(), swKey.getBits(), key.getModulus(), swKey.getPublicExponent(), swKey.getPrivateExponent(), swKey.getPrimeP(), swKey.getPrimeQ(), swKey.getPrimeExponentP(), swKey.getPrimeExponentQ(), swKey.getCrtCoefficient());
            }
            if (swKey.getKeyLabel() != null && swKey.getKeyLabel().length() > 0) {
                return new RSAPrivateCrtKeyParameters(swKey.getKeyIndex(), swKey.getKeyLabel(), swKey.getKeyType(), swKey.getBits(), key.getModulus(), swKey.getPublicExponent(), swKey.getPrivateExponent(), swKey.getPrimeP(), swKey.getPrimeQ(), swKey.getPrimeExponentP(), swKey.getPrimeExponentQ(), swKey.getCrtCoefficient());
            }
            return new RSAPrivateCrtKeyParameters(swKey.getBits(), key.getModulus(), swKey.getPublicExponent(), swKey.getPrivateExponent(), swKey.getPrimeP(), swKey.getPrimeQ(), swKey.getPrimeExponentP(), swKey.getPrimeExponentQ(), swKey.getCrtCoefficient());
        }
        if (key instanceof RSAPrivateCrtKey) {
            RSAPrivateCrtKey k = (RSAPrivateCrtKey)key;
            return new RSAPrivateCrtKeyParameters(k.getModulus(), k.getPublicExponent(), k.getPrivateExponent(), k.getPrimeP(), k.getPrimeQ(), k.getPrimeExponentP(), k.getPrimeExponentQ(), k.getCrtCoefficient());
        }
        RSAPrivateKey k = key;
        return new RSAKeyParameters(true, k.getModulus(), k.getPrivateExponent());
    }
}

