/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.jcajce.provider.asymmetric.rsa;

import com.sansec.asn1.x509.SubjectPublicKeyInfo;
import com.sansec.crypto.params.RSAKeyParameters;
import com.sansec.crypto.params.SwKeyParams;
import com.sansec.jcajce.provider.asymmetric.rsa.JCERSAPublicKey;
import com.sansec.util.Strings;
import java.math.BigInteger;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.RSAPublicKeySpec;

public class SwJCERSAPublicKey
extends JCERSAPublicKey
implements SwKeyParams {
    static final long serialVersionUID = -8145849727580266753L;
    private int keyIndex;
    private int keyType;
    private int bits;
    private String keyLabel;

    @Override
    public int getKeyIndex() {
        return this.keyIndex;
    }

    @Override
    public int getKeyType() {
        return this.keyType;
    }

    @Override
    public int getBits() {
        return this.bits;
    }

    public String getKeyLabel() {
        return this.keyLabel;
    }

    public SwJCERSAPublicKey(RSAKeyParameters key) {
        super(key);
        this.keyIndex = key.getKeyIndex();
        this.keyLabel = key.getKeyLabel();
        this.keyType = key.getKeyType();
        this.bits = key.getBits();
        this.keyLabel = key.getKeyLabel();
    }

    public SwJCERSAPublicKey(RSAPublicKeySpec spec) {
        super(spec);
    }

    public SwJCERSAPublicKey(RSAPublicKey key) {
        super(key);
    }

    public SwJCERSAPublicKey(SubjectPublicKeyInfo info) {
        super(info);
    }

    @Override
    public BigInteger getModulus() {
        return super.getModulus();
    }

    @Override
    public BigInteger getPublicExponent() {
        return super.getPublicExponent();
    }

    @Override
    public String getAlgorithm() {
        return super.getAlgorithm();
    }

    @Override
    public String getFormat() {
        return super.getFormat();
    }

    @Override
    public byte[] getEncoded() {
        return super.getEncoded();
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (this.keyIndex == 0) {
            return super.equals(o);
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof SwJCERSAPublicKey)) {
            return false;
        }
        SwJCERSAPublicKey key = (SwJCERSAPublicKey)o;
        return this.getModulus().equals(key.getModulus()) && this.getPublicExponent().equals(key.getPublicExponent()) && this.getKeyIndex() == key.getKeyIndex() && this.getKeyLabel() == key.getKeyLabel() && this.getKeyType() == key.getKeyType();
    }

    @Override
    public String toString() {
        if (this.keyIndex == 0) {
            StringBuffer buf = new StringBuffer();
            String nl = Strings.lineSeparator();
            buf.append("External RSA Public Key").append(nl);
            buf.append("bits: ").append(this.bits).append(nl);
            buf.append("modulus: ").append(this.getModulus().toString(16)).append(nl);
            buf.append("public exponent: ").append(this.getPublicExponent().toString(16)).append(nl);
            return buf.toString();
        }
        if (this.keyIndex > 0) {
            return "Internal RSA PublicKey[ KeyIndex = " + this.keyIndex + ", KeyType = " + this.keyType + ", bits = " + this.bits + " ]";
        }
        return "Internal RSA PublicKey[ KeyLabel = " + this.keyLabel + ", KeyType = " + this.keyType + ", bits = " + this.bits + " ]";
    }
}

