/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.jcajce.provider.asymmetric.sm2;

import com.sansec.crypto.AsymmetricBlockCipher;
import com.sansec.crypto.CipherParameters;
import com.sansec.crypto.InvalidCipherTextException;
import com.sansec.crypto.RuntimeCryptoException;
import com.sansec.crypto.encodings.SM2EncryptionEncoding;
import com.sansec.crypto.params.ParametersWithRandom;
import com.sansec.jcajce.provider.asymmetric.sm2.JCESM2PrivateKey;
import com.sansec.jcajce.provider.asymmetric.sm2.JCESM2PublicKey;
import com.sansec.jcajce.provider.asymmetric.sm2.SM2Util;
import com.sansec.jcajce.provider.asymmetric.util.BaseCipherSpi;
import com.sansec.util.Strings;
import java.io.ByteArrayOutputStream;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.OAEPParameterSpec;

public class CipherSpi
extends BaseCipherSpi {
    private AsymmetricBlockCipher cipher;
    private AlgorithmParameterSpec paramSpec;
    private AlgorithmParameters engineParams;
    private ByteArrayOutputStream bOut = new ByteArrayOutputStream();

    public CipherSpi(AsymmetricBlockCipher engine) {
        this.cipher = engine;
    }

    @Override
    protected int engineDoFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws IllegalBlockSizeException, BadPaddingException {
        byte[] out;
        if (input != null) {
            this.bOut.write(input, inputOffset, inputLen);
        }
        if (this.bOut.size() > this.cipher.getInputBlockSize()) {
            throw new ArrayIndexOutOfBoundsException("too much data for SM2 block");
        }
        try {
            byte[] bytes = this.bOut.toByteArray();
            this.bOut.reset();
            out = this.cipher.processBlock(bytes, 0, bytes.length);
        }
        catch (InvalidCipherTextException e) {
            throw new BadPaddingException(e.getMessage());
        }
        for (int i = 0; i != out.length; ++i) {
            output[outputOffset + i] = out[i];
        }
        return out.length;
    }

    @Override
    protected byte[] engineDoFinal(byte[] input, int inputOffset, int inputLen) throws IllegalBlockSizeException, BadPaddingException {
        if (input != null) {
            this.bOut.write(input, inputOffset, inputLen);
        }
        if (this.bOut.size() > this.cipher.getInputBlockSize()) {
            throw new RuntimeCryptoException("too much data for SM2 block");
        }
        try {
            byte[] bytes = this.bOut.toByteArray();
            this.bOut.reset();
            return this.cipher.processBlock(bytes, 0, bytes.length);
        }
        catch (InvalidCipherTextException e) {
            throw new BadPaddingException(e.getMessage());
        }
    }

    @Override
    protected int engineGetBlockSize() {
        try {
            return this.cipher.getInputBlockSize();
        }
        catch (NullPointerException e) {
            throw new IllegalStateException("SM2 Cipher not initialised");
        }
    }

    @Override
    protected byte[] engineGetIV() {
        return null;
    }

    @Override
    protected int engineGetKeySize(Key key) {
        if (key == null) {
            throw new IllegalArgumentException("Key is null.");
        }
        if (key instanceof ECPublicKey) {
            ECPublicKey k = (ECPublicKey)key;
            return k.getW().getAffineX().bitLength();
        }
        if (key instanceof ECPrivateKey) {
            ECPrivateKey k = (ECPrivateKey)key;
            return k.getS().bitLength();
        }
        throw new IllegalArgumentException("not an SM2 key!");
    }

    @Override
    protected int engineGetOutputSize(int inputLen) {
        try {
            return this.cipher.getOutputBlockSize();
        }
        catch (NullPointerException e) {
            throw new IllegalStateException("SM2 Cipher not initialised");
        }
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        if (this.engineParams == null && this.paramSpec != null) {
            try {
                this.engineParams = AlgorithmParameters.getInstance("OAEP", "SwxaJCE");
                this.engineParams.init(this.paramSpec);
            }
            catch (Exception e) {
                throw new RuntimeException(e.toString());
            }
        }
        return this.engineParams;
    }

    @Override
    protected void engineInit(int opmode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        OAEPParameterSpec paramSpec = null;
        if (params != null) {
            try {
                paramSpec = params.getParameterSpec(OAEPParameterSpec.class);
            }
            catch (InvalidParameterSpecException e) {
                throw new InvalidAlgorithmParameterException("cannot recognise parameters: " + e.toString(), e);
            }
        }
        this.engineParams = params;
        this.engineInit(opmode, key, paramSpec, random);
    }

    @Override
    protected void engineInit(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        CipherParameters param;
        if (key == null) {
            throw new InvalidKeyException("Key is null.");
        }
        if (key instanceof JCESM2PublicKey) {
            param = SM2Util.generatePublicKeyParameter((JCESM2PublicKey)key);
        } else if (key instanceof JCESM2PrivateKey) {
            param = SM2Util.generatePrivateKeyParameter((JCESM2PrivateKey)key);
        } else if (key instanceof ECPublicKey) {
            param = SM2Util.generateECPublicKeyParameter((ECPublicKey)key);
        } else if (key instanceof ECPrivateKey) {
            param = SM2Util.generateECPrivateKeyParameter((ECPrivateKey)key);
        } else {
            throw new InvalidKeyException("unknown key type passed to SM2");
        }
        param = random != null ? new ParametersWithRandom(param, random) : new ParametersWithRandom(param, new SecureRandom());
        switch (opmode) {
            case 1: 
            case 3: {
                if (!(key instanceof JCESM2PublicKey) && !(key instanceof ECPublicKey)) {
                    throw new InvalidParameterException("invalid public key try encrypt mode for SM2");
                }
                this.cipher.init(true, param);
                break;
            }
            case 2: 
            case 4: {
                if (!(key instanceof JCESM2PrivateKey) && !(key instanceof ECPrivateKey)) {
                    throw new InvalidParameterException("invalid private key try decrypte mode for SM2");
                }
                this.cipher.init(false, param);
                break;
            }
            default: {
                throw new InvalidParameterException("unknown opmode " + opmode + " passed to SM2");
            }
        }
    }

    @Override
    protected void engineInit(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        if (key == null) {
            throw new InvalidKeyException("Key is null.");
        }
        try {
            this.engineInit(opmode, key, (AlgorithmParameterSpec)null, random);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new RuntimeException("Eeeek! " + e.toString(), e);
        }
    }

    @Override
    protected void engineSetMode(String mode) throws NoSuchAlgorithmException {
        String md = Strings.toUpperCase(mode);
        if (md.equals("NONE") || md.equals("ECB")) {
            return;
        }
        throw new NoSuchAlgorithmException("can't support mode " + mode);
    }

    @Override
    protected void engineSetPadding(String padding) throws NoSuchPaddingException {
    }

    @Override
    protected Key engineUnwrap(byte[] wrappedKey, String wrappedKeyAlgorithm, int wrappedKeyType) throws InvalidKeyException {
        return super.engineUnwrap(wrappedKey, wrappedKeyAlgorithm, wrappedKeyType);
    }

    @Override
    protected int engineUpdate(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException {
        this.bOut.write(input, inputOffset, inputLen);
        if (this.bOut.size() > this.cipher.getInputBlockSize()) {
            throw new ArrayIndexOutOfBoundsException("too much data for SM2 block");
        }
        return 0;
    }

    @Override
    protected byte[] engineUpdate(byte[] input, int inputOffset, int inputLen) {
        this.bOut.write(input, inputOffset, inputLen);
        if (this.bOut.size() > this.cipher.getInputBlockSize()) {
            throw new ArrayIndexOutOfBoundsException("too much data for SM2 block");
        }
        return null;
    }

    @Override
    protected byte[] engineWrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        return super.engineWrap(key);
    }

    public static class SM2
    extends CipherSpi {
        public SM2() {
            super(new SM2EncryptionEncoding());
        }
    }
}

