/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.jcajce.provider.asymmetric.sm2;

import com.sansec.crypto.AsymmetricCipherKeyPair;
import com.sansec.crypto.generators.SM2HsmKeyPairGenerator;
import com.sansec.crypto.generators.SM2KeyPairGenerator;
import com.sansec.crypto.params.SM2KeyGenerationParameters;
import com.sansec.crypto.params.SM2KeyParameters;
import com.sansec.crypto.params.SM2Point;
import com.sansec.crypto.params.SM2PrivateKeyParameters;
import com.sansec.jcajce.provider.asymmetric.sm2.JCESM2PrivateKey;
import com.sansec.jcajce.provider.asymmetric.sm2.JCESM2PublicKey;
import com.sansec.jce.exception.NotSupportException;
import com.sansec.jce.provider.SwxaProvider;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;

public class KeyPairGeneratorSpi
extends KeyPairGenerator {
    static final BigInteger defaultPublicExponent = BigInteger.valueOf(65537L);
    static final int defaultTests = 12;
    static final BigInteger defaultGx = new BigInteger("32C4AE2C1F1981195F9904466A39C9948FE30BBFF2660BE1715A4589334C74C7", 16);
    static final BigInteger defaultGy = new BigInteger("BC3736A2F4F6779C59BDCEE36B692153D0A9877CC62A474002DF32E52139F0A0", 16);
    static final SM2Point defaultG = new SM2Point(defaultGx, defaultGy);
    SM2KeyGenerationParameters param;
    SM2KeyPairGenerator engine;

    public KeyPairGeneratorSpi(String algorithmName) {
        super(algorithmName);
    }

    public KeyPairGeneratorSpi() {
        super("SM2");
        this.engine = new SM2KeyPairGenerator();
        if (SwxaProvider.isHsm(null, "KeyPairGenerator", "SM2")) {
            this.engine = new SM2HsmKeyPairGenerator();
        }
        this.param = new SM2KeyGenerationParameters(defaultG, new SecureRandom(), 256, 12);
        this.engine.init(this.param);
    }

    @Override
    public void initialize(int strength, SecureRandom random) {
        this.param = new SM2KeyGenerationParameters(defaultG, random, strength, 12);
        this.engine.init(this.param);
    }

    @Override
    public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        throw new NotSupportException("not support");
    }

    @Override
    public KeyPair generateKeyPair() {
        AsymmetricCipherKeyPair pair = this.engine.generateKeyPair();
        SM2KeyParameters pub = (SM2KeyParameters)pair.getPublic();
        SM2PrivateKeyParameters priv = (SM2PrivateKeyParameters)pair.getPrivate();
        JCESM2PublicKey publicKey = new JCESM2PublicKey(pub);
        JCESM2PrivateKey privateKey = new JCESM2PrivateKey(priv, pub);
        return new KeyPair(publicKey, privateKey);
    }
}

