/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.jcajce.provider.asymmetric.sm2;

import com.sansec.crypto.CipherParameters;
import com.sansec.crypto.params.SM2KeyParameters;
import com.sansec.crypto.params.SM2PrivateKeyParameters;
import com.sansec.jcajce.provider.asymmetric.sm2.JCESM2PrivateKey;
import com.sansec.jcajce.provider.asymmetric.sm2.JCESM2PublicKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;

public class SM2Util {
    public static CipherParameters generatePublicKeyParameter(JCESM2PublicKey key) {
        SM2KeyParameters paramKey = null;
        paramKey = key.getKeyIndex() > 0 ? new SM2KeyParameters(key.getKeyIndex(), key.getKeyType(), key.getBits(), false, key.getW().getAffineX(), key.getW().getAffineY()) : new SM2KeyParameters(key.getBits(), false, key.getW().getAffineX(), key.getW().getAffineY());
        return paramKey;
    }

    public static CipherParameters generatePrivateKeyParameter(JCESM2PrivateKey key) {
        SM2PrivateKeyParameters paramKey = null;
        paramKey = key.getKeyIndex() > 0 ? new SM2PrivateKeyParameters(key.getKeyIndex(), key.getKeyType(), key.getBits(), key.getW().getAffineX(), key.getW().getAffineY(), key.getS()) : new SM2PrivateKeyParameters(key.getBits(), key.getW().getAffineX(), key.getW().getAffineY(), key.getS());
        return paramKey;
    }

    public static CipherParameters generateECPublicKeyParameter(ECPublicKey key) {
        SM2KeyParameters paramKey = new SM2KeyParameters(0, 0, 1, false, key.getW().getAffineX(), key.getW().getAffineY());
        return paramKey;
    }

    public static CipherParameters generateECPrivateKeyParameter(ECPrivateKey key) {
        SM2PrivateKeyParameters paramKey = new SM2PrivateKeyParameters(0, 0, 1, null, null, key.getS());
        return paramKey;
    }
}

