/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.jcajce.provider.asymmetric.x509;

import com.sansec.asn1.ASN1Sequence;
import com.sansec.util.encoders.Base64;
import java.io.IOException;
import java.io.InputStream;

class PEMUtil {
    private final String _header1;
    private final String _header2;
    private final String _footer1;
    private final String _footer2;

    PEMUtil(String type) {
        this._header1 = "-----BEGIN " + type + "-----";
        this._header2 = "-----BEGIN X509 " + type + "-----";
        this._footer1 = "-----END " + type + "-----";
        this._footer2 = "-----END X509 " + type + "-----";
    }

    private String readLine(InputStream in) throws IOException {
        int c;
        StringBuffer l = new StringBuffer();
        while (true) {
            if ((c = in.read()) != 13 && c != 10 && c >= 0) {
                l.append((char)c);
                continue;
            }
            if (c < 0 || l.length() != 0) break;
        }
        if (c < 0) {
            if (l.length() != 0) {
                return l.toString();
            }
            return null;
        }
        if (c == 13) {
            in.mark(1);
            c = in.read();
            if (c == 10) {
                in.mark(1);
            }
            if (c > 0) {
                in.reset();
            }
        }
        return l.toString();
    }

    ASN1Sequence readPEMObject(InputStream in) throws IOException {
        String line;
        StringBuffer pemBuf = new StringBuffer();
        StringBuffer pemTmpBuf = new StringBuffer();
        while ((line = this.readLine(in)) != null) {
            pemTmpBuf.append(line);
            if (!line.startsWith(this._header1) && !line.startsWith(this._header2)) continue;
        }
        while ((line = this.readLine(in)) != null && !line.startsWith(this._footer1) && !line.startsWith(this._footer2)) {
            pemBuf.append(line);
        }
        if (pemBuf.length() != 0) {
            try {
                return ASN1Sequence.getInstance(Base64.decode(pemBuf.toString()));
            }
            catch (Exception e) {
                throw new IOException("malformed PEM data encountered");
            }
        }
        if (pemTmpBuf.length() != 0) {
            try {
                return ASN1Sequence.getInstance(Base64.decode(pemTmpBuf.toString()));
            }
            catch (Exception e) {
                throw new IOException("malformed PEM data encountered");
            }
        }
        return null;
    }
}

