/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.jcajce.provider.digest;

import com.sansec.asn1.nist.NISTObjectIdentifiers;
import com.sansec.asn1.pkcs.PKCSObjectIdentifiers;
import com.sansec.crypto.CipherKeyGenerator;
import com.sansec.crypto.digests.SHA384Digest;
import com.sansec.crypto.macs.HMac;
import com.sansec.crypto.macs.OldHMac;
import com.sansec.jcajce.provider.config.ConfigurableProvider;
import com.sansec.jcajce.provider.digest.DigestAlgorithmProvider;
import com.sansec.jcajce.provider.digest.JCEMessageDigest;
import com.sansec.jcajce.provider.symmetric.util.BaseKeyGenerator;
import com.sansec.jcajce.provider.symmetric.util.BaseMac;

public class SHA384 {
    private SHA384() {
    }

    public static class Mappings
    extends DigestAlgorithmProvider {
        private static final String PREFIX = SHA384.class.getName();

        @Override
        public void configure(ConfigurableProvider provider) {
            provider.addAlgorithm("MessageDigest.SHA-384", PREFIX + "$Digest");
            provider.addAlgorithm("Alg.Alias.MessageDigest.SHA384", "SHA-384");
            provider.addAlgorithm("Alg.Alias.MessageDigest." + NISTObjectIdentifiers.id_sha384, "SHA-384");
            provider.addAlgorithm("Mac.OLDHMACSHA384", PREFIX + "$OldSHA384");
            this.addHMACAlgorithm(provider, "SHA384", PREFIX + "$HashMac", PREFIX + "$KeyGenerator");
            this.addHMACAlias(provider, "SHA384", PKCSObjectIdentifiers.id_hmacWithSHA384);
        }
    }

    public static class OldSHA384
    extends BaseMac {
        public OldSHA384() {
            super(new OldHMac(new SHA384Digest()));
        }
    }

    public static class KeyGenerator
    extends BaseKeyGenerator {
        public KeyGenerator() {
            super("HMACSHA384", 384, new CipherKeyGenerator());
        }
    }

    public static class HashMac
    extends BaseMac {
        public HashMac() {
            super(new HMac(new SHA384Digest()));
        }
    }

    public static class Digest
    extends JCEMessageDigest
    implements Cloneable {
        public Digest() {
            super(new SHA384Digest());
        }

        @Override
        public Object clone() throws CloneNotSupportedException {
            Digest d = (Digest)super.clone();
            d.digest = new SHA384Digest((SHA384Digest)this.digest);
            return d;
        }
    }
}

