/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.jcajce.provider.digest;

import com.sansec.crypto.CipherKeyGenerator;
import com.sansec.crypto.digests.SM3Digest;
import com.sansec.crypto.macs.HMac;
import com.sansec.jcajce.provider.config.ConfigurableProvider;
import com.sansec.jcajce.provider.digest.DigestAlgorithmProvider;
import com.sansec.jcajce.provider.digest.JCEMessageDigest;
import com.sansec.jcajce.provider.symmetric.util.BaseKeyGenerator;
import com.sansec.jcajce.provider.symmetric.util.BaseMac;
import java.math.BigInteger;

public class SM3 {
    private SM3() {
    }

    public static class Mappings
    extends DigestAlgorithmProvider {
        private static final String PREFIX = SM3.class.getName();

        @Override
        public void configure(ConfigurableProvider provider) {
            provider.addAlgorithm("MessageDigest.SM3WithoutId", PREFIX + "$SM3WithoutId");
            provider.addAlgorithm("MessageDigest.SM3WithId", PREFIX + "$SM3WithId");
            provider.addAlgorithm("MessageDigest.SM3", PREFIX + "$Digest");
            provider.addAlgorithm("Alg.Alias.MessageDigest.1.2.156.10197.1.401", "SM3");
            this.addHMACAlgorithm(provider, "SM3", PREFIX + "$HashMac", PREFIX + "$KeyGenerator");
        }
    }

    public static class SM3Mac
    extends BaseMac {
        public SM3Mac() {
            super(new HMac(new SM3Digest()));
        }
    }

    public static class KeyGenerator
    extends BaseKeyGenerator {
        public KeyGenerator() {
            super("HMACSM3", 256, new CipherKeyGenerator());
        }
    }

    public static class HashMac
    extends BaseMac {
        public HashMac() {
            super(new HMac(new SM3Digest()));
        }
    }

    public static class SM3WithoutId
    extends JCEMessageDigest
    implements Cloneable {
        public SM3WithoutId() {
            super(new SM3Digest());
        }

        @Override
        public Object clone() throws CloneNotSupportedException {
            Digest d = (Digest)super.clone();
            d.digest = new SM3Digest((SM3Digest)this.digest);
            return d;
        }
    }

    public static class SM3WithId
    extends JCEMessageDigest
    implements Cloneable {
        private boolean isFirst = true;

        public SM3WithId() {
            super(new SM3Digest());
        }

        @Override
        public Object clone() throws CloneNotSupportedException {
            Digest d = (Digest)super.clone();
            d.digest = new SM3Digest((SM3Digest)this.digest);
            return d;
        }

        @Override
        public void engineReset() {
            super.engineReset();
            this.isFirst = true;
        }

        @Override
        public void engineUpdate(byte[] input, int offset, int len) {
            if (this.isFirst && input.length > 64) {
                this.isFirst = false;
                int idLength = input.length - 64;
                byte[] bX = new byte[32];
                byte[] bY = new byte[32];
                byte[] id = new byte[idLength];
                System.arraycopy(input, offset, bX, 0, 32);
                System.arraycopy(input, offset + 32, bY, 0, 32);
                System.arraycopy(input, offset + 64, id, 0, idLength);
                ((SM3Digest)this.digest).addId(new BigInteger(1, bX), new BigInteger(1, bY), id);
                return;
            }
            super.engineUpdate(input, offset, len);
        }
    }

    public static class Digest
    extends JCEMessageDigest
    implements Cloneable {
        public Digest() {
            super(new SM3Digest());
        }

        @Override
        public Object clone() throws CloneNotSupportedException {
            Digest d = (Digest)super.clone();
            d.digest = new SM3Digest((SM3Digest)this.digest);
            return d;
        }

        @Override
        public void engineReset() {
            super.engineReset();
        }

        @Override
        public void engineUpdate(byte[] input, int offset, int len) {
            super.engineUpdate(input, offset, len);
        }
    }
}

