/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.jcajce.provider.digest;

import com.sansec.crypto.CipherKeyGenerator;
import com.sansec.crypto.digests.WhirlpoolDigest;
import com.sansec.crypto.macs.HMac;
import com.sansec.jcajce.provider.config.ConfigurableProvider;
import com.sansec.jcajce.provider.digest.DigestAlgorithmProvider;
import com.sansec.jcajce.provider.digest.JCEMessageDigest;
import com.sansec.jcajce.provider.symmetric.util.BaseKeyGenerator;
import com.sansec.jcajce.provider.symmetric.util.BaseMac;

public class Whirlpool {
    private Whirlpool() {
    }

    public static class Mappings
    extends DigestAlgorithmProvider {
        private static final String PREFIX = Whirlpool.class.getName();

        @Override
        public void configure(ConfigurableProvider provider) {
            provider.addAlgorithm("MessageDigest.WHIRLPOOL", PREFIX + "$Digest");
            this.addHMACAlgorithm(provider, "WHIRLPOOL", PREFIX + "$HashMac", PREFIX + "$KeyGenerator");
        }
    }

    public static class KeyGenerator
    extends BaseKeyGenerator {
        public KeyGenerator() {
            super("HMACWHIRLPOOL", 512, new CipherKeyGenerator());
        }
    }

    public static class HashMac
    extends BaseMac {
        public HashMac() {
            super(new HMac(new WhirlpoolDigest()));
        }
    }

    public static class Digest
    extends JCEMessageDigest
    implements Cloneable {
        public Digest() {
            super(new WhirlpoolDigest());
        }

        @Override
        public Object clone() throws CloneNotSupportedException {
            Digest d = (Digest)super.clone();
            d.digest = new WhirlpoolDigest((WhirlpoolDigest)this.digest);
            return d;
        }
    }
}

