/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.jcajce.provider.keystore.swks;

import com.sansec.asn1.x509.X509Name;
import com.sansec.crypto.RuntimeCryptoException;
import com.sansec.devicev4.SwxaDeviceFactory;
import com.sansec.devicev4.api.CryptoException;
import com.sansec.devicev4.api.ISDSCrypto;
import com.sansec.devicev4.util.PrintUtil;
import com.sansec.x509.X509V3CertificateGenerator;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public class SWKSKeyStore1
extends KeyStoreSpi {
    static final int NULL = 0;
    static final int CERTIFICATE = 1;
    static final int KEY = 2;
    static final int SECRET = 3;
    static final int SEALED = 4;
    static final int KEY_PRIVATE = 0;
    static final int KEY_PUBLIC = 1;
    static final int KEY_SECRET = 2;
    protected SecureRandom random = new SecureRandom();
    private HashMap<String, KeyPair> cache = new HashMap();

    @Override
    public Enumeration<String> engineAliases() {
        Iterator<String> iterator = this.cache.keySet().iterator();
        Vector<String> aliasesVector = new Vector<String>();
        while (iterator.hasNext()) {
            aliasesVector.add(iterator.next());
        }
        return aliasesVector.elements();
    }

    @Override
    public boolean engineContainsAlias(String alias) {
        return this.cache.containsKey(alias);
    }

    @Override
    public void engineDeleteEntry(String alias) throws KeyStoreException {
        throw new KeyStoreException("HSM not support delete");
    }

    @Override
    public Certificate engineGetCertificate(String alias) {
        KeyPair keyPair = this.cache.get(alias);
        return this.genCert(keyPair);
    }

    @Override
    public String engineGetCertificateAlias(Certificate cert) {
        PublicKey publicKey = cert.getPublicKey();
        if (publicKey == null) {
            return null;
        }
        String alias = this.findAlias(publicKey);
        return alias;
    }

    @Override
    public Certificate[] engineGetCertificateChain(String alias) {
        return null;
    }

    @Override
    public Date engineGetCreationDate(String alias) {
        return null;
    }

    @Override
    public Key engineGetKey(String alias, char[] password) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        return this.cache.get(alias).getPrivate();
    }

    @Override
    public boolean engineIsCertificateEntry(String alias) {
        return false;
    }

    @Override
    public boolean engineIsKeyEntry(String alias) {
        return this.cache.containsKey(alias);
    }

    @Override
    public void engineLoad(InputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        KeyPair keyPair;
        KeyPairGenerator keyPairGenerator;
        int[] keyStatus = null;
        ISDSCrypto crypto = null;
        try {
            crypto = SwxaDeviceFactory.getInstance();
        }
        catch (Exception e) {
            throw new RuntimeCryptoException("get HSM instanse error", e);
        }
        try {
            keyStatus = crypto.getKeyStatus(4);
        }
        catch (CryptoException e1) {
            System.out.println("crypto.getKeyStatus(GlobalData.SGD_RSA) Error:" + e1.getMessage());
        }
        for (int keyNum = 0; keyNum < keyStatus.length; ++keyNum) {
            if (keyStatus[keyNum] <= 0) continue;
            try {
                keyPairGenerator = KeyPairGenerator.getInstance("RSA", "SwxaJCE");
                keyPairGenerator.initialize(keyNum + 1 << 16);
                keyPair = keyPairGenerator.generateKeyPair();
                if (keyPair == null || keyPair.getPublic().getEncoded() == null) continue;
                this.cache.put("RSAKey" + String.valueOf(keyNum + 1), keyPair);
                continue;
            }
            catch (NoSuchProviderException e) {
                System.out.println("NoSuchProviderException Error:" + e.getMessage());
            }
        }
        try {
            keyStatus = crypto.getKeyStatus(3);
        }
        catch (CryptoException e1) {
            System.out.println("crypto.getKeyStatus(GlobalData.SGD_SM2) Error:" + e1.getMessage());
        }
        for (int keyNum = 0; keyNum < keyStatus.length; ++keyNum) {
            if (keyStatus[keyNum] <= 0) continue;
            try {
                keyPairGenerator = KeyPairGenerator.getInstance("SM2", "SwxaJCE");
                keyPairGenerator.initialize(keyNum + 1 << 16);
                keyPair = keyPairGenerator.generateKeyPair();
                if (keyPair == null || keyPair.getPublic().getEncoded() == null) continue;
                this.cache.put("SM2Key" + String.valueOf(keyNum + 1), keyPair);
                continue;
            }
            catch (NoSuchProviderException e) {
                System.out.println("NoSuchProviderException Error:" + e.getMessage());
            }
        }
    }

    @Override
    public void engineSetCertificateEntry(String alias, Certificate cert) throws KeyStoreException {
        throw new KeyStoreException("HSM not support.");
    }

    @Override
    public void engineSetKeyEntry(String alias, byte[] key, Certificate[] chain) throws KeyStoreException {
        throw new KeyStoreException("HSM not support.");
    }

    @Override
    public void engineSetKeyEntry(String alias, Key key, char[] password, Certificate[] chain) throws KeyStoreException {
        throw new KeyStoreException("HSM not support import internal  Key.");
    }

    @Override
    public int engineSize() {
        return this.cache.size();
    }

    @Override
    public void engineStore(OutputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
    }

    private Certificate genCert(KeyPair keyPair1) {
        try {
            if (keyPair1.getPublic().getAlgorithm() == "RSA") {
                return this.genRsaCert(keyPair1, keyPair1.getPublic(), "CN=SWXA", "CN=SWXA");
            }
            return this.genSm2Cert(keyPair1, keyPair1.getPublic(), "CN=SWXA", "CN=SWXA");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private X509Certificate genRsaCert(KeyPair rootKeyPair, PublicKey userPublicKey, String issuerDN, String subjectDN) throws Exception {
        BigInteger serialNumber = BigInteger.valueOf(1L);
        X509V3CertificateGenerator certGen = new X509V3CertificateGenerator();
        certGen.setIssuerDN(new X509Name(issuerDN));
        certGen.setSubjectDN(new X509Name(subjectDN));
        Date startDate = new Date();
        Date endDate = new Date();
        endDate.setYear(startDate.getYear() + 1);
        certGen.setNotBefore(startDate);
        certGen.setNotAfter(endDate);
        certGen.setSerialNumber(serialNumber);
        certGen.setSignatureAlgorithm("SHA1WithRSA");
        certGen.setPublicKey(userPublicKey);
        X509Certificate cert = null;
        cert = certGen.generate(rootKeyPair.getPrivate());
        return cert;
    }

    private X509Certificate genSm2Cert(KeyPair rootKeyPair, PublicKey userPublicKey, String issuerDN, String subjectDN) throws Exception {
        BigInteger serialNumber = BigInteger.valueOf(1L);
        X509V3CertificateGenerator certGen = new X509V3CertificateGenerator();
        certGen.setIssuerDN(new X509Name(issuerDN));
        certGen.setSubjectDN(new X509Name(subjectDN));
        Date startDate = new Date();
        Date endDate = new Date();
        endDate.setYear(startDate.getYear() + 1);
        certGen.setNotBefore(startDate);
        certGen.setNotAfter(endDate);
        certGen.setSerialNumber(serialNumber);
        certGen.setSignatureAlgorithm("SM3WithSM2");
        certGen.setPublicKey(userPublicKey);
        X509Certificate cert = null;
        cert = certGen.generate(rootKeyPair.getPrivate());
        return cert;
    }

    private String findAlias(PublicKey publicKey) {
        Iterator<String> iterator = this.cache.keySet().iterator();
        PrintUtil.toHexString((byte[])publicKey.getEncoded());
        while (iterator.hasNext()) {
            String CurrentAlias = iterator.next();
            if (!Arrays.equals(this.cache.get(CurrentAlias).getPublic().getEncoded(), publicKey.getEncoded())) continue;
            return CurrentAlias;
        }
        return null;
    }

    public static class SwxaStore1
    extends SWKSKeyStore1 {
    }
}

