/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.jcajce.provider.keystore.swkshsm;

import com.sansec.crypto.Digest;
import com.sansec.crypto.RuntimeCryptoException;
import com.sansec.crypto.digests.SHA1Digest;
import com.sansec.crypto.io.DigestInputStream;
import com.sansec.crypto.io.DigestOutputStream_old;
import com.sansec.devicev4.SwxaDeviceFactory;
import com.sansec.devicev4.api.ISDSCrypto;
import com.sansec.devicev4.log.CryptoLogger;
import com.sansec.jcajce.provider.asymmetric.rsa.SwJCERSAPrivateCrtKey;
import com.sansec.jce.interfaces.BCKeyStore;
import com.sansec.util.Arrays;
import com.sansec.util.io.Streams;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.spec.EncodedKeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Logger;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class JDKKeyStoreOnHsm
extends KeyStoreSpi
implements BCKeyStore {
    private static final int STORE_VERSION = 1;
    private static final int STORE_SALT_SIZE = 20;
    private static final String STORE_CIPHER = "PBEWithSHAAndTwofish-CBC";
    private static final int KEY_SALT_SIZE = 20;
    private static final int MIN_ITERATIONS = 1024;
    private static final String KEY_CIPHER = "PBEWithSHAAnd3-KeyTripleDES-CBC";
    static Logger logger = CryptoLogger.logger;
    static final int NULL = 0;
    static final int CERTIFICATE = 1;
    static final int KEY = 2;
    static final int SECRET = 3;
    static final int SEALED = 4;
    static final int KEY_PRIVATE = 0;
    static final int KEY_PUBLIC = 1;
    static final int KEY_SECRET = 2;
    protected Hashtable table = new Hashtable();
    protected SecureRandom random = new SecureRandom();

    private void encodeCertificate(Certificate cert, DataOutputStream dOut) throws IOException {
        try {
            byte[] cEnc = cert.getEncoded();
            dOut.writeUTF(cert.getType());
            dOut.writeInt(cEnc.length);
            dOut.write(cEnc);
        }
        catch (CertificateEncodingException ex) {
            throw new IOException(ex.toString());
        }
    }

    private Certificate decodeCertificate(DataInputStream dIn) throws IOException {
        String type = dIn.readUTF();
        byte[] cEnc = new byte[dIn.readInt()];
        dIn.readFully(cEnc);
        try {
            CertificateFactory cFact = CertificateFactory.getInstance(type, "SwxaJCE");
            ByteArrayInputStream bIn = new ByteArrayInputStream(cEnc);
            return cFact.generateCertificate(bIn);
        }
        catch (NoSuchProviderException ex) {
            throw new IOException(ex.toString());
        }
        catch (CertificateException ex) {
            throw new IOException(ex.toString());
        }
    }

    private void encodeKey(Key key, DataOutputStream dOut) throws IOException {
        byte[] enc = key.getEncoded();
        if (key instanceof PrivateKey) {
            dOut.write(0);
        } else if (key instanceof PublicKey) {
            dOut.write(1);
        } else {
            dOut.write(2);
        }
        dOut.writeUTF(key.getFormat());
        dOut.writeUTF(key.getAlgorithm());
        dOut.writeInt(enc.length);
        dOut.write(enc);
    }

    private Key decodeKey(DataInputStream dIn) throws IOException {
        EncodedKeySpec spec;
        int keyType = dIn.read();
        String format = dIn.readUTF();
        String algorithm = dIn.readUTF();
        byte[] enc = new byte[dIn.readInt()];
        dIn.readFully(enc);
        if (format.equals("PKCS#8") || format.equals("PKCS8")) {
            spec = new PKCS8EncodedKeySpec(enc);
        } else if (format.equals("X.509") || format.equals("X509")) {
            spec = new X509EncodedKeySpec(enc);
        } else {
            if (format.equals("RAW")) {
                return new SecretKeySpec(enc, algorithm);
            }
            throw new IOException("Key format " + format + " not recognised!");
        }
        try {
            switch (keyType) {
                case 0: {
                    PrivateKey iPrivateKey = KeyFactory.getInstance(algorithm, "SwxaJCE").generatePrivate(spec);
                    if (iPrivateKey instanceof SwJCERSAPrivateCrtKey) {
                        SwJCERSAPrivateCrtKey iSwJCERSAPrivateCrtKey = (SwJCERSAPrivateCrtKey)iPrivateKey;
                        return iSwJCERSAPrivateCrtKey;
                    }
                    return iPrivateKey;
                }
                case 1: {
                    return KeyFactory.getInstance(algorithm, "SwxaJCE").generatePublic(spec);
                }
                case 2: {
                    return SecretKeyFactory.getInstance(algorithm, "SwxaJCE").generateSecret(spec);
                }
            }
            throw new IOException("Key type " + keyType + " not recognised!");
        }
        catch (Exception e) {
            throw new IOException("Exception creating key: " + e.toString());
        }
    }

    protected Cipher makePBECipher(String algorithm, int mode, char[] password, byte[] salt, int iterationCount) throws IOException {
        try {
            PBEKeySpec pbeSpec = new PBEKeySpec(password);
            SecretKeyFactory keyFact = SecretKeyFactory.getInstance(algorithm, "SwxaJCE");
            PBEParameterSpec defParams = new PBEParameterSpec(salt, iterationCount);
            Cipher cipher = Cipher.getInstance(algorithm, "SwxaJCE");
            cipher.init(mode, (Key)keyFact.generateSecret(pbeSpec), defParams);
            return cipher;
        }
        catch (Exception e) {
            throw new IOException("Error initialising store of key store: " + e);
        }
    }

    @Override
    public void setRandom(SecureRandom rand) {
        this.random = rand;
    }

    public Enumeration engineAliases() {
        return this.table.keys();
    }

    @Override
    public boolean engineContainsAlias(String alias) {
        return this.table.get(alias) != null;
    }

    @Override
    public void engineDeleteEntry(String alias) throws KeyStoreException {
        logger.info("Debug:engineDeleteEntry(String  alias) =" + alias);
        Object entry = this.table.get(alias);
        String keyStoreFileName = "sansec.KeyStore";
        if (entry == null) {
            throw new KeyStoreException("no such entry as " + alias);
        }
        if (this.table.get(alias) != null) {
            this.table.remove(alias);
            ISDSCrypto device = null;
            try {
                device = SwxaDeviceFactory.getInstance();
            }
            catch (Exception e) {
                throw new RuntimeCryptoException(e.getMessage());
            }
            try {
                int retCode = device.hsmDeleteFile(keyStoreFileName);
                logger.info("info:hsmDeleteFile...retCode=" + retCode);
            }
            catch (Exception ex) {
                logger.severe("info:hsmDeleteFile...Error! ex=" + ex.getMessage());
            }
        }
    }

    @Override
    public Certificate engineGetCertificate(String alias) {
        StoreEntry entry = (StoreEntry)this.table.get(alias);
        if (entry != null) {
            if (entry.getType() == 1) {
                return (Certificate)entry.getObject();
            }
            Certificate[] chain = entry.getCertificateChain();
            if (chain != null) {
                return chain[0];
            }
        }
        return null;
    }

    @Override
    public String engineGetCertificateAlias(Certificate cert) {
        Enumeration e = this.table.elements();
        while (e.hasMoreElements()) {
            Certificate[] chain;
            Certificate c;
            StoreEntry entry = (StoreEntry)e.nextElement();
            if (!(entry.getObject() instanceof Certificate ? (c = (Certificate)entry.getObject()).equals(cert) : (chain = entry.getCertificateChain()) != null && chain[0].equals(cert))) continue;
            return entry.getAlias();
        }
        return null;
    }

    @Override
    public Certificate[] engineGetCertificateChain(String alias) {
        StoreEntry entry = (StoreEntry)this.table.get(alias);
        if (entry != null) {
            return entry.getCertificateChain();
        }
        return null;
    }

    @Override
    public Date engineGetCreationDate(String alias) {
        StoreEntry entry = (StoreEntry)this.table.get(alias);
        if (entry != null) {
            return entry.getDate();
        }
        return null;
    }

    @Override
    public Key engineGetKey(String alias, char[] password) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        StoreEntry entry = (StoreEntry)this.table.get(alias);
        if (entry == null || entry.getType() == 1) {
            return null;
        }
        return (Key)entry.getObject(password);
    }

    @Override
    public boolean engineIsCertificateEntry(String alias) {
        StoreEntry entry = (StoreEntry)this.table.get(alias);
        return entry != null && entry.getType() == 1;
    }

    @Override
    public boolean engineIsKeyEntry(String alias) {
        StoreEntry entry = (StoreEntry)this.table.get(alias);
        return entry != null && entry.getType() != 1;
    }

    @Override
    public void engineSetCertificateEntry(String alias, Certificate cert) throws KeyStoreException {
        StoreEntry entry = (StoreEntry)this.table.get(alias);
        if (entry != null && entry.getType() != 1) {
            throw new KeyStoreException("key store already has a key entry with alias " + alias);
        }
        this.table.put(alias, new StoreEntry(alias, cert));
    }

    @Override
    public void engineSetKeyEntry(String alias, byte[] key, Certificate[] chain) throws KeyStoreException {
        this.table.put(alias, new StoreEntry(alias, key, chain));
    }

    @Override
    public void engineSetKeyEntry(String alias, Key key, char[] password, Certificate[] chain) throws KeyStoreException {
        if (key instanceof PrivateKey && chain == null) {
            throw new KeyStoreException("no certificate chain for private key");
        }
        try {
            this.table.put(alias, new StoreEntry(alias, key, password, chain));
        }
        catch (Exception e) {
            throw new KeyStoreException(e.toString());
        }
    }

    @Override
    public int engineSize() {
        return this.table.size();
    }

    protected void loadStore(InputStream in) throws IOException {
        DataInputStream dIn = new DataInputStream(in);
        int type = dIn.read();
        while (type > 0) {
            String alias = dIn.readUTF();
            Date date = new Date(dIn.readLong());
            int chainLength = dIn.readInt();
            Certificate[] chain = null;
            if (chainLength != 0) {
                chain = new Certificate[chainLength];
                for (int i = 0; i != chainLength; ++i) {
                    chain[i] = this.decodeCertificate(dIn);
                }
            }
            switch (type) {
                case 1: {
                    Certificate cert = this.decodeCertificate(dIn);
                    this.table.put(alias, new StoreEntry(alias, date, 1, cert));
                    break;
                }
                case 2: {
                    Key key = this.decodeKey(dIn);
                    this.table.put(alias, new StoreEntry(alias, date, 2, key, chain));
                    break;
                }
                case 3: 
                case 4: {
                    byte[] b = new byte[dIn.readInt()];
                    dIn.readFully(b);
                    this.table.put(alias, new StoreEntry(alias, date, type, b, chain));
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown object type in store.");
                }
            }
            type = dIn.read();
        }
    }

    protected void saveStore(OutputStream out) throws IOException {
        Enumeration e = this.table.elements();
        DataOutputStream dOut = new DataOutputStream(out);
        block5: while (e.hasMoreElements()) {
            StoreEntry entry = (StoreEntry)e.nextElement();
            dOut.write(entry.getType());
            dOut.writeUTF(entry.getAlias());
            dOut.writeLong(entry.getDate().getTime());
            Certificate[] chain = entry.getCertificateChain();
            if (chain == null) {
                dOut.writeInt(0);
            } else {
                dOut.writeInt(chain.length);
                for (int i = 0; i != chain.length; ++i) {
                    this.encodeCertificate(chain[i], dOut);
                }
            }
            switch (entry.getType()) {
                case 1: {
                    this.encodeCertificate((Certificate)entry.getObject(), dOut);
                    continue block5;
                }
                case 2: {
                    this.encodeKey((Key)entry.getObject(), dOut);
                    continue block5;
                }
                case 3: 
                case 4: {
                    byte[] b = (byte[])entry.getObject();
                    dOut.writeInt(b.length);
                    dOut.write(b);
                    continue block5;
                }
            }
            throw new RuntimeException("Unknown object type in store.");
        }
        dOut.write(0);
    }

    @Override
    public void engineLoad(InputStream stream, char[] password) throws IOException {
        logger.info("info:engineLoad(InputStream stream, char[] password)=====Swxa");
        String keyStoreFileName = "sansec.KeyStore";
        this.table.clear();
        if (stream == null) {
            logger.info("info:SwxaStore...stream == null");
            return;
        }
        DataInputStream dIn = null;
        ISDSCrypto device = null;
        try {
            device = SwxaDeviceFactory.getInstance();
        }
        catch (Exception e) {
            throw new RuntimeCryptoException(e.getMessage());
        }
        byte[] keyStoreBuf = null;
        try {
            keyStoreBuf = device.hsmReadFile(keyStoreFileName, 0, 4096);
            logger.info("info:hsmReadFile...keyStoreBuf.length=" + keyStoreBuf.length);
        }
        catch (Exception ex) {
            logger.severe("Error:hsmReadFile...Error=" + ex.getMessage());
            return;
        }
        if (keyStoreBuf.length <= 0) {
            logger.info("info:Read KeyStore from HSM File, ==========HSM file is empty ");
            return;
        }
        ByteArrayInputStream hsmOutBuf = new ByteArrayInputStream(keyStoreBuf);
        dIn = new DataInputStream(hsmOutBuf);
        logger.info("info:Read KeyStore from Hsm, ========== HSM file length=" + keyStoreBuf.length);
        int version = dIn.readInt();
        if (version != 1 && version != 0) {
            throw new IOException("Wrong version of key store.");
        }
        byte[] salt = new byte[dIn.readInt()];
        if (salt.length != 20) {
            throw new IOException("Key store corrupted.");
        }
        dIn.readFully(salt);
        int iterationCount = dIn.readInt();
        if (iterationCount < 0 || iterationCount > 4096) {
            throw new IOException("Key store corrupted.");
        }
        String cipherAlg = version == 0 ? "OldPBEWithSHAAndTwofish-CBC" : STORE_CIPHER;
        Cipher cipher = this.makePBECipher(cipherAlg, 2, password, salt, iterationCount);
        CipherInputStream cIn = new CipherInputStream(dIn, cipher);
        SHA1Digest dig = new SHA1Digest();
        DigestInputStream dgIn = new DigestInputStream(cIn, dig);
        this.loadStore(dgIn);
        byte[] hash = new byte[dig.getDigestSize()];
        dig.doFinal(hash, 0);
        byte[] oldHash = new byte[dig.getDigestSize()];
        Streams.readFully(cIn, oldHash);
        if (!Arrays.constantTimeAreEqual(hash, oldHash)) {
            this.table.clear();
            throw new IOException("KeyStore integrity check failed.");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void engineStore(OutputStream stream, char[] password) throws IOException {
        logger.info("info:engineStore(OutputStream stream, char[] password)=====Swxa");
        ByteArrayOutputStream hsmOutBuf = new ByteArrayOutputStream();
        DataOutputStream dOut = new DataOutputStream(hsmOutBuf);
        String keyStoreFileName = "sansec.KeyStore";
        byte[] salt = new byte[20];
        int iterationCount = 1024 + (this.random.nextInt() & 0x3FF);
        this.random.nextBytes(salt);
        dOut.writeInt(1);
        dOut.writeInt(salt.length);
        dOut.write(salt);
        dOut.writeInt(iterationCount);
        Cipher cipher = this.makePBECipher(STORE_CIPHER, 1, password, salt, iterationCount);
        CipherOutputStream cOut = new CipherOutputStream(dOut, cipher);
        DigestOutputStream_old dgOut = new DigestOutputStream_old(cOut, new SHA1Digest());
        this.saveStore(dgOut);
        Digest dig = dgOut.getDigest();
        byte[] hash = new byte[dig.getDigestSize()];
        dig.doFinal(hash, 0);
        cOut.write(hash);
        cOut.close();
        DataOutputStream dOutBak = new DataOutputStream(stream);
        dOutBak.write(new byte[]{83, 87, 75, 83, 72, 83, 77});
        ISDSCrypto device = null;
        try {
            device = SwxaDeviceFactory.getInstance();
        }
        catch (Exception e) {
            throw new RuntimeCryptoException(e.getMessage());
        }
        if (this.engineSize() >= 1) {
            try {
                int retCode = device.hsmCreateFile(keyStoreFileName, 4096);
                logger.info("info:hsmCreateFile...retCode=" + retCode);
                if (retCode != 0) return;
                int retCode1 = device.hsmWriteFile(keyStoreFileName, 0, hsmOutBuf.toByteArray());
                logger.info("info:hsmWriteFile...retCode1=" + retCode1);
                return;
            }
            catch (Exception ex) {
                logger.severe("Error:hsmCreateFile or hsmWriteFile...Error=" + ex.getMessage());
                throw new RuntimeCryptoException(ex.getMessage());
            }
        } else {
            logger.severe("engineSize=0,  not save file to HSM....");
        }
    }

    private static void writeToFile(String fileName, byte[] data) {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(fileName);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        try {
            out.write(data);
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static byte[] getByteArrayFromFile(String filename) {
        byte[] result = null;
        try {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(filename));
            byte[] temp = new byte[in.available()];
            ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
            int size = 0;
            while ((size = in.read(temp)) != -1) {
                out.write(temp, 0, size);
            }
            in.close();
            result = out.toByteArray();
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static class SwxaStoreOnHsm
    extends JDKKeyStoreOnHsm {
    }

    private class StoreEntry {
        int type;
        String alias;
        Object obj;
        Certificate[] certChain;
        Date date = new Date();

        StoreEntry(String alias, Certificate obj) {
            this.type = 1;
            this.alias = alias;
            this.obj = obj;
            this.certChain = null;
        }

        StoreEntry(String alias, byte[] obj, Certificate[] certChain) {
            this.type = 3;
            this.alias = alias;
            this.obj = obj;
            this.certChain = certChain;
        }

        StoreEntry(String alias, Key key, char[] password, Certificate[] certChain) throws Exception {
            this.type = 4;
            this.alias = alias;
            this.certChain = certChain;
            byte[] salt = new byte[20];
            JDKKeyStoreOnHsm.this.random.setSeed(System.currentTimeMillis());
            JDKKeyStoreOnHsm.this.random.nextBytes(salt);
            int iterationCount = 1024 + (JDKKeyStoreOnHsm.this.random.nextInt() & 0x3FF);
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            DataOutputStream dOut = new DataOutputStream(bOut);
            dOut.writeInt(salt.length);
            dOut.write(salt);
            dOut.writeInt(iterationCount);
            Cipher cipher = JDKKeyStoreOnHsm.this.makePBECipher(JDKKeyStoreOnHsm.KEY_CIPHER, 1, password, salt, iterationCount);
            CipherOutputStream cOut = new CipherOutputStream(dOut, cipher);
            dOut = new DataOutputStream(cOut);
            JDKKeyStoreOnHsm.this.encodeKey(key, dOut);
            dOut.close();
            this.obj = bOut.toByteArray();
        }

        StoreEntry(String alias, Date date, int type, Object obj) {
            this.alias = alias;
            this.date = date;
            this.type = type;
            this.obj = obj;
        }

        StoreEntry(String alias, Date date, int type, Object obj, Certificate[] certChain) {
            this.alias = alias;
            this.date = date;
            this.type = type;
            this.obj = obj;
            this.certChain = certChain;
        }

        int getType() {
            return this.type;
        }

        String getAlias() {
            return this.alias;
        }

        Object getObject() {
            return this.obj;
        }

        Object getObject(char[] password) throws NoSuchAlgorithmException, UnrecoverableKeyException {
            if ((password == null || password.length == 0) && this.obj instanceof Key) {
                return this.obj;
            }
            if (this.type == 4) {
                ByteArrayInputStream bIn = new ByteArrayInputStream((byte[])this.obj);
                DataInputStream dIn = new DataInputStream(bIn);
                try {
                    byte[] salt = new byte[dIn.readInt()];
                    dIn.readFully(salt);
                    int iterationCount = dIn.readInt();
                    Cipher cipher = JDKKeyStoreOnHsm.this.makePBECipher(JDKKeyStoreOnHsm.KEY_CIPHER, 2, password, salt, iterationCount);
                    CipherInputStream cIn = new CipherInputStream(dIn, cipher);
                    try {
                        return JDKKeyStoreOnHsm.this.decodeKey(new DataInputStream(cIn));
                    }
                    catch (Exception x) {
                        bIn = new ByteArrayInputStream((byte[])this.obj);
                        dIn = new DataInputStream(bIn);
                        salt = new byte[dIn.readInt()];
                        dIn.readFully(salt);
                        iterationCount = dIn.readInt();
                        cipher = JDKKeyStoreOnHsm.this.makePBECipher("BrokenPBEWithSHAAnd3-KeyTripleDES-CBC", 2, password, salt, iterationCount);
                        cIn = new CipherInputStream(dIn, cipher);
                        Key k = null;
                        try {
                            k = JDKKeyStoreOnHsm.this.decodeKey(new DataInputStream(cIn));
                        }
                        catch (Exception y) {
                            bIn = new ByteArrayInputStream((byte[])this.obj);
                            dIn = new DataInputStream(bIn);
                            salt = new byte[dIn.readInt()];
                            dIn.readFully(salt);
                            iterationCount = dIn.readInt();
                            cipher = JDKKeyStoreOnHsm.this.makePBECipher("OldPBEWithSHAAnd3-KeyTripleDES-CBC", 2, password, salt, iterationCount);
                            cIn = new CipherInputStream(dIn, cipher);
                            k = JDKKeyStoreOnHsm.this.decodeKey(new DataInputStream(cIn));
                        }
                        if (k != null) {
                            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
                            DataOutputStream dOut = new DataOutputStream(bOut);
                            dOut.writeInt(salt.length);
                            dOut.write(salt);
                            dOut.writeInt(iterationCount);
                            Cipher out = JDKKeyStoreOnHsm.this.makePBECipher(JDKKeyStoreOnHsm.KEY_CIPHER, 1, password, salt, iterationCount);
                            CipherOutputStream cOut = new CipherOutputStream(dOut, out);
                            dOut = new DataOutputStream(cOut);
                            JDKKeyStoreOnHsm.this.encodeKey(k, dOut);
                            dOut.close();
                            this.obj = bOut.toByteArray();
                            return k;
                        }
                        throw new UnrecoverableKeyException("no match");
                    }
                }
                catch (Exception e) {
                    throw new UnrecoverableKeyException("no match");
                }
            }
            throw new RuntimeException("forget something!");
        }

        Certificate[] getCertificateChain() {
            return this.certChain;
        }

        Date getDate() {
            return this.date;
        }
    }
}

