/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.jcajce.provider.symmetric;

import com.sansec.asn1.ASN1Primitive;
import com.sansec.asn1.cms.GCMParameters;
import com.sansec.util.Integers;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;

class GcmSpecUtil {
    static final Class gcmSpecClass = GcmSpecUtil.lookup("javax.crypto.spec.GCMParameterSpec");

    GcmSpecUtil() {
    }

    static boolean gcmSpecExists() {
        return gcmSpecClass != null;
    }

    static boolean isGcmSpec(AlgorithmParameterSpec paramSpec) {
        return gcmSpecClass != null && gcmSpecClass.isInstance(paramSpec);
    }

    static boolean isGcmSpec(Class paramSpecClass) {
        return gcmSpecClass == paramSpecClass;
    }

    static AlgorithmParameterSpec extractGcmSpec(ASN1Primitive spec) throws InvalidParameterSpecException {
        try {
            GCMParameters gcmParams = GCMParameters.getInstance(spec);
            Constructor constructor = gcmSpecClass.getConstructor(Integer.TYPE, byte[].class);
            return (AlgorithmParameterSpec)constructor.newInstance(Integers.valueOf(gcmParams.getIcvLen() * 8), gcmParams.getNonce());
        }
        catch (NoSuchMethodException e) {
            throw new InvalidParameterSpecException("No constructor found!");
        }
        catch (Exception e) {
            throw new InvalidParameterSpecException("Construction failed: " + e.getMessage());
        }
    }

    static GCMParameters extractGcmParameters(AlgorithmParameterSpec paramSpec) throws InvalidParameterSpecException {
        try {
            Method tLen = gcmSpecClass.getDeclaredMethod("getTLen", new Class[0]);
            Method iv = gcmSpecClass.getDeclaredMethod("getIV", new Class[0]);
            return new GCMParameters((byte[])iv.invoke((Object)paramSpec, new Object[0]), (Integer)tLen.invoke((Object)paramSpec, new Object[0]) / 8);
        }
        catch (Exception e) {
            throw new InvalidParameterSpecException("Cannot process GCMParameterSpec");
        }
    }

    private static Class lookup(String className) {
        try {
            return GcmSpecUtil.class.getClassLoader().loadClass(className);
        }
        catch (Exception e) {
            return null;
        }
    }
}

