/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.jcajce.provider.symmetric;

import com.sansec.asn1.nist.NISTObjectIdentifiers;
import com.sansec.asn1.pkcs.GBObjectIdentifiers;
import com.sansec.asn1.pkcs.PKCSObjectIdentifiers;
import com.sansec.jcajce.provider.config.ConfigurableProvider;
import com.sansec.jcajce.provider.symmetric.HsmSecretKeySpec;
import com.sansec.jcajce.provider.symmetric.SymmetricAlgorithmProvider;
import java.security.InvalidAlgorithmParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Random;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;

public class HsmKeyGenerator
extends KeyGeneratorSpi {
    protected String algName;
    protected int keysize;
    protected int defaultKeySize;
    protected Random rnd;
    protected boolean uninitialised = true;

    protected HsmKeyGenerator(String algName, int defaultKeySize) {
        this.algName = algName;
        this.keysize = this.defaultKeySize = defaultKeySize;
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        if (random != null) {
            this.rnd = random;
            this.uninitialised = false;
        }
    }

    @Override
    protected void engineInit(SecureRandom random) {
        if (random != null) {
            this.rnd = random;
            this.uninitialised = false;
        }
    }

    @Override
    protected void engineInit(int keySize, SecureRandom random) {
        this.keysize = keySize;
        if (random != null) {
            this.rnd = random;
            this.uninitialised = false;
        }
    }

    @Override
    protected SecretKey engineGenerateKey() {
        if (this.uninitialised) {
            try {
                this.rnd = SecureRandom.getInstance("RND", "SwxaJCE");
            }
            catch (Exception e) {
                this.rnd = new SecureRandom();
            }
            this.uninitialised = false;
        }
        byte[] key = new byte[this.defaultKeySize / 8];
        int keyIndex = this.keysize >> 16;
        if (keyIndex == 0) {
            key = new byte[this.keysize / 8];
            this.rnd.nextBytes(key);
        } else {
            this.rnd.nextBytes(key);
        }
        return new HsmSecretKeySpec(keyIndex, key, this.algName);
    }

    public static class Mappings
    extends SymmetricAlgorithmProvider {
        private static final String PREFIX = HsmKeyGenerator.class.getName();

        @Override
        public void configure(ConfigurableProvider provider) {
            provider.addAlgorithmHsm("KeyGenerator.SM1", PREFIX + "$SM1");
            provider.addAlgorithmHsm("KeyGenerator." + GBObjectIdentifiers.sm1, PREFIX + "$SM1");
            provider.addAlgorithmHsm("KeyGenerator.SM4", PREFIX + "$SM4");
            provider.addAlgorithmHsm("KeyGenerator." + GBObjectIdentifiers.sm4, PREFIX + "$SM4");
            provider.addAlgorithmHsm("KeyGenerator.SM7", PREFIX + "$SM7");
            provider.addAlgorithmHsm("KeyGenerator." + GBObjectIdentifiers.sm7, PREFIX + "$SM7");
            provider.addAlgorithmHsm("KeyGenerator.SSF33", PREFIX + "$SSF33");
            provider.addAlgorithmHsm("KeyGenerator." + GBObjectIdentifiers.ssf33, PREFIX + "$SSF33");
            provider.addAlgorithmHsm("KeyGenerator.AES", PREFIX + "$AES");
            provider.addAlgorithmHsm("Alg.Alias.KeyGenerator." + NISTObjectIdentifiers.id_aes128_CBC, "AES.HSM");
            provider.addAlgorithmHsm("Alg.Alias.KeyGenerator." + NISTObjectIdentifiers.id_aes128_ECB, "AES.HSM");
            provider.addAlgorithmHsm("KeyGenerator.DESEDE", PREFIX + "$DESede");
            provider.addAlgorithmHsm("Alg.Alias.KeyGenerator.3DES", "DESEDE.HSM");
            provider.addAlgorithmHsm("Alg.Alias.KeyGenerator.DESede", "DESEDE.HSM");
            provider.addAlgorithmHsm("Alg.Alias.KeyGenerator.DES3", "DESEDE.HSM");
            provider.addAlgorithmHsm("KeyGenerator.DESEDE3", PREFIX + "$DESede3");
            provider.addAlgorithmHsm("KeyGenerator." + PKCSObjectIdentifiers.des_EDE3_CBC, PREFIX + "$DESede3");
        }
    }

    public static class DESede3
    extends HsmKeyGenerator {
        public DESede3() {
            super("DESede3", 192);
        }
    }

    public static class DESede
    extends HsmKeyGenerator {
        public DESede() {
            super("DESede", 128);
        }
    }

    public static class AES
    extends HsmKeyGenerator {
        public AES() {
            super("AES", 128);
        }
    }

    public static class SSF33
    extends HsmKeyGenerator {
        public SSF33() {
            super("SSF33", 128);
        }
    }

    public static class SM7
    extends HsmKeyGenerator {
        public SM7() {
            super("SM7", 128);
        }
    }

    public static class SM4
    extends HsmKeyGenerator {
        public SM4() {
            super("SM4", 128);
        }
    }

    public static class SM1
    extends HsmKeyGenerator {
        public SM1() {
            super("SM1", 128);
        }
    }
}

