/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.jcajce.provider.symmetric;

import com.sansec.util.encoders.Hex;
import javax.crypto.spec.SecretKeySpec;

public class HsmSecretKeySpec
extends SecretKeySpec {
    private static final long serialVersionUID = 1L;
    private int keyIndex;
    private String keyLabel;

    public HsmSecretKeySpec(int keyIndex, byte[] key, String algorithm) {
        super(key, algorithm);
        this.keyIndex = keyIndex;
    }

    public HsmSecretKeySpec(String keyLabel, byte[] key, String algorithm) {
        super(key, algorithm);
        this.keyLabel = keyLabel;
    }

    public int getKeyIndex() {
        return this.keyIndex;
    }

    public String getKeyLabel() {
        return this.keyLabel;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && this.keyIndex == ((HsmSecretKeySpec)obj).keyIndex;
    }

    public String toString() {
        if (this.keyIndex != 0) {
            return "Internal Key[ " + this.keyIndex + " ]";
        }
        if (this.keyLabel != null) {
            return "Internal Key[ " + this.keyLabel + " ]";
        }
        return Hex.toHexString(this.getEncoded());
    }
}

