/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.jcajce.provider.symmetric;

import com.sansec.asn1.ASN1ObjectIdentifier;
import com.sansec.asn1.ASN1Primitive;
import com.sansec.asn1.cryptopro.CryptoProObjectIdentifiers;
import com.sansec.asn1.pkcs.PBKDF2Params;
import com.sansec.asn1.pkcs.PKCSObjectIdentifiers;
import com.sansec.crypto.CipherParameters;
import com.sansec.crypto.RuntimeCryptoException;
import com.sansec.crypto.params.KeyParameter;
import com.sansec.devicev4.SwxaDeviceFactory;
import com.sansec.devicev4.api.CryptoException;
import com.sansec.devicev4.api.ISDSCrypto;
import com.sansec.jcajce.provider.config.ConfigurableProvider;
import com.sansec.jcajce.provider.symmetric.util.BaseAlgorithmParameters;
import com.sansec.jcajce.provider.symmetric.util.BaseSecretKeyFactory;
import com.sansec.jcajce.provider.symmetric.util.JCEPBEKey;
import com.sansec.jcajce.provider.symmetric.util.PBE;
import com.sansec.jcajce.provider.util.AlgorithmProvider;
import com.sansec.jcajce.spec.PBKDF2KeySpec;
import com.sansec.jcajce.spec.SwPBKDF2KeySpec;
import java.io.IOException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.KeySpec;
import javax.crypto.SecretKey;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;

public class PBEPBKDF2 {
    private PBEPBKDF2() {
    }

    public static class Mappings
    extends AlgorithmProvider {
        private static final String PREFIX = PBEPBKDF2.class.getName();

        @Override
        public void configure(ConfigurableProvider provider) {
            provider.addAlgorithm("AlgorithmParameters.PBKDF2", PREFIX + "$AlgParams");
            provider.addAlgorithm("Alg.Alias.AlgorithmParameters." + PKCSObjectIdentifiers.id_PBKDF2, "PBKDF2");
            provider.addAlgorithm("SecretKeyFactory.PBKDF2", PREFIX + "$PBKDF2withUTF8");
            provider.addAlgorithm("Alg.Alias.SecretKeyFactory.PBKDF2WITHHMACSHA1", "PBKDF2");
            provider.addAlgorithm("Alg.Alias.SecretKeyFactory.PBKDF2WITHHMACSHA1ANDUTF8", "PBKDF2");
            provider.addAlgorithm("Alg.Alias.SecretKeyFactory." + PKCSObjectIdentifiers.id_PBKDF2, "PBKDF2");
            provider.addAlgorithm("SecretKeyFactory.PBKDF2WITHASCII", PREFIX + "$PBKDF2with8BIT");
            provider.addAlgorithm("Alg.Alias.SecretKeyFactory.PBKDF2WITH8BIT", "PBKDF2WITHASCII");
            provider.addAlgorithm("Alg.Alias.SecretKeyFactory.PBKDF2WITHHMACSHA1AND8BIT", "PBKDF2WITHASCII");
            provider.addAlgorithm("SecretKeyFactory.PBKDF2WITHHMACSHA224", PREFIX + "$PBKDF2withSHA224");
            provider.addAlgorithm("SecretKeyFactory.PBKDF2WITHHMACSHA256", PREFIX + "$PBKDF2withSHA256");
            provider.addAlgorithm("SecretKeyFactory.PBKDF2WITHHMACSHA384", PREFIX + "$PBKDF2withSHA384");
            provider.addAlgorithm("SecretKeyFactory.PBKDF2WITHHMACSHA512", PREFIX + "$PBKDF2withSHA512");
        }
    }

    public static class PBKDF2with8BIT
    extends BasePBKDF2 {
        public PBKDF2with8BIT() {
            super("PBKDF2", 1);
        }
    }

    public static class PBKDF2withSHA512
    extends BasePBKDF2 {
        public PBKDF2withSHA512() {
            super("PBKDF2", 5, 9);
        }
    }

    public static class PBKDF2withSHA384
    extends BasePBKDF2 {
        public PBKDF2withSHA384() {
            super("PBKDF2", 5, 8);
        }
    }

    public static class PBKDF2withSHA256
    extends BasePBKDF2 {
        public PBKDF2withSHA256() {
            super("PBKDF2", 5, 4);
        }
    }

    public static class PBKDF2withSHA224
    extends BasePBKDF2 {
        public PBKDF2withSHA224() {
            super("PBKDF2", 5, 7);
        }
    }

    public static class PBKDF2withUTF8
    extends BasePBKDF2 {
        public PBKDF2withUTF8() {
            super("PBKDF2", 5);
        }
    }

    public static class BasePBKDF2
    extends BaseSecretKeyFactory {
        private int scheme;
        private int defaultDigest;

        public BasePBKDF2(String name, int scheme) {
            this(name, scheme, 1);
        }

        public BasePBKDF2(String name, int scheme, int defaultDigest) {
            super(name, PKCSObjectIdentifiers.id_PBKDF2);
            this.scheme = scheme;
            this.defaultDigest = defaultDigest;
        }

        @Override
        protected SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
            if (keySpec instanceof PBEKeySpec) {
                PBEKeySpec pbeSpec = (PBEKeySpec)keySpec;
                if (pbeSpec.getSalt() == null) {
                    throw new InvalidKeySpecException("missing required salt");
                }
                if (pbeSpec.getIterationCount() <= 0) {
                    throw new InvalidKeySpecException("positive iteration count required: " + pbeSpec.getIterationCount());
                }
                if (pbeSpec.getKeyLength() <= 0) {
                    throw new InvalidKeySpecException("positive key length required: " + pbeSpec.getKeyLength());
                }
                if (pbeSpec.getPassword().length == 0) {
                    throw new IllegalArgumentException("password empty");
                }
                if (pbeSpec instanceof SwPBKDF2KeySpec) {
                    int digest = this.defaultDigest;
                    int keySize = pbeSpec.getKeyLength();
                    int ivSize = -1;
                    int swHashAlg = 1;
                    switch (digest) {
                        case 1: {
                            swHashAlg = 2;
                            break;
                        }
                        case 7: {
                            swHashAlg = 32;
                            break;
                        }
                        case 4: {
                            swHashAlg = 4;
                            break;
                        }
                        case 8: {
                            swHashAlg = 16;
                            break;
                        }
                        case 9: {
                            swHashAlg = 8;
                            break;
                        }
                        default: {
                            throw new RuntimeCryptoException("Unsuport Hash alg." + digest);
                        }
                    }
                    byte[] dKey = null;
                    try {
                        dKey = this.generateSwPBKDFKey(swHashAlg, (SwPBKDF2KeySpec)pbeSpec);
                    }
                    catch (CryptoException e) {
                        throw new RuntimeCryptoException("Generate PBKDF2 Key error", e);
                    }
                    KeyParameter param = new KeyParameter(dKey, 0, keySize / 8);
                    return new JCEPBEKey(this.algName, this.algOid, this.scheme, digest, keySize, ivSize, pbeSpec, param);
                }
                if (pbeSpec instanceof PBKDF2KeySpec) {
                    PBKDF2KeySpec spec = (PBKDF2KeySpec)pbeSpec;
                    int digest = this.getDigestCode(spec.getPrf().getAlgorithm());
                    int keySize = pbeSpec.getKeyLength();
                    int ivSize = -1;
                    CipherParameters param = PBE.Util.makePBEMacParameters(pbeSpec, this.scheme, digest, keySize);
                    return new JCEPBEKey(this.algName, this.algOid, this.scheme, digest, keySize, ivSize, pbeSpec, param);
                }
                int digest = this.defaultDigest;
                int keySize = pbeSpec.getKeyLength();
                int ivSize = -1;
                CipherParameters param = PBE.Util.makePBEMacParameters(pbeSpec, this.scheme, digest, keySize);
                return new JCEPBEKey(this.algName, this.algOid, this.scheme, digest, keySize, ivSize, pbeSpec, param);
            }
            throw new InvalidKeySpecException("Invalid KeySpec");
        }

        private byte[] generateSwPBKDFKey(int swHashAlg, SwPBKDF2KeySpec swPBKDF2KeySpec) throws CryptoException {
            ISDSCrypto crypto = null;
            try {
                crypto = SwxaDeviceFactory.getInstance();
            }
            catch (Exception e) {
                throw new RuntimeCryptoException("Error getting device instance of HSM", e);
            }
            int keyIndex = swPBKDF2KeySpec.getKeyIndex();
            String keyLabel = swPBKDF2KeySpec.getKeyLabel();
            byte[] out = null;
            out = keyIndex > 0 ? crypto.genPBKDF2KeyExt(swHashAlg, swPBKDF2KeySpec.getIterationCount(), swPBKDF2KeySpec.getKeyLength() / 8, swPBKDF2KeySpec.getPassword(), swPBKDF2KeySpec.getSalt(), swPBKDF2KeySpec.getKeyIndex()) : (keyLabel != null ? crypto.genPBKDF2KeyExt(swHashAlg, swPBKDF2KeySpec.getIterationCount(), swPBKDF2KeySpec.getKeyLength() / 8, swPBKDF2KeySpec.getPassword(), swPBKDF2KeySpec.getSalt(), keyLabel) : crypto.genPBKDF2Key(swHashAlg, swPBKDF2KeySpec.getIterationCount(), swPBKDF2KeySpec.getKeyLength() / 8, swPBKDF2KeySpec.getPassword(), swPBKDF2KeySpec.getSalt()));
            return out;
        }

        private int getDigestCode(ASN1ObjectIdentifier algorithm) throws InvalidKeySpecException {
            if (algorithm.equals(CryptoProObjectIdentifiers.gostR3411Hmac)) {
                return 6;
            }
            if (algorithm.equals(PKCSObjectIdentifiers.id_hmacWithSHA1)) {
                return 1;
            }
            if (algorithm.equals(PKCSObjectIdentifiers.id_hmacWithSHA256)) {
                return 4;
            }
            if (algorithm.equals(PKCSObjectIdentifiers.id_hmacWithSHA224)) {
                return 7;
            }
            if (algorithm.equals(PKCSObjectIdentifiers.id_hmacWithSHA384)) {
                return 8;
            }
            if (algorithm.equals(PKCSObjectIdentifiers.id_hmacWithSHA512)) {
                return 9;
            }
            throw new InvalidKeySpecException("Invalid KeySpec: unknown PRF algorithm " + algorithm);
        }
    }

    public static class AlgParams
    extends BaseAlgorithmParameters {
        PBKDF2Params params;

        @Override
        protected byte[] engineGetEncoded() {
            try {
                return this.params.getEncoded("DER");
            }
            catch (IOException e) {
                throw new RuntimeException("Oooops! " + e.toString());
            }
        }

        @Override
        protected byte[] engineGetEncoded(String format) {
            if (this.isASN1FormatString(format)) {
                return this.engineGetEncoded();
            }
            return null;
        }

        @Override
        protected AlgorithmParameterSpec localEngineGetParameterSpec(Class paramSpec) throws InvalidParameterSpecException {
            if (paramSpec == PBEParameterSpec.class) {
                return new PBEParameterSpec(this.params.getSalt(), this.params.getIterationCount().intValue());
            }
            throw new InvalidParameterSpecException("unknown parameter spec passed to PBKDF2 PBE parameters object.");
        }

        @Override
        protected void engineInit(AlgorithmParameterSpec paramSpec) throws InvalidParameterSpecException {
            if (!(paramSpec instanceof PBEParameterSpec)) {
                throw new InvalidParameterSpecException("PBEParameterSpec required to initialise a PBKDF2 PBE parameters algorithm parameters object");
            }
            PBEParameterSpec pbeSpec = (PBEParameterSpec)paramSpec;
            this.params = new PBKDF2Params(pbeSpec.getSalt(), pbeSpec.getIterationCount());
        }

        @Override
        protected void engineInit(byte[] params) throws IOException {
            this.params = PBKDF2Params.getInstance(ASN1Primitive.fromByteArray(params));
        }

        @Override
        protected void engineInit(byte[] params, String format) throws IOException {
            if (this.isASN1FormatString(format)) {
                this.engineInit(params);
                return;
            }
            throw new IOException("Unknown parameters format in PBKDF2 parameters object");
        }

        @Override
        protected String engineToString() {
            return "PBKDF2 Parameters";
        }
    }
}

