/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.jce.provider;

import com.sansec.asn1.ASN1Encodable;
import com.sansec.asn1.ASN1ObjectIdentifier;
import com.sansec.asn1.nist.NISTObjectIdentifiers;
import com.sansec.asn1.pkcs.GBObjectIdentifiers;
import com.sansec.asn1.pkcs.PKCSObjectIdentifiers;
import com.sansec.asn1.pkcs.PrivateKeyInfo;
import com.sansec.asn1.x509.AlgorithmIdentifier;
import com.sansec.asn1.x509.SubjectPublicKeyInfo;
import com.sansec.crypto.RuntimeCryptoException;
import com.sansec.devicev4.SwxaDeviceFactory;
import com.sansec.devicev4.api.HSMStateListener;
import com.sansec.devicev4.crypto_hsm.sds.cmd.hsm.socket.HSMPool;
import com.sansec.devicev4.crypto_hsm.sds.cmd.hsm.socket.HSMSession;
import com.sansec.devicev4.crypto_hsm.sds.cmd.hsm.socket.HSMSocket;
import com.sansec.jcajce.provider.config.ConfigurableProvider;
import com.sansec.jcajce.provider.config.ProviderConfiguration;
import com.sansec.jcajce.provider.util.AlgorithmProvider;
import com.sansec.jcajce.provider.util.AsymmetricKeyInfoConverter;
import com.sansec.jce.provider.BouncyCastleProviderConfiguration;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivateKey;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.PublicKey;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class SwxaProvider
extends Provider
implements ConfigurableProvider {
    private static final long serialVersionUID = 1L;
    private static String info = "Sansec Security Provider";
    public static final String PROVIDER_NAME = "SwxaJCE";
    public static final ProviderConfiguration CONFIGURATION = new BouncyCastleProviderConfiguration();
    private static final Map keyInfoConverters = new HashMap();
    private static final String SYMMETRIC_PACKAGE = "com.sansec.jcajce.provider.symmetric.";
    private static final String[] SYMMETRIC_GENERIC = new String[]{"PBEPBKDF2", "PBEPKCS12", "TLSKDF"};
    private static final String[] SYMMETRIC_MACS = new String[]{"SipHash"};
    private static final String[] SYMMETRIC_CIPHERS = new String[]{"AES", "ARC4", "Blowfish", "Camellia", "CAST5", "CAST6", "ChaCha", "DES", "DESede", "GOST28147", "Grainv1", "Grain128", "HC128", "HC256", "IDEA", "Noekeon", "RC2", "RC5", "RC6", "Rijndael", "Salsa20", "SEED", "Serpent", "Shacal2", "Skipjack", "SM4", "TEA", "Twofish", "Threefish", "VMPC", "VMPCKSA3", "XTEA", "XSalsa20", "OpenSSLPBKDF", "HsmBlockCipher", "HsmKeyGenerator"};
    private static final String ASYMMETRIC_PACKAGE = "com.sansec.jcajce.provider.asymmetric.";
    private static final String[] ASYMMETRIC_GENERIC = new String[]{"X509", "IES"};
    private static final String[] ASYMMETRIC_CIPHERS = new String[]{"DSA", "DH", "EC", "RSA", "GOST", "ECGOST", "ElGamal", "DSTU4145", "SM2", "EdEC"};
    private static final String DIGEST_PACKAGE = "com.sansec.jcajce.provider.digest.";
    private static final String[] DIGESTS = new String[]{"GOST3411", "Keccak", "MD2", "MD4", "MD5", "SHA1", "RIPEMD128", "RIPEMD160", "RIPEMD256", "RIPEMD320", "SHA224", "SHA256", "SHA384", "SHA512", "SHA3", "Skein", "SM3", "Tiger", "Whirlpool", "Blake2b"};
    private static final String KEYSTORE_PACKAGE = "com.sansec.jcajce.provider.keystore.";
    private static final String[] KEYSTORES = new String[]{"BC", "PKCS12", "SWKS", "JKS", "SWKSHSM", "SWKSLabel", "JKSOld"};
    private static final String RANDOM_PACKAGE = "com.sansec.jcajce.provider.random.";
    private static final String[] RANDOMS = new String[]{"SecureRandom"};
    private static boolean isNull = false;
    private static Map<String, String> asymDeviceMap = new HashMap<String, String>();
    private static Map<String, String> symmDeviceMap = new HashMap<String, String>();

    public SwxaProvider() {
        super(PROVIDER_NAME, 4.2, info);
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                SwxaProvider.this.setup();
                return null;
            }
        });
        if (isNull) {
            return;
        }
        try {
            SwxaDeviceFactory.getInstance((String)"com.sansec.devicev4.crypto_hsm.SDSCryptoFactory");
        }
        catch (Exception e) {
            throw new RuntimeCryptoException("Initlize HSM Pools error,Please check the swsds.ini.", e);
        }
    }

    public SwxaProvider(String deviceFactoryName) {
        super(PROVIDER_NAME, 4.2, info);
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                SwxaProvider.this.setup();
                return null;
            }
        });
        if (isNull) {
            return;
        }
        if (deviceFactoryName.contains(",%")) {
            String[] psws = deviceFactoryName.split(",%");
            int argCount = psws.length;
            if (argCount != 3 && argCount != 1) {
                throw new RuntimeCryptoException("Initlize error,psws.length!=3||1.");
            }
            if (argCount == 3) {
                try {
                    SwxaDeviceFactory.getInstance((String)"com.sansec.devicev4.crypto_hsm.SDSCryptoFactory", (String)psws[0], (String)psws[1], (String)psws[2]);
                }
                catch (Exception e) {
                    throw new RuntimeCryptoException("Initlize HSM Pools error,Please check the swsds.ini.", e);
                }
            } else {
                try {
                    SwxaDeviceFactory.getInstance((String)"com.sansec.devicev4.crypto_hsm.SDSCryptoFactory", (String)psws[0], (String)"", (String)"");
                }
                catch (Exception e) {
                    throw new RuntimeCryptoException("Initlize HSM Pools error,Please check the swsds.ini.", e);
                }
            }
        } else {
            try {
                SwxaDeviceFactory.getInstance((String)deviceFactoryName);
            }
            catch (Exception e) {
                throw new RuntimeCryptoException("Initlize HSM Pools error,Please check the swsds.ini.", e);
            }
        }
    }

    public SwxaProvider(InputStream iniFileInputStream) {
        super(PROVIDER_NAME, 4.2, info);
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                SwxaProvider.this.setup();
                return null;
            }
        });
        if (iniFileInputStream == null) {
            throw new RuntimeCryptoException("iniFileInputStream cannot be null.");
        }
        try {
            SwxaDeviceFactory.getInstance((InputStream)iniFileInputStream);
        }
        catch (Exception e) {
            throw new RuntimeCryptoException("Initlize HSM Pools error,Please check iniFileInputStream.", e);
        }
    }

    public SwxaProvider(String deviceFactoryName, String userConfigFile) {
        super(PROVIDER_NAME, 4.2, info);
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                SwxaProvider.this.setup();
                return null;
            }
        });
        if (userConfigFile == null) {
            isNull = true;
            return;
        }
        try {
            SwxaDeviceFactory.getInstance((String)deviceFactoryName, (String)userConfigFile);
        }
        catch (Exception e) {
            throw new RuntimeCryptoException("Initlize HSM Pools error,Please check the swsds.ini.", e);
        }
    }

    public SwxaProvider(String loginPass, String keyStorePass, String trustStorePass) {
        super(PROVIDER_NAME, 4.2, info);
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                SwxaProvider.this.setup();
                return null;
            }
        });
        if (isNull) {
            return;
        }
        try {
            SwxaDeviceFactory.getInstance((String)"com.sansec.devicev4.crypto_hsm.SDSCryptoFactory", (String)loginPass, (String)keyStorePass, (String)trustStorePass);
        }
        catch (Exception e) {
            throw new RuntimeCryptoException("Initlize HSM Pools error,Please check the swsds.ini.", e);
        }
    }

    public SwxaProvider(String userConfigFile, String loginPass, String keyStorePass, String trustStorePass) {
        super(PROVIDER_NAME, 4.2, info);
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                SwxaProvider.this.setup();
                return null;
            }
        });
        if (isNull) {
            return;
        }
        try {
            SwxaDeviceFactory.getInstance((String)"com.sansec.devicev4.crypto_hsm.SDSCryptoFactory", (String)userConfigFile, (String)loginPass, (String)keyStorePass, (String)trustStorePass);
        }
        catch (Exception e) {
            throw new RuntimeCryptoException("Initlize HSM Pools error,Please check the swsds.ini.", e);
        }
    }

    public SwxaProvider(String deviceFactoryName, String userConfigFile, String loginPass, String keyStorePass, String trustStorePass) {
        super(PROVIDER_NAME, 4.2, info);
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                SwxaProvider.this.setup();
                return null;
            }
        });
        if (userConfigFile == null) {
            isNull = true;
            return;
        }
        try {
            SwxaDeviceFactory.getInstance((String)deviceFactoryName, (String)userConfigFile, (String)loginPass, (String)keyStorePass, (String)trustStorePass);
        }
        catch (Exception e) {
            throw new RuntimeCryptoException("Initlize HSM Pools error,Please check the swsds.ini.", e);
        }
    }

    private void setup() {
        this.loadAlgorithms(DIGEST_PACKAGE, DIGESTS);
        this.loadAlgorithms(SYMMETRIC_PACKAGE, SYMMETRIC_GENERIC);
        this.loadAlgorithms(SYMMETRIC_PACKAGE, SYMMETRIC_MACS);
        this.loadAlgorithms(SYMMETRIC_PACKAGE, SYMMETRIC_CIPHERS);
        this.loadAlgorithms(ASYMMETRIC_PACKAGE, ASYMMETRIC_GENERIC);
        this.loadAlgorithms(ASYMMETRIC_PACKAGE, ASYMMETRIC_CIPHERS);
        this.loadAlgorithms(KEYSTORE_PACKAGE, KEYSTORES);
        this.loadAlgorithms(RANDOM_PACKAGE, RANDOMS);
        this.put("X509Store.CERTIFICATE/COLLECTION", "com.sansec.jce.provider.X509StoreCertCollection");
        this.put("X509Store.ATTRIBUTECERTIFICATE/COLLECTION", "com.sansec.jce.provider.X509StoreAttrCertCollection");
        this.put("X509Store.CRL/COLLECTION", "com.sansec.jce.provider.X509StoreCRLCollection");
        this.put("X509Store.CERTIFICATEPAIR/COLLECTION", "com.sansec.jce.provider.X509StoreCertPairCollection");
        this.put("X509Store.CERTIFICATE/LDAP", "com.sansec.jce.provider.X509StoreLDAPCerts");
        this.put("X509Store.CRL/LDAP", "com.sansec.jce.provider.X509StoreLDAPCRLs");
        this.put("X509Store.ATTRIBUTECERTIFICATE/LDAP", "com.sansec.jce.provider.X509StoreLDAPAttrCerts");
        this.put("X509Store.CERTIFICATEPAIR/LDAP", "com.sansec.jce.provider.X509StoreLDAPCertPairs");
        this.put("X509StreamParser.CERTIFICATE", "com.sansec.jce.provider.X509CertParser");
        this.put("X509StreamParser.ATTRIBUTECERTIFICATE", "com.sansec.jce.provider.X509AttrCertParser");
        this.put("X509StreamParser.CRL", "com.sansec.jce.provider.X509CRLParser");
        this.put("X509StreamParser.CERTIFICATEPAIR", "com.sansec.jce.provider.X509CertPairParser");
        this.put("Cipher.BROKENPBEWITHMD5ANDDES", "com.sansec.jce.provider.BrokenJCEBlockCipher$BrokePBEWithMD5AndDES");
        this.put("Cipher.BROKENPBEWITHSHA1ANDDES", "com.sansec.jce.provider.BrokenJCEBlockCipher$BrokePBEWithSHA1AndDES");
        this.put("Cipher.OLDPBEWITHSHAANDTWOFISH-CBC", "com.sansec.jce.provider.BrokenJCEBlockCipher$OldPBEWithSHAAndTwofish");
        this.put("CertPathValidator.RFC3280", "com.sansec.jce.provider.PKIXCertPathValidatorSpi");
        this.put("CertPathBuilder.RFC3280", "com.sansec.jce.provider.PKIXCertPathBuilderSpi");
        this.put("CertPathValidator.PKIX", "com.sansec.jce.provider.PKIXCertPathValidatorSpi");
        this.put("CertPathBuilder.PKIX", "com.sansec.jce.provider.PKIXCertPathBuilderSpi");
        this.put("CertStore.Collection", "com.sansec.jce.provider.CertStoreCollectionSpi");
        this.put("CertStore.LDAP", "com.sansec.jce.provider.X509LDAPCertStoreSpi");
        this.put("CertStore.Multi", "com.sansec.jce.provider.MultiCertStoreSpi");
        this.put("Alg.Alias.CertStore.X509LDAP", "LDAP");
        this.loadSSL();
    }

    private void loadSSL() {
        this.put("KeyGenerator.SwTlsPrf", "com.sansec.jsses.provider.TlsPrfGenerator");
        this.put("KeyGenerator.SwTlsRsaPremasterSecret", "com.sansec.jsses.provider.TlsRsaPremasterSecretGenerator");
        this.put("KeyGenerator.SwTlsSm2PremasterSecret", "com.sansec.jsses.provider.TlsSm2PremasterSecretGenerator");
        this.put("KeyGenerator.SwTlsMasterSecret", "com.sansec.jsses.provider.TlsMasterSecretGenerator");
        this.put("KeyGenerator.SwTlsKeyMaterial", "com.sansec.jsses.provider.TlsKeyMaterialGenerator");
    }

    private void loadAlgorithms(String packageName, String[] names) {
        for (int i = 0; i != names.length; ++i) {
            Class<?> clazz = null;
            try {
                ClassLoader loader = this.getClass().getClassLoader();
                clazz = loader != null ? loader.loadClass(packageName + names[i] + "$Mappings") : Class.forName(packageName + names[i] + "$Mappings");
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
            if (clazz == null) continue;
            try {
                ((AlgorithmProvider)clazz.newInstance()).configure(this);
                continue;
            }
            catch (Exception e) {
                throw new InternalError("cannot create instance of " + packageName + names[i] + "$Mappings : " + e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setParameter(String parameterName, Object parameter) {
        ProviderConfiguration providerConfiguration = CONFIGURATION;
        synchronized (providerConfiguration) {
            ((BouncyCastleProviderConfiguration)CONFIGURATION).setParameter(parameterName, parameter);
        }
    }

    @Override
    public boolean hasAlgorithm(String type, String name) {
        return this.containsKey(type + "." + name) || this.containsKey("Alg.Alias." + type + "." + name);
    }

    @Override
    public void addAlgorithm(String key, String value) {
        if (this.containsKey(key)) {
            throw new IllegalStateException("duplicate provider key (" + key + ") found");
        }
        this.put(key, value);
    }

    @Override
    public void addAlgorithm(String type, ASN1ObjectIdentifier oid, String className) {
        this.addAlgorithm(type + "." + oid, className);
        this.addAlgorithm(type + ".OID." + oid, className);
    }

    @Override
    public void addAlgorithmHsm(String key, String value) {
        if (this.containsKey(key = key + ".HSM")) {
            throw new IllegalStateException("duplicate provider key (" + key + ") found");
        }
        this.put(key, value);
    }

    @Override
    public void addAlgorithmHsm(String type, ASN1ObjectIdentifier oid, String className) {
        this.addAlgorithmHsm(type + "." + oid, className);
        this.addAlgorithmHsm(type + ".OID." + oid, className);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addKeyInfoConverter(ASN1ObjectIdentifier oid, AsymmetricKeyInfoConverter keyInfoConverter) {
        Map map = keyInfoConverters;
        synchronized (map) {
            keyInfoConverters.put(oid, keyInfoConverter);
        }
    }

    @Override
    public AsymmetricKeyInfoConverter getKeyInfoConverter(ASN1ObjectIdentifier oid) {
        return null;
    }

    @Override
    public void addAttributes(String key, Map<String, String> attributeMap) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static AsymmetricKeyInfoConverter getAsymmetricKeyInfoConverter(ASN1ObjectIdentifier algorithm) {
        Map map = keyInfoConverters;
        synchronized (map) {
            return (AsymmetricKeyInfoConverter)keyInfoConverters.get(algorithm);
        }
    }

    public static PublicKey getPublicKey(SubjectPublicKeyInfo publicKeyInfo) throws IOException {
        AsymmetricKeyInfoConverter converter;
        ASN1ObjectIdentifier paramAsn1ObjectIdentifier;
        AlgorithmIdentifier algorithmIdentifier = publicKeyInfo.getAlgorithm();
        ASN1ObjectIdentifier algorithmASN1ObjectIdentifier = algorithmIdentifier.getAlgorithm();
        ASN1Encodable param = algorithmIdentifier.getParameters();
        if (param instanceof ASN1ObjectIdentifier && (paramAsn1ObjectIdentifier = (ASN1ObjectIdentifier)param).equals(GBObjectIdentifiers.sm2)) {
            algorithmASN1ObjectIdentifier = GBObjectIdentifiers.sm2;
        }
        if ((converter = SwxaProvider.getAsymmetricKeyInfoConverter(algorithmASN1ObjectIdentifier)) == null) {
            return null;
        }
        return converter.generatePublic(publicKeyInfo);
    }

    public static PrivateKey getPrivateKey(PrivateKeyInfo privateKeyInfo) throws IOException {
        AsymmetricKeyInfoConverter converter;
        ASN1ObjectIdentifier paramAsn1ObjectIdentifier;
        AlgorithmIdentifier algorithmIdentifier = privateKeyInfo.getPrivateKeyAlgorithm();
        ASN1ObjectIdentifier algorithmASN1ObjectIdentifier = algorithmIdentifier.getAlgorithm();
        ASN1Encodable param = algorithmIdentifier.getParameters();
        if (param instanceof ASN1ObjectIdentifier && (paramAsn1ObjectIdentifier = (ASN1ObjectIdentifier)param).equals(GBObjectIdentifiers.sm2)) {
            algorithmASN1ObjectIdentifier = GBObjectIdentifiers.sm2;
        }
        if ((converter = SwxaProvider.getAsymmetricKeyInfoConverter(algorithmASN1ObjectIdentifier)) == null) {
            return null;
        }
        return converter.generatePrivate(privateKeyInfo);
    }

    public static void setAsymDevice(String type, String algorithm, String device) {
        SwxaProvider.setDevice(asymDeviceMap, type, algorithm, device);
    }

    public static void setsymmDevice(String type, String algorithm, String device) {
        SwxaProvider.setDevice(symmDeviceMap, type, algorithm, device);
    }

    private static void setDevice(Map deviceMap, String type, String algorithm, String device) {
        String hsm = "HSM";
        if (hsm.equals(device.toUpperCase())) {
            deviceMap.put(type + "." + algorithm, "." + hsm);
        } else {
            deviceMap.put(type + "." + algorithm, "");
        }
    }

    private static String getDevice(Map deviceMap, String type, String algorithm) {
        if (Boolean.parseBoolean(System.getProperty("SANSEC.SSL", "false"))) {
            return algorithm;
        }
        String key = type + "." + algorithm;
        String hsm = "";
        if (deviceMap.containsKey(key)) {
            hsm = (String)deviceMap.get(key);
        }
        return algorithm + hsm;
    }

    public static boolean isHsm(Boolean isPrivate, String type, String alg) {
        if (isPrivate == null) {
            String algHsm = alg + ".HSM";
            return algHsm.equals(SwxaProvider.getDevice(asymDeviceMap, type, alg));
        }
        if (isPrivate.booleanValue()) {
            String algHsm = alg + ".PrivateKey" + ".HSM";
            return algHsm.equals(SwxaProvider.getDevice(asymDeviceMap, type, alg + ".PrivateKey"));
        }
        String algHsm = alg + ".PublicKey" + ".HSM";
        return algHsm.equals(SwxaProvider.getDevice(asymDeviceMap, type, alg + ".PublicKey"));
    }

    @Override
    public synchronized Provider.Service getService(String type, String algorithm) {
        algorithm = SwxaProvider.getDevice(symmDeviceMap, type, algorithm);
        return super.getService(type, algorithm);
    }

    public static void setStateListener(HSMStateListener hsmStateListener, int listenerSleepTime) {
        if (hsmStateListener == null) {
            throw new RuntimeCryptoException("HSMStateListener cannt be null.");
        }
        if (listenerSleepTime < 0) {
            throw new RuntimeCryptoException("ListenerSleepTime should not less than 0.");
        }
        HSMPool pool = HSMPool.getPool();
        if (pool == null) {
            throw new RuntimeCryptoException("HSMPool is null,please check swsds.ini.");
        }
        pool.setHsmStateListener(hsmStateListener, listenerSleepTime);
    }

    public static ProviderStatus getProviderStatus() {
        ProviderStatus providerStatus = new ProviderStatus();
        providerStatus.setStatus("unavailable");
        HashMap<String, String> hsmStatus = new HashMap<String, String>();
        HSMPool pool = HSMPool.getPool();
        if (pool == null) {
            return providerStatus;
        }
        List sessions = pool.getAllSessions();
        if (sessions == null || sessions.size() == 0) {
            return providerStatus;
        }
        HSMSession session = (HSMSession)sessions.get(0);
        int fineCount = 0;
        int sessionSize = session.getSize();
        for (int index = 0; index < sessionSize; ++index) {
            HSMSocket socket = session.getEverySocket();
            String s = "unavailable";
            if (socket.getStatus() != 1) {
                s = "available";
                ++fineCount;
            }
            hsmStatus.put(socket.getIp(), s);
        }
        if (fineCount == sessionSize) {
            providerStatus.setStatus("available");
        } else if (fineCount > 0) {
            providerStatus.setStatus("partially");
        }
        providerStatus.setHsmStatus(hsmStatus);
        return providerStatus;
    }

    static {
        asymDeviceMap.put("KeyPairGenerator.RSA", ".HSM");
        asymDeviceMap.put("Cipher.RSA.PublicKey", ".HSM");
        asymDeviceMap.put("Cipher.RSA.PrivateKey", ".HSM");
        asymDeviceMap.put("KeyPairGenerator.SM2", ".HSM");
        asymDeviceMap.put("Cipher.SM2.PublicKey", ".HSM");
        asymDeviceMap.put("Cipher.SM2.PrivateKey", ".HSM");
        asymDeviceMap.put("Signature.SM2.PublicKey", ".HSM");
        asymDeviceMap.put("Signature.SM2.PrivateKey", ".HSM");
        asymDeviceMap.put("KeyPairGenerator.ECDSA", ".HSM");
        asymDeviceMap.put("Cipher.ECDSA.PublicKey", ".HSM");
        asymDeviceMap.put("Cipher.ECDSA.PrivateKey", ".HSM");
        asymDeviceMap.put("Signature.ECDSA.PublicKey", ".HSM");
        asymDeviceMap.put("Signature.ECDSA.PrivateKey", ".HSM");
        asymDeviceMap.put("KeyPairGenerator.ED25519", ".HSM");
        asymDeviceMap.put("KeyPairGenerator.DSA", ".HSM");
        asymDeviceMap.put("Signature.DSA.PublicKey", ".HSM");
        asymDeviceMap.put("Signature.DSA.PrivateKey", ".HSM");
        asymDeviceMap.put("KeyAgreement.ECDH.PrivateKey", ".HSM");
        symmDeviceMap.put("KeyGenerator.AES", ".HSM");
        symmDeviceMap.put("KeyGenerator.SM1", ".HSM");
        symmDeviceMap.put("KeyGenerator.SM7", ".HSM");
        symmDeviceMap.put("KeyGenerator.SM4", ".HSM");
        symmDeviceMap.put("KeyGenerator.SSF33", ".HSM");
        symmDeviceMap.put("KeyGenerator.DES", ".HSM");
        symmDeviceMap.put("KeyGenerator.3DES", ".HSM");
        symmDeviceMap.put("KeyGenerator.DES3", ".HSM");
        symmDeviceMap.put("KeyGenerator.DESEDE", ".HSM");
        symmDeviceMap.put("KeyGenerator.DESede", ".HSM");
        symmDeviceMap.put("Cipher.AES", ".HSM");
        symmDeviceMap.put("Cipher.AES128", ".HSM");
        symmDeviceMap.put("Cipher.AESCBC", ".HSM");
        symmDeviceMap.put("Cipher.AESGCM", ".HSM");
        symmDeviceMap.put("Cipher.AESCFB", ".HSM");
        symmDeviceMap.put("Cipher.AESOFB", ".HSM");
        symmDeviceMap.put("Cipher." + NISTObjectIdentifiers.id_aes128_ECB, ".HSM");
        symmDeviceMap.put("Cipher." + NISTObjectIdentifiers.id_aes192_ECB, ".HSM");
        symmDeviceMap.put("Cipher." + NISTObjectIdentifiers.id_aes256_ECB, ".HSM");
        symmDeviceMap.put("Cipher." + NISTObjectIdentifiers.id_aes128_CBC, ".HSM");
        symmDeviceMap.put("Cipher." + NISTObjectIdentifiers.id_aes192_CBC, ".HSM");
        symmDeviceMap.put("Cipher." + NISTObjectIdentifiers.id_aes256_CBC, ".HSM");
        symmDeviceMap.put("Cipher.SM1", ".HSM");
        symmDeviceMap.put("Cipher." + GBObjectIdentifiers.sm1, ".HSM");
        symmDeviceMap.put("Cipher.SM1CBC", ".HSM");
        symmDeviceMap.put("Cipher.SM1CTR", ".HSM");
        symmDeviceMap.put("AlgorithmParameters.SM1", ".HSM");
        symmDeviceMap.put("AlgorithmParameterGenerator.SM1", ".HSM");
        symmDeviceMap.put("Cipher.SM4", ".HSM");
        symmDeviceMap.put("Cipher." + GBObjectIdentifiers.sm4, ".HSM");
        symmDeviceMap.put("Cipher.SM4CBC", ".HSM");
        symmDeviceMap.put("Cipher.SM4CTR", ".HSM");
        symmDeviceMap.put("Cipher.SM4/GCM", ".HSM");
        symmDeviceMap.put("Cipher.SM4CCM", ".HSM");
        symmDeviceMap.put("AlgorithmParameters.SM4", ".HSM");
        symmDeviceMap.put("AlgorithmParameterGenerator.SM4", ".HSM");
        symmDeviceMap.put("Cipher.SM7", ".HSM");
        symmDeviceMap.put("Cipher." + GBObjectIdentifiers.sm7, ".HSM");
        symmDeviceMap.put("Cipher.SM7CBC", ".HSM");
        symmDeviceMap.put("Cipher.SM7CTR", ".HSM");
        symmDeviceMap.put("AlgorithmParameters.SM7", ".HSM");
        symmDeviceMap.put("AlgorithmParameterGenerator.SM7", ".HSM");
        symmDeviceMap.put("Cipher.SSF33", ".HSM");
        symmDeviceMap.put("Alg.Alias.Cipher." + GBObjectIdentifiers.ssf33, ".HSM");
        symmDeviceMap.put("Cipher.SSF33CBC", ".HSM");
        symmDeviceMap.put("AlgorithmParameters.SSF33", ".HSM");
        symmDeviceMap.put("AlgorithmParameterGenerator.SSF33", ".HSM");
        symmDeviceMap.put("Cipher.DESEDE3", ".HSM");
        symmDeviceMap.put("Cipher.DESede", ".HSM");
        symmDeviceMap.put("Cipher.DES3", ".HSM");
        symmDeviceMap.put("Cipher.3DES", ".HSM");
        symmDeviceMap.put("Cipher." + PKCSObjectIdentifiers.des_EDE3_CBC, ".HSM");
        symmDeviceMap.put("Cipher.3DES/CBC/", ".HSM");
        symmDeviceMap.put("Cipher.3DESCBC", ".HSM");
        symmDeviceMap.put("Cipher.3DESCFB", ".HSM");
        symmDeviceMap.put("Cipher.3DESOFB", ".HSM");
        symmDeviceMap.put("Cipher.DESede/CBC/", ".HSM");
        symmDeviceMap.put("Cipher.DESedeCBC", ".HSM");
        symmDeviceMap.put("Cipher.DESedeCFB", ".HSM");
        symmDeviceMap.put("Cipher.DESedeOFB", ".HSM");
    }

    public static class ProviderStatus {
        public static final String STATUS_AVAILABLE = "available";
        public static final String STATUS_PARTIALLY = "partially";
        public static final String STATUS_UNAVAILABLE = "unavailable";
        private String status;
        private Map<String, String> hsmStatus;

        public String getStatus() {
            return this.status;
        }

        protected void setStatus(String status) {
            this.status = status;
        }

        public Map<String, String> getHsmStatus() {
            return this.hsmStatus;
        }

        protected void setHsmStatus(Map<String, String> hsmStatus) {
            this.hsmStatus = hsmStatus;
        }
    }
}

