/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.jsses.provider;

import com.sansec.jsses.provider.spec.TlsSm2PremasterSecretParameterSpec;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public final class TlsSm2PremasterSecretGenerator
extends KeyGeneratorSpi {
    private static final String MSG = "TlsSm2PremasterSecretGenerator must be initialized using a TlsSm2PremasterSecretParameterSpec";
    private TlsSm2PremasterSecretParameterSpec spec;
    private SecureRandom random;

    @Override
    protected void engineInit(SecureRandom random) {
        throw new InvalidParameterException(MSG);
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        if (!(params instanceof TlsSm2PremasterSecretParameterSpec)) {
            throw new InvalidAlgorithmParameterException(MSG);
        }
        this.spec = (TlsSm2PremasterSecretParameterSpec)params;
        this.random = random;
    }

    @Override
    protected void engineInit(int keysize, SecureRandom random) {
        throw new InvalidParameterException(MSG);
    }

    @Override
    protected SecretKey engineGenerateKey() {
        if (this.spec == null) {
            throw new IllegalStateException("TlsSm2PremasterSecretGenerator must be initialized");
        }
        if (this.random == null) {
            this.random = new SecureRandom();
        }
        byte[] b = new byte[48];
        this.random.nextBytes(b);
        b[0] = (byte)this.spec.getMajorVersion();
        b[1] = (byte)this.spec.getMinorVersion();
        return new SecretKeySpec(b, "TlsSm2PremasterSecret");
    }
}

