/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.math.ec;

import com.sansec.math.ec.ECAlgorithms;
import com.sansec.math.ec.ECMultiplier;
import com.sansec.math.ec.ECPoint;
import java.math.BigInteger;

public abstract class AbstractECMultiplier
implements ECMultiplier {
    @Override
    public ECPoint multiply(ECPoint p, BigInteger k) {
        int sign = k.signum();
        if (sign == 0 || p.isInfinity()) {
            return p.getCurve().getInfinity();
        }
        ECPoint positive = this.multiplyPositive(p, k.abs());
        ECPoint result = sign > 0 ? positive : positive.negate();
        return ECAlgorithms.validatePoint(result);
    }

    protected abstract ECPoint multiplyPositive(ECPoint var1, BigInteger var2);
}

