/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.pqc.jcajce.provider.mceliece;

import com.sansec.asn1.DERNull;
import com.sansec.asn1.nist.NISTObjectIdentifiers;
import com.sansec.asn1.oiw.OIWObjectIdentifiers;
import com.sansec.asn1.x509.AlgorithmIdentifier;
import com.sansec.crypto.Digest;
import com.sansec.crypto.digests.SHA1Digest;
import com.sansec.crypto.digests.SHA224Digest;
import com.sansec.crypto.digests.SHA256Digest;
import com.sansec.crypto.digests.SHA384Digest;
import com.sansec.crypto.digests.SHA512Digest;

class Utils {
    Utils() {
    }

    static AlgorithmIdentifier getDigAlgId(String digestName) {
        if (digestName.equals("SHA-1")) {
            return new AlgorithmIdentifier(OIWObjectIdentifiers.idSHA1, DERNull.INSTANCE);
        }
        if (digestName.equals("SHA-224")) {
            return new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha224, DERNull.INSTANCE);
        }
        if (digestName.equals("SHA-256")) {
            return new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha256, DERNull.INSTANCE);
        }
        if (digestName.equals("SHA-384")) {
            return new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha384, DERNull.INSTANCE);
        }
        if (digestName.equals("SHA-512")) {
            return new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha512, DERNull.INSTANCE);
        }
        throw new IllegalArgumentException("unrecognised digest algorithm: " + digestName);
    }

    static Digest getDigest(AlgorithmIdentifier digest) {
        if (digest.getAlgorithm().equals(OIWObjectIdentifiers.idSHA1)) {
            return new SHA1Digest();
        }
        if (digest.getAlgorithm().equals(NISTObjectIdentifiers.id_sha224)) {
            return new SHA224Digest();
        }
        if (digest.getAlgorithm().equals(NISTObjectIdentifiers.id_sha256)) {
            return new SHA256Digest();
        }
        if (digest.getAlgorithm().equals(NISTObjectIdentifiers.id_sha384)) {
            return new SHA384Digest();
        }
        if (digest.getAlgorithm().equals(NISTObjectIdentifiers.id_sha512)) {
            return new SHA512Digest();
        }
        throw new IllegalArgumentException("unrecognised OID in digest algorithm identifier: " + digest.getAlgorithm());
    }
}

