/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.devicev4.crypto_hsm.sds.cmd.hsm.socket;

import com.sansec.devicev4.api.CryptoException;
import com.sansec.devicev4.crypto_hsm.config.ConfigFile;
import com.sansec.devicev4.crypto_hsm.sds.cmd.hsm.socket.HSMPool;
import com.sansec.devicev4.crypto_hsm.sds.cmd.hsm.socket.HSMSocket;
import com.sansec.devicev4.crypto_hsm.sds.cmd.hsm.socket.HSMSocketException;
import com.sansec.devicev4.crypto_hsm.sds.cmd.hsm.socket.RepairPool;
import com.sansec.devicev4.crypto_hsm.sds.cmd.hsm.socket.bean.HSMInfo;
import com.sansec.devicev4.log.CryptoLogger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;

public final class HSMSession {
    private Logger logger = CryptoLogger.logger;
    private int size = 0;
    private HSMSocket[] sockets = new HSMSocket[20];
    private static AtomicInteger[] custormCount = new AtomicInteger[20];
    private int cnt = 0;

    public HSMSession(ConfigFile profile, String loginPass, String keyStorePass, String trustStorePass) throws CryptoException {
        List<HSMInfo> allHsm = profile.getServer();
        this.size = allHsm.size();
        boolean connect = false;
        for (int i = 0; i < allHsm.size(); ++i) {
            HSMInfo info = allHsm.get(i);
            if (custormCount[i] == null) {
                HSMSession.custormCount[i] = new AtomicInteger();
            }
            try {
                this.sockets[i] = new HSMSocket(profile, info, i, loginPass, keyStorePass, trustStorePass);
                this.sockets[i].login();
                connect = true;
                continue;
            }
            catch (Exception e) {
                this.logger.severe("HSMSession -[" + i + "]- IP:( " + info.getIp() + " ),cant connect.");
                this.sockets[i].setStatus(1);
                try {
                    this.logger.info("info: new Thread.RepairPool(hsmSocket)).start(), ip=" + this.sockets[i].getIp() + " status=" + this.sockets[i].getStatus());
                    RepairPool rt = new RepairPool(this.sockets[i]);
                    Thread t1 = new Thread(rt);
                    t1.setDaemon(true);
                    t1.setName("RepairPool");
                    t1.start();
                    continue;
                }
                catch (Exception e1) {
                    this.logger.severe("error: create RepairPool Thread failed! ip=" + this.sockets[i].getIp() + e1.getMessage());
                    throw new CryptoException(e1.getMessage());
                }
            }
        }
        if (!connect) {
            throw new CryptoException("HSMSession -- all HSM canntconnect");
        }
    }

    public void repair() throws HSMSocketException {
        this.logger.info("repair");
        for (int i = 0; i < this.getSize(); ++i) {
            this.sockets[i].repair(0L);
        }
        this.logger.info("repair->return");
    }

    public HSMSocket getHsmSocket() {
        HSMSocket socket = null;
        int minIndex = this.getMinHsmIndex();
        socket = this.sockets[minIndex];
        return socket;
    }

    public HSMSocket getEverySocket() {
        HSMSocket socket = this.sockets[this.cnt];
        this.cnt = (this.cnt + 1) % this.getSize();
        return socket;
    }

    public void releaseHsmSocket(HSMSocket socket) {
        custormCount[socket.getIndexOfSession()].decrementAndGet();
    }

    private synchronized int getMinHsmIndex() {
        int minIndex = 0;
        TreeMap<Integer, Integer> map = new TreeMap<Integer, Integer>();
        int count = this.size;
        for (int i = 0; i < count; ++i) {
            if (this.sockets[i] == null) continue;
            if (this.sockets[i].getStatus() == 3) {
                this.sockets[i].close();
                HSMSession.custormCount[i] = new AtomicInteger();
                continue;
            }
            if (this.sockets[i].getStatus() == 1) continue;
            int cusCount = custormCount[i].get();
            map.put(i, cusCount);
        }
        if (!map.isEmpty()) {
            ArrayList list = new ArrayList(map.entrySet());
            Collections.sort(list, new Comparator<Map.Entry<Integer, Integer>>(){

                @Override
                public int compare(Map.Entry<Integer, Integer> o1, Map.Entry<Integer, Integer> o2) {
                    return o1.getValue().compareTo(o2.getValue());
                }
            });
            minIndex = (Integer)((Map.Entry)list.get(0)).getKey();
        }
        custormCount[minIndex].incrementAndGet();
        return minIndex;
    }

    public int getSize() {
        return this.size;
    }

    public void close() {
        for (int i = 0; i < this.getSize(); ++i) {
            this.sockets[i].close();
        }
    }

    public HSMSocket addHsm(ConfigFile configFile, int i, int index) {
        HSMInfo info = configFile.getServer().get(index);
        if (custormCount[i] == null) {
            HSMSession.custormCount[i] = new AtomicInteger();
        }
        String loginPass = HSMPool.getPool().loginPass;
        String keyStorePass = HSMPool.getPool().keyStorePass;
        String trustStorePass = HSMPool.getPool().trustKeyStorePass;
        HSMSocket socket = new HSMSocket(configFile, info, index, loginPass, keyStorePass, trustStorePass);
        socket.setIndexOfSession(i);
        socket.setStatus(1);
        if (this.sockets[i] == null) {
            ++this.size;
        }
        this.sockets[i] = socket;
        return socket;
    }

    public void changeDelState(int index) {
        this.sockets[index].setStatus(3);
    }
}

