/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.devicev4.crypto_hsm.sds.cmd.hsm.socket;

import com.sansec.devicev4.crypto_hsm.sds.cmd.hsm.socket.HSMPool;
import com.sansec.devicev4.crypto_hsm.sds.cmd.hsm.socket.HSMSession;
import com.sansec.devicev4.crypto_hsm.sds.cmd.hsm.socket.HSMSocket;
import com.sansec.devicev4.crypto_hsm.sds.cmd.hsm.socket.HSMSocketException;
import com.sansec.devicev4.crypto_hsm.sds.cmd.hsm.socket.ListenerExceptionHandler;
import com.sansec.devicev4.crypto_hsm.sds.cmd.hsm.socket.RepairPool;
import com.sansec.devicev4.crypto_hsm.sds.cmd.hsm.socket.bean.Request;
import com.sansec.devicev4.crypto_hsm.sds.cmd.hsm.socket.bean.Response;
import com.sansec.devicev4.log.CryptoLogger;
import com.sansec.devicev4.util.BytesUtil;
import java.util.logging.Logger;

public class ListenerTast
implements Runnable {
    private Logger logger = CryptoLogger.logger;
    private int sleepTime = 0;
    private static ListenerExceptionHandler exceptionHandler = new ListenerExceptionHandler();

    public ListenerTast(int sleepTime) {
        this.sleepTime = sleepTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.logger.warning("ListenerTast starting..." + Thread.currentThread().getId());
        Thread.currentThread().setUncaughtExceptionHandler(exceptionHandler);
        HSMPool pool = HSMPool.getPool();
        block10: while (true) {
            try {
                Thread.sleep(this.sleepTime * 60000);
            }
            catch (InterruptedException e) {
                this.logger.warning("ListenerTast error,sleepTime is " + this.sleepTime + "," + e.getMessage());
                e.printStackTrace();
            }
            HSMSession session = pool.getSession();
            int size = session.getSize();
            try {
                int i = 0;
                while (true) {
                    block14: {
                        if (i >= size) continue block10;
                        HSMSocket hsmSocket = session.getEverySocket();
                        if (hsmSocket != null) {
                            try {
                                if (hsmSocket.getStatus() != 0) break block14;
                                try {
                                    Request request = new Request(131074, BytesUtil.int2bytes(1));
                                    Response response = hsmSocket.sendAndReceive(request.encode());
                                    if (response.getErrorCode() != 0) {
                                        this.logger.fine(hsmSocket + " sendAndReceive return: " + response.getErrorInfo());
                                        throw new HSMSocketException(hsmSocket + " return( " + response.getErrorInfo() + " )");
                                    }
                                }
                                catch (HSMSocketException e) {
                                    this.logger.severe("Listener -- IP:( " + hsmSocket.getIp() + " ),cant connect.");
                                    hsmSocket.setStatus(1);
                                    RepairPool rt = new RepairPool(hsmSocket);
                                    Thread t1 = new Thread(rt);
                                    t1.setDaemon(true);
                                    t1.setName("ListenerTast RepairPool");
                                    t1.start();
                                }
                            }
                            finally {
                                session.releaseHsmSocket(hsmSocket);
                            }
                        }
                    }
                    ++i;
                }
            }
            finally {
                pool.release(session);
                continue;
            }
            break;
        }
    }
}

