/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.devicev4.crypto_hsm.sds.cmd.hsm.socket;

import com.sansec.devicev4.log.CryptoLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

public class TLSManagers {
    private static Logger logger = CryptoLogger.logger;
    private static KeyManager[] kms;
    private static TrustManager[] tms;
    private static SSLContext context;

    private static final KeyManager[] getClientKeyManagers(String keystoreType, String keyStore, String keyStorePassword) throws Exception {
        if (kms == null) {
            File keyStoreFile = new File(keyStore);
            if (!(keyStoreFile.exists() && keyStoreFile.isFile() && keyStoreFile.canRead())) {
                if (logger.isLoggable(Level.SEVERE)) {
                    logger.severe("KeyStore file is not existing, file path is " + keyStore);
                }
                return kms;
            }
            FileInputStream inputStream = new FileInputStream(keyStoreFile);
            try {
                KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
                KeyStore ks = KeyStore.getInstance(keystoreType);
                ks.load(inputStream, keyStorePassword.toCharArray());
                kmf.init(ks, keyStorePassword.toCharArray());
                kms = kmf.getKeyManagers();
            }
            catch (Exception e) {
                if (logger.isLoggable(Level.SEVERE)) {
                    logger.severe("Load keystore fail :" + e.getMessage());
                }
                throw e;
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
        return kms;
    }

    private static final TrustManager[] getClientTrustManagers(String keystoreType, String trustKeyStore, String trustKeyStorePassword) throws Exception {
        if (tms == null) {
            File trustKeyStoreFile = new File(trustKeyStore);
            if (!(trustKeyStoreFile.exists() && trustKeyStoreFile.isFile() && trustKeyStoreFile.canRead())) {
                if (logger.isLoggable(Level.SEVERE)) {
                    logger.severe("TrustKeyStore file is not existing, file path is " + trustKeyStore);
                }
                throw new FileNotFoundException("Trust keystore file is not found");
            }
            FileInputStream inputStream = new FileInputStream(trustKeyStoreFile);
            try {
                TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509");
                KeyStore tks = KeyStore.getInstance(keystoreType);
                tks.load(new FileInputStream(trustKeyStore), trustKeyStorePassword.toCharArray());
                tmf.init(tks);
                tms = tmf.getTrustManagers();
            }
            catch (Exception e) {
                if (logger.isLoggable(Level.SEVERE)) {
                    logger.severe("Load trustkeystore fail :" + e.getMessage());
                }
                throw e;
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
        return tms;
    }

    public static final SSLContext getSSLContext(String protocol, String keyStoreType, String keyStore, String keyStorePassword, String trustKeyStoreType, String trustKeyStore, String trustKeyStorePassword) throws Exception {
        if (context == null) {
            context = SSLContext.getInstance(protocol);
            KeyManager[] kms = TLSManagers.getClientKeyManagers(keyStoreType, keyStore, keyStorePassword);
            TrustManager[] tms = TLSManagers.getClientTrustManagers(trustKeyStoreType, trustKeyStore, trustKeyStorePassword);
            context.init(kms, tms, new SecureRandom());
        }
        return context;
    }

    static {
        tms = null;
        context = null;
    }
}

