/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.devicev4.demo;

import com.sansec.devicev4.SwxaDeviceFactory;
import com.sansec.devicev4.api.CryptoException;
import com.sansec.devicev4.api.ISDSCrypto;
import com.sansec.devicev4.util.BytesUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Random;

public class BjCATest {
    static ISDSCrypto crypto = null;
    Random random = new Random();

    public BjCATest() throws CryptoException {
        crypto = SwxaDeviceFactory.getInstance("com.sansec.devicev4.crypto_hsm.SDSCryptoFactory", "D:\\bjca\\swsds.ini");
    }

    private void test_SDF_GenerateEncKeyPairWithKEK() throws IOException {
        int alg = 0;
        int bits = 0;
        int kekIndex = 0;
        int kekAlg = 0;
        System.out.println("\u5bc6\u94a5\u7b97\u6cd5\uff1a1-SGD_RSA|2-SGD_SM2:");
        String algStr = new BufferedReader(new InputStreamReader(System.in, "utf-8")).readLine();
        int algIn = Integer.parseInt(algStr);
        switch (algIn) {
            case 1: {
                alg = 65536;
                break;
            }
            case 2: {
                alg = 131072;
            }
        }
        System.out.print("\u5bc6\u94a5\u957f\u5ea6(bit 1024,2048,256)\uff1a");
        String bitsStr = new BufferedReader(new InputStreamReader(System.in, "utf-8")).readLine();
        bits = Integer.parseInt(bitsStr);
        System.out.print("KEK\u5bc6\u94a5\u7d22\u5f15(1-200):");
        String str = new BufferedReader(new InputStreamReader(System.in, "utf-8")).readLine();
        kekIndex = Integer.parseInt(str);
        System.out.println("KEK\u52a0\u5bc6\u79c1\u94a5\u7b97\u6cd5,1-SGD_AES_ECB|2-SGD_SM4_ECB:");
        String typeStr = new BufferedReader(new InputStreamReader(System.in, "utf-8")).readLine();
        int type = Integer.parseInt(typeStr);
        switch (type) {
            case 1: {
                kekAlg = 1025;
                break;
            }
            case 2: {
                kekAlg = 8193;
            }
        }
        List<byte[]> out = null;
        try {
            out = crypto.SDF_GenerateEncKeyPairWithKEK(alg, bits, kekIndex, kekAlg);
        }
        catch (CryptoException e) {
            e.printStackTrace();
            return;
        }
        System.out.println("-->Type[" + type + "]");
        System.out.println("PublicKey:\n" + BytesUtil.bytes2hex(out.get(0)));
        System.out.println("PrivateKey:\n" + BytesUtil.bytes2hex(out.get(1)));
    }

    private void test_SDF_SignWithEncPrivateKey() throws IOException {
        int signAlg = 0;
        int hashAlg = 0;
        int kekAlg = 0;
        int kekIndex = 0;
        byte[] encPrivateKey = null;
        byte[] data = null;
        System.out.println("\u7b7e\u540d\u7b97\u6cd5\uff1a1-SGD_RSA_SIGN|2-SGD_SM2_SIGN:");
        String algStr = new BufferedReader(new InputStreamReader(System.in, "utf-8")).readLine();
        int algIn = Integer.parseInt(algStr);
        switch (algIn) {
            case 1: {
                signAlg = 65792;
                break;
            }
            case 2: {
                signAlg = 131328;
            }
        }
        System.out.println("\u6458\u8981\u7b97\u6cd5\uff1a1-SGD_SHA256|2-SGD_SM3|0-\u4e0d\u505a\u6458\u8981:");
        String hashAlgStr = new BufferedReader(new InputStreamReader(System.in, "utf-8")).readLine();
        int hashAlgIn = Integer.parseInt(hashAlgStr);
        switch (hashAlgIn) {
            case 1: {
                hashAlg = 4;
                break;
            }
            case 2: {
                hashAlg = 1;
                break;
            }
            case 0: {
                hashAlg = 0;
            }
        }
        System.out.println("\u5bf9\u79f0KEK\u7b97\u6cd5\uff1a1-SGD_AES_ECB|2-SGD_SM4_ECB:");
        String kekAlgStr = new BufferedReader(new InputStreamReader(System.in, "utf-8")).readLine();
        int kekAlgIn = Integer.parseInt(kekAlgStr);
        switch (kekAlgIn) {
            case 1: {
                kekAlg = 1025;
                break;
            }
            case 2: {
                kekAlg = 8193;
            }
        }
        System.out.print("KEK\u5bc6\u94a5\u7d22\u5f15(1-200):");
        String str = new BufferedReader(new InputStreamReader(System.in, "utf-8")).readLine();
        kekIndex = Integer.parseInt(str);
        System.out.print("\u79c1\u94a5\u5bc6\u6587(16\u8fdb\u5236\u5b57\u7b26\u4e32):");
        String encstr = new BufferedReader(new InputStreamReader(System.in, "utf-8")).readLine();
        encPrivateKey = BytesUtil.hex2bytes(encstr);
        System.out.println("\u5f85\u7b7e\u540d\u6570\u636e\u957f\u5ea6:");
        String typeStr = new BufferedReader(new InputStreamReader(System.in, "utf-8")).readLine();
        int dataLen = Integer.parseInt(typeStr);
        data = new byte[dataLen];
        this.random.nextBytes(data);
        System.out.println("\u660e\u6587\uff1a\n" + BytesUtil.bytes2hex(data));
        byte[] out = null;
        try {
            out = crypto.SDF_SignWithEncPrivateKey(signAlg, hashAlg, kekAlg, kekIndex, encPrivateKey, data);
        }
        catch (CryptoException e) {
            e.printStackTrace();
            return;
        }
        System.out.println("\u7b7e\u540d\u503c:\n" + BytesUtil.bytes2hex(out));
    }

    private void test_SDF_GeneratSymEncKey() throws IOException {
        int alg = 0;
        int bits = 0;
        int kekIndex = 0;
        System.out.println("KEK\u52a0\u5bc6\u79c1\u94a5\u7b97\u6cd5,1-SGD_AES_ECB|2-SGD_SM4_ECB:");
        String typeStr = new BufferedReader(new InputStreamReader(System.in, "utf-8")).readLine();
        int type = Integer.parseInt(typeStr);
        switch (type) {
            case 1: {
                alg = 1025;
                break;
            }
            case 2: {
                alg = 8193;
            }
        }
        System.out.print("KEK\u5bc6\u94a5\u7d22\u5f15(1-200):");
        String str = new BufferedReader(new InputStreamReader(System.in, "utf-8")).readLine();
        kekIndex = Integer.parseInt(str);
        System.out.print("\u5bc6\u94a5\u957f\u5ea6(bit 128,256)\uff1a");
        String bitsStr = new BufferedReader(new InputStreamReader(System.in, "utf-8")).readLine();
        bits = Integer.parseInt(bitsStr);
        byte[] out = null;
        try {
            out = crypto.SDF_GeneratSymEncKey(alg, kekIndex, bits);
        }
        catch (CryptoException e) {
            e.printStackTrace();
            return;
        }
        System.out.println("\u5bf9\u79f0\u5bc6\u94a5\u5bc6\u6587:\n" + BytesUtil.bytes2hex(out));
    }

    private void test_SDF_SymEncryptWithEncKey() throws IOException {
        int alg = 0;
        byte[] encKey = null;
        int paddingType = 0;
        byte[] iv = null;
        int kekAlg = 0;
        int kekIndex = 0;
        byte[] data = null;
        System.out.println("\u5bf9\u79f0\u5bc6\u94a5\u7b97\u6cd5,1-SGD_AES_ECB|2-SGD_SM4_ECB|3-SGD_AES_CBC|4-SGD_SM4_CBC:");
        String typeStr = new BufferedReader(new InputStreamReader(System.in, "utf-8")).readLine();
        int type = Integer.parseInt(typeStr);
        switch (type) {
            case 1: {
                alg = 1025;
                break;
            }
            case 2: {
                alg = 8193;
                break;
            }
            case 3: {
                alg = 1026;
                break;
            }
            case 4: {
                alg = 8194;
            }
        }
        System.out.print("\u79c1\u94a5\u5bc6\u6587(16\u8fdb\u5236\u5b57\u7b26\u4e32):");
        String encstr = new BufferedReader(new InputStreamReader(System.in, "utf-8")).readLine();
        encKey = BytesUtil.hex2bytes(encstr);
        System.out.println("\u8865\u4e01\u6a21\u5f0f\uff1a1-PKCS5|0-\u4e0d\u6253\u8865\u4e01:");
        String paddingTypeStr = new BufferedReader(new InputStreamReader(System.in, "utf-8")).readLine();
        paddingType = Integer.parseInt(paddingTypeStr);
        System.out.println("IV\u957f\u5ea6:");
        String ivLenStr = new BufferedReader(new InputStreamReader(System.in, "utf-8")).readLine();
        int ivLen = Integer.parseInt(ivLenStr);
        iv = new byte[ivLen];
        this.random.nextBytes(iv);
        System.out.println("\u5bf9\u79f0KEK\u7b97\u6cd5\uff1a1-SGD_AES_ECB|2-SGD_SM4_ECB:");
        String kekAlgStr = new BufferedReader(new InputStreamReader(System.in, "utf-8")).readLine();
        int kekAlgIn = Integer.parseInt(kekAlgStr);
        switch (kekAlgIn) {
            case 1: {
                kekAlg = 1025;
                break;
            }
            case 2: {
                kekAlg = 8193;
            }
        }
        System.out.print("KEK\u5bc6\u94a5\u7d22\u5f15(1-200):");
        String str = new BufferedReader(new InputStreamReader(System.in, "utf-8")).readLine();
        kekIndex = Integer.parseInt(str);
        System.out.println("\u5f85\u52a0\u5bc6\u6570\u636e\u957f\u5ea6:");
        String dataLenStr = new BufferedReader(new InputStreamReader(System.in, "utf-8")).readLine();
        int dataLen = Integer.parseInt(dataLenStr);
        data = new byte[dataLen];
        this.random.nextBytes(data);
        System.out.println("\u660e\u6587\uff1a\n" + BytesUtil.bytes2hex(data));
        byte[] out = null;
        try {
            out = crypto.SDF_SymEncryptWithEncKey(alg, encKey, paddingType, iv, kekAlg, kekIndex, data);
        }
        catch (CryptoException e) {
            e.printStackTrace();
            return;
        }
        System.out.println("\u5bc6\u6587:\n" + BytesUtil.bytes2hex(out));
        byte[] out2 = null;
        try {
            out2 = crypto.SDF_SymDecryptWithEncKey(alg, encKey, paddingType, iv, kekAlg, kekIndex, out);
        }
        catch (CryptoException e) {
            e.printStackTrace();
            return;
        }
        System.out.println("\u660e\u6587:\n" + BytesUtil.bytes2hex(out2));
    }

    private void test_SDF_HMACWithKEK() throws IOException {
        int alg = 0;
        int kekIndex = 0;
        byte[] data = null;
        System.out.println("\u5bc6\u94a5\u7b97\u6cd5\uff1a1-SGD_SM3|2-SGD_SHA1|3-SGD_SHA256:");
        String algStr = new BufferedReader(new InputStreamReader(System.in, "utf-8")).readLine();
        int algIn = Integer.parseInt(algStr);
        switch (algIn) {
            case 1: {
                alg = 1;
                break;
            }
            case 2: {
                alg = 2;
                break;
            }
            case 3: {
                alg = 4;
            }
        }
        System.out.print("KEK\u5bc6\u94a5\u7d22\u5f15(1-200):");
        String str = new BufferedReader(new InputStreamReader(System.in, "utf-8")).readLine();
        kekIndex = Integer.parseInt(str);
        System.out.println("\u5f85\u8fd0\u7b97\u6570\u636e\u957f\u5ea6:");
        String dataLenStr = new BufferedReader(new InputStreamReader(System.in, "utf-8")).readLine();
        int dataLen = Integer.parseInt(dataLenStr);
        data = new byte[dataLen];
        this.random.nextBytes(data);
        System.out.println("\u660e\u6587\uff1a\n" + BytesUtil.bytes2hex(data));
        byte[] out = null;
        try {
            out = crypto.SDF_HMACWithKEK(alg, kekIndex, data);
        }
        catch (CryptoException e) {
            e.printStackTrace();
            return;
        }
        System.out.println("HMAC\u7ed3\u679c:\n" + BytesUtil.bytes2hex(out));
    }

    public static void main(String[] args) throws Exception {
        System.out.println(BytesUtil.bytes2hex(null));
        BjCATest bjCATest = new BjCATest();
        while (true) {
            System.out.println("++++++++++++++++++++++++++++++++++Crypto\u529f\u80fd\u6d4b\u8bd5++++++++++++++++++++++++++++++++");
            System.out.println("1:\u751f\u6210\u5185\u90e8\u52a0\u5bc6\u7684\u516c\u79c1\u94a5\u5bf9,SDF_GenerateEncKeyPairWithKEK");
            System.out.println("2:\u79c1\u94a5\u5bc6\u6587\u7b7e\u540d,SDF_SignWithEncPrivateKey");
            System.out.println("3:\u751f\u6210\u5bf9\u79f0\u5bc6\u94a5\u5bc6\u6587,SDF_GeneratSymEncKey");
            System.out.println("4:\u4f7f\u7528\u5bf9\u79f0\u5bc6\u94a5\u5bc6\u6587\u52a0\u5bc6\u89e3\u5bc6,SDF_SymEncryptWithEncKey,SDF_SymDecryptWithEncKey");
            System.out.println("5:\u5185\u90e8\u5bf9\u79f0\u5bc6\u94a5\u751f\u6210HMAC,SDF_HMACWithKEK");
            System.out.println("");
            System.out.println("0\uff1a\u9000\u51fa");
            System.out.println("+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++");
            System.out.print("\u9009\u62e9\u6d4b\u8bd5\uff1a");
            String str = new BufferedReader(new InputStreamReader(System.in, "utf-8")).readLine();
            int choice = Integer.parseInt(str);
            switch (choice) {
                case 1: {
                    bjCATest.test_SDF_GenerateEncKeyPairWithKEK();
                    break;
                }
                case 2: {
                    bjCATest.test_SDF_SignWithEncPrivateKey();
                    break;
                }
                case 3: {
                    bjCATest.test_SDF_GeneratSymEncKey();
                    break;
                }
                case 4: {
                    bjCATest.test_SDF_SymEncryptWithEncKey();
                    break;
                }
                case 5: {
                    bjCATest.test_SDF_HMACWithKEK();
                }
            }
        }
    }
}

