/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.devicev4.demo;

import com.sansec.devicev4.SwxaDeviceFactory;
import com.sansec.devicev4.api.CryptoException;
import com.sansec.devicev4.api.ISDSCrypto;
import com.sansec.devicev4.gb.struct.key.changhongecdsa.ECCSignature;
import com.sansec.devicev4.gb.struct.key.changhongecdsa.ECCrefCurveParam;
import com.sansec.devicev4.gb.struct.key.changhongecdsa.ECCrefKeyPair;
import com.sansec.devicev4.util.BytesUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Random;

public class ChanghongTest {
    static ISDSCrypto crypto = null;
    byte[] p = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -2, -1, -1, -4, 47};
    byte[] a = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    byte[] b = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7};
    byte[] gx = new byte[]{121, -66, 102, 126, -7, -36, -69, -84, 85, -96, 98, -107, -50, -121, 11, 7, 2, -101, -4, -37, 45, -50, 40, -39, 89, -14, -127, 91, 22, -8, 23, -104};
    byte[] gy = new byte[]{72, 58, -38, 119, 38, -93, -60, 101, 93, -92, -5, -4, 14, 17, 8, -88, -3, 23, -76, 72, -90, -123, 84, 25, -100, 71, -48, -113, -5, 16, -44, -72};
    byte[] n = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -2, -70, -82, -36, -26, -81, 72, -96, 59, -65, -46, 94, -116, -48, 54, 65, 65};
    int len = 256;
    ECCrefCurveParam ecCrefCurveParam = new ECCrefCurveParam(this.p, this.a, this.b, this.gx, this.gy, this.n, this.len);
    Random random = new Random();

    public ChanghongTest() throws CryptoException {
        crypto = SwxaDeviceFactory.getInstance();
    }

    private void test_Internal() throws IOException {
        int uiKeyNumber = 1;
        try {
            crypto.SDF_InitECC_Secp256k1();
        }
        catch (CryptoException e) {
            System.out.println("\u521d\u59cb\u5316\u5931\u8d25");
            e.printStackTrace();
        }
        try {
            crypto.SWCSM_GenerateECCKeyPair_ECDSA(uiKeyNumber, this.ecCrefCurveParam);
        }
        catch (CryptoException e) {
            System.out.println("\u4ea7\u751f\u5185\u90e8\u5bc6\u94a5\u5931\u8d25");
            e.printStackTrace();
        }
        int uiISKIndex = uiKeyNumber;
        int uiAlgID = 131328;
        byte[] pucData = new byte[32];
        this.random.nextBytes(pucData);
        System.out.println("Plan:\n" + BytesUtil.bytes2hex(pucData));
        ECCSignature eccSignature = null;
        try {
            eccSignature = crypto.SDF_InternalSign_ECDSA_Ex(uiISKIndex, uiAlgID, pucData, pucData.length);
        }
        catch (CryptoException e) {
            System.out.println("\u5185\u90e8\u5bc6\u94a5\u7b7e\u540d");
            e.printStackTrace();
        }
        System.out.println("Signature:\n" + eccSignature.toString());
        boolean flag = false;
        try {
            flag = crypto.SDF_InternalVerify_ECDSA_Ex(uiISKIndex, uiAlgID, pucData, pucData.length, eccSignature);
        }
        catch (CryptoException e) {
            System.out.println("\u5185\u90e8\u5bc6\u94a5\u9a8c\u8bc1\u7b7e\u540d");
            e.printStackTrace();
        }
        System.out.println("Flab:\n" + flag);
    }

    private void test_External() throws IOException {
        try {
            crypto.SDF_InitECC_Secp256k1();
        }
        catch (CryptoException e) {
            System.out.println("\u521d\u59cb\u5316\u5931\u8d25");
            e.printStackTrace();
        }
        int uiAlgID = 131328;
        int uiKeyBits = 256;
        ECCrefKeyPair ecCrefKeyPair = null;
        try {
            ecCrefKeyPair = crypto.SDF_GenerateKeyPair_ECDSA(uiAlgID, uiKeyBits, this.ecCrefCurveParam);
        }
        catch (CryptoException e) {
            System.out.println("\u4ea7\u751f\u5916\u90e8\u5bc6\u94a5\u5931\u8d25");
            e.printStackTrace();
        }
        System.out.println("ECCrefKeyPair:\n" + ecCrefKeyPair.toString());
        byte[] pucData = new byte[32];
        this.random.nextBytes(pucData);
        System.out.println("Plan:\n" + BytesUtil.bytes2hex(pucData));
        ECCSignature eccSignature = null;
        try {
            eccSignature = crypto.SDF_ExternalSign_ECDSA(uiAlgID, ecCrefKeyPair.getPrivateKey(), pucData, pucData.length);
        }
        catch (CryptoException e) {
            System.out.println("\u5916\u90e8\u5bc6\u94a5\u7b7e\u540d");
            e.printStackTrace();
        }
        System.out.println("Signature:\n" + eccSignature.toString());
        boolean flag = false;
        try {
            flag = crypto.SDF_ExternalVerify_ECDSA(uiAlgID, ecCrefKeyPair.getPublicKey(), pucData, pucData.length, eccSignature);
        }
        catch (CryptoException e) {
            System.out.println("\u5916\u90e8\u5bc6\u94a5\u9a8c\u8bc1\u7b7e\u540d");
            e.printStackTrace();
        }
        System.out.println("Flab:\n" + flag);
    }

    public static void main(String[] args) throws Exception {
        System.out.println(BytesUtil.bytes2hex(null));
        ChanghongTest changhongTest = new ChanghongTest();
        while (true) {
            System.out.println("++++++++++++++++++++++++++++++++++Crypto\u529f\u80fd\u6d4b\u8bd5++++++++++++++++++++++++++++++++");
            System.out.println("1:\u5185\u90e8");
            System.out.println("2:\u5916\u90e8");
            System.out.println("0\uff1a\u9000\u51fa");
            System.out.println("+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++");
            System.out.print("\u9009\u62e9\u6d4b\u8bd5\uff1a");
            String str = new BufferedReader(new InputStreamReader(System.in, "utf-8")).readLine();
            int choice = Integer.parseInt(str);
            switch (choice) {
                case 1: {
                    changhongTest.test_Internal();
                    break;
                }
                case 2: {
                    changhongTest.test_External();
                }
            }
        }
    }
}

