/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.devicev4.gb.struct.key.ed;

import com.sansec.devicev4.api.CryptoException;
import com.sansec.devicev4.gb.struct.key.IKeyPair;
import com.sansec.devicev4.util.BytesUtil;
import com.sun.jna.Structure;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public class EdDSArefPrivateKey
extends Structure
implements IKeyPair {
    public int bits;
    public int curvetype;
    public byte[] k = new byte[80];

    public EdDSArefPrivateKey() {
    }

    public EdDSArefPrivateKey(int bits, int curvetype, byte[] k) {
        this.bits = bits;
        this.curvetype = curvetype;
        if (k.length > 80) {
            System.arraycopy(k, k.length - 80, this.k, 0, this.k.length);
        } else {
            System.arraycopy(k, 0, this.k, this.k.length - k.length, k.length);
        }
    }

    public int getBits() {
        return this.bits;
    }

    public int getCurvetype() {
        return this.curvetype;
    }

    public void setCurvetype(int curvetype) {
        this.curvetype = curvetype;
    }

    public byte[] getK() {
        return this.k;
    }

    @Override
    public void decode(byte[] privateKey) throws CryptoException {
        this.bits = BytesUtil.bytes2int(privateKey);
        int pos = 4;
        byte[] tmpBuffer = new byte[4];
        System.arraycopy(privateKey, pos, tmpBuffer, 0, tmpBuffer.length);
        this.curvetype = BytesUtil.bytes2int(tmpBuffer);
        System.arraycopy(privateKey, pos += tmpBuffer.length, this.k, 0, 80);
        if ((pos += this.k.length) != privateKey.length) {
            throw new CryptoException("inputData length != EdDSAPrivateKey length");
        }
    }

    @Override
    public byte[] encode() throws CryptoException {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        try {
            buf.write(BytesUtil.int2bytes(this.bits));
            buf.write(BytesUtil.int2bytes(this.curvetype));
            buf.write(this.k);
        }
        catch (IOException e) {
            throw new CryptoException("EdDSArefPrivateKey encode error.", e);
        }
        return buf.toByteArray();
    }

    @Override
    public int size() {
        return 88;
    }

    @Override
    public String toString() {
        return "EdDSArefPrivateKey{bits=" + this.bits + ", curvetype=" + Integer.toHexString(this.curvetype) + ", k=" + BytesUtil.bytes2hex(this.k) + '}';
    }

    protected List getFieldOrder() {
        return Arrays.asList("bits", "curvetype", "k");
    }

    public static class ByValue
    extends EdDSArefPrivateKey
    implements Structure.ByValue {
    }

    public static class ByReference
    extends EdDSArefPrivateKey
    implements Structure.ByReference {
    }
}

