/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.devicev4.gb.struct.key.sm2;

import com.sansec.devicev4.api.CryptoException;
import com.sansec.devicev4.gb.struct.key.IKeyPair;
import com.sansec.devicev4.util.BytesUtil;
import com.sun.jna.Structure;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public class SM2refPrivateKey
extends Structure
implements IKeyPair {
    public int bits;
    public byte[] D = new byte[32];

    public SM2refPrivateKey() {
    }

    public SM2refPrivateKey(byte[] D) {
        this.bits = 256;
        this.D = D;
    }

    public int getBits() {
        return this.bits;
    }

    public byte[] getD() {
        return this.D;
    }

    @Override
    public void decode(byte[] privateKey) throws CryptoException {
        this.bits = BytesUtil.bytes2int(privateKey);
        int pos = 4;
        System.arraycopy(privateKey, pos, this.D, 0, 32);
        if ((pos += this.D.length) != privateKey.length) {
            throw new CryptoException("inputData length != SM2PrivateKey length");
        }
    }

    @Override
    public byte[] encode() throws CryptoException {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        try {
            buf.write(BytesUtil.int2bytes(this.bits));
            buf.write(this.D);
        }
        catch (IOException e) {
            throw new CryptoException("SM2refPrivateKey encode error.", e);
        }
        return buf.toByteArray();
    }

    @Override
    public int size() {
        return 36;
    }

    public static int sizeof() {
        return 36;
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer();
        String nl = System.getProperty("line.separator");
        buf.append("bits: ").append(this.bits).append(nl);
        buf.append("   D: ").append(BytesUtil.bytes2hex(this.D)).append(nl);
        return buf.toString();
    }

    protected List getFieldOrder() {
        return Arrays.asList("bits", "D");
    }

    public static class ByValue
    extends SM2refPrivateKey
    implements Structure.ByValue {
    }

    public static class ByReference
    extends SM2refPrivateKey
    implements Structure.ByReference {
    }
}

