/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.devicev4.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;

public class JIniFile
extends ArrayList {
    public JIniFile(InputStream inputStream) {
        this.clear();
        try {
            String s;
            BufferedReader inbuf = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            while ((s = inbuf.readLine()) != null) {
                this.add(s);
            }
            inbuf.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public ArrayList ReadSections() {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < this.size(); ++i) {
            String s = this.get(i).toString();
            if (!s.startsWith("[") || !s.endsWith("]")) continue;
            list.add(s.substring(1, s.length() - 1));
        }
        return list;
    }

    public String ReadString(String Section, String key, String defaultValue) {
        String value = defaultValue;
        if (this.ValuePosition(Section, key) > 0) {
            int strLen = key.length() + 1;
            value = this.get(this.ValuePosition(Section, key)).toString().substring(strLen, this.get(this.ValuePosition(Section, key)).toString().length());
        }
        return value;
    }

    public ArrayList ReadSectionValues(String Section) {
        ArrayList<String> myList = new ArrayList<String>();
        int start = this.SectionPosition(Section) + 1;
        if (this.SectionPosition(Section) > -1) {
            String s;
            for (int i = start; !(i >= this.size() || (s = this.get(i).toString().substring(this.get(i).toString().indexOf("=") + 1, this.get(i).toString().length())).startsWith("[") && s.endsWith("]")); ++i) {
                myList.add(s);
            }
        }
        return myList;
    }

    public int ReadInteger(String Section, String key, int defaultValue) {
        int value = defaultValue;
        if (this.ValuePosition(Section, key) > 0) {
            int strLen = key.length() + 1;
            value = Integer.parseInt(this.get(this.ValuePosition(Section, key)).toString().substring(strLen, this.get(this.ValuePosition(Section, key)).toString().length()));
        }
        return value;
    }

    public Float ReadFloat(String Section, String key, Float defaultValue) {
        Float value = new Float(0.0f);
        value = defaultValue;
        if (this.ValuePosition(Section, key) > 0) {
            int strLen = key.length() + 1;
            value = Float.valueOf(this.get(this.ValuePosition(Section, key)).toString().substring(strLen, this.get(this.ValuePosition(Section, key)).toString().length()));
        }
        return value;
    }

    public boolean ReadBool(String Section, String key, boolean defaultValue) {
        boolean value = defaultValue;
        if (this.ValuePosition(Section, key) > 0) {
            int strLen = key.length() + 1;
            value = Boolean.getBoolean(this.get(this.ValuePosition(Section, key)).toString().substring(strLen, this.get(this.ValuePosition(Section, key)).toString().length()));
        }
        return value;
    }

    private int SectionPosition(String Section) {
        int pos = -1;
        for (int i = 0; i < this.size(); ++i) {
            String s = this.get(i).toString();
            if (!s.equals("[" + Section + "]")) continue;
            pos = i;
            break;
        }
        return pos;
    }

    public boolean SectionExist(String Section) {
        boolean val = false;
        for (int i = 0; i < this.size(); ++i) {
            String s = this.get(i).toString();
            if (!s.equals("[" + Section + "]")) continue;
            val = true;
            break;
        }
        return val;
    }

    public void EraseSection(String Section) {
        int start = this.SectionPosition(Section) + 1;
        if (this.SectionPosition(Section) > -1) {
            String s;
            for (int i = start; !(i >= this.size() || (s = this.get(i).toString()).startsWith("[") && s.endsWith("]")); ++i) {
                this.remove(i);
                --i;
            }
            this.remove(this.SectionPosition(Section));
        }
    }

    public ArrayList ReadSection(String Section) {
        ArrayList<String> myList = new ArrayList<String>();
        int start = this.SectionPosition(Section) + 1;
        if (this.SectionPosition(Section) > -1) {
            String s;
            for (int i = start; !(i >= this.size() || (s = this.get(i).toString()).startsWith("[") && s.endsWith("]")); ++i) {
                myList.add(s.substring(0, s.indexOf("=")));
            }
        }
        return myList;
    }

    public boolean ValueExist(String Section, String key) {
        int start = this.SectionPosition(Section);
        boolean val = false;
        int strLen = key.length() + 1;
        for (int i = start + 1; i < this.size(); ++i) {
            String s = this.get(i).toString();
            if (s.startsWith(key + "=")) {
                val = true;
                break;
            }
            if (s.startsWith("[") && s.endsWith("]")) break;
        }
        return val;
    }

    private int ValuePosition(String Section, String key) {
        int start = this.SectionPosition(Section);
        int pos = -1;
        int strLen = key.length() + 1;
        for (int i = start + 1; i < this.size(); ++i) {
            String s = this.get(i).toString();
            if (s.startsWith(key + "=")) {
                pos = i;
                break;
            }
            if (s.startsWith("[") && s.endsWith("]")) break;
        }
        return pos;
    }

    public void DeleteKey(String Section, String key) {
        if (this.ValuePosition(Section, key) > 0) {
            this.remove(this.ValuePosition(Section, key));
        }
    }

    public void WriteString(String Section, String key, String value) {
        String s = key + "=" + value;
        this.addToList(Section, key, s);
    }

    public void WriteBool(String Section, String key, boolean value) {
        String s = key + "=" + Boolean.toString(value);
        this.addToList(Section, key, s);
    }

    public void WriteFloat(String Section, String key, float value) {
        String s = key + "=" + Float.toString(value);
        this.addToList(Section, key, s);
    }

    public void WriteInteger(String Section, String key, int value) {
        String s = key + "=" + Integer.toString(value);
        this.addToList(Section, key, s);
    }

    private void addToList(String Section, String key, String value) {
        if (this.SectionExist(Section)) {
            if (this.ValueExist(Section, key)) {
                int pos = this.ValuePosition(Section, key);
                this.remove(pos);
                this.add(pos, value);
            } else {
                this.add(this.SectionPosition(Section) + 1, value);
            }
        } else {
            this.add("[" + Section + "]");
            this.add(value);
        }
    }
}

