/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.jwt.signers;

import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.digest.HMac;
import cn.hutool.jwt.signers.JWTSigner;
import java.nio.charset.Charset;
import java.security.Key;

public class HMacJWTSigner
implements JWTSigner {
    private Charset charset = CharsetUtil.CHARSET_UTF_8;
    private final HMac hMac;

    public HMacJWTSigner(String algorithm, byte[] key) {
        this.hMac = new HMac(algorithm, key);
    }

    public HMacJWTSigner(String algorithm, Key key) {
        this.hMac = new HMac(algorithm, key);
    }

    public HMacJWTSigner setCharset(Charset charset) {
        this.charset = charset;
        return this;
    }

    @Override
    public String sign(String headerBase64, String payloadBase64) {
        return this.hMac.digestBase64(StrUtil.format("{}.{}", headerBase64, payloadBase64), this.charset, true);
    }

    @Override
    public boolean verify(String headerBase64, String payloadBase64, String signBase64) {
        String sign = this.sign(headerBase64, payloadBase64);
        return this.hMac.verify(StrUtil.bytes((CharSequence)sign, this.charset), StrUtil.bytes((CharSequence)signBase64, this.charset));
    }

    @Override
    public String getAlgorithm() {
        return this.hMac.getAlgorithm();
    }
}

