/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.custom.shuiyou.incomeTax;

import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.rabbitmq.guava.Lists;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.custom.shuiyou.incomeTax.AbstractTaxDirectDeductionExFacadeControllerBean;
import com.kingdee.eas.custom.shuiyou.task.TaskCatalogEnum;
import com.kingdee.eas.custom.shuiyou.uitls.ISYUtilsFacade;
import com.kingdee.eas.custom.shuiyou.uitls.SYUtilsFacadeFactory;
import com.kingdee.eas.custom.shuiyou.vo.SixTConfirmInfo;
import com.kingdee.eas.custom.shuiyou.vo.SixTPersonInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.shr.compensation.app.tax.TaxUnitCollection;
import com.kingdee.shr.compensation.app.tax.TaxUnitFactory;
import com.kingdee.shr.compensation.app.tax.TaxUnitInfo;
import com.kingdee.shr.compensation.app.taxCal.TaxDirectDeductionCollection;
import com.kingdee.shr.compensation.app.taxCal.TaxDirectDeductionFactory;
import com.kingdee.shr.compensation.app.taxCal.TaxDirectDeductionInfo;
import com.kingdee.shr.compensation.app.taxCal.TaxUnitDeductionCollection;
import com.kingdee.shr.compensation.app.taxCal.TaxUnitDeductionFactory;
import com.kingdee.shr.compensation.app.taxCal.TaxUnitDeductionInfo;
import com.kingdee.shr.compensation.util.Base64Utils;
import com.kingdee.shr.compensation.util.CmpDateUtil;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import com.kingdee.shr.compensation.util.TaxReportUtil;
import com.kingdee.shr.compensation.util.lock.CmpDistributedLockUtils;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class TaxDirectDeductionExFacadeControllerBean
extends AbstractTaxDirectDeductionExFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.custom.shuiyou.incomeTax.TaxDirectDeductionExFacadeControllerBean");

    protected Map<String, List<TaxDirectDeductionInfo>> groupByTaxUnit(TaxDirectDeductionCollection collection) {
        HashMap<String, List<TaxDirectDeductionInfo>> map = new HashMap<String, List<TaxDirectDeductionInfo>>();
        for (int i = 0; i < collection.size(); ++i) {
            TaxDirectDeductionInfo info = collection.get(i);
            String taxUnitDeductionId = info.getTaxUnitDeduction().getId().toString();
            ArrayList<TaxDirectDeductionInfo> list = (ArrayList<TaxDirectDeductionInfo>)map.get(taxUnitDeductionId);
            if (null == list) {
                list = new ArrayList<TaxDirectDeductionInfo>();
            }
            list.add(info);
            map.put(taxUnitDeductionId, list);
        }
        return map;
    }

    protected Map<String, String> getAcceptIdMap(Context ctx, Map<String, List<TaxDirectDeductionInfo>> groups) throws BOSException {
        try {
            String sql = "select t3.fAccept_id acceptId, t1.fid fid from t_hr_sTaxUnitDeduction t1, T_HR_STaskIncomeTaxRelation t2, t_hr_sTaxCalTask t3 where t1.fid = t2.fBizId and t2.fTaskId = t3.fid and t1.fid in (" + CmpStrUtil.convertSetToSqlString(groups.keySet()) + ")";
            HashMap<String, String> acceptIdMap = new HashMap<String, String>();
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                String key = rs.getString("fid");
                String acceptId = rs.getString("acceptId");
                acceptIdMap.put(key, acceptId);
            }
            return acceptIdMap;
        }
        catch (Exception var8) {
            logger.error((Object)"getAcceptIdMap error: ", (Throwable)var8);
            throw new BOSException(var8.getMessage());
        }
    }

    @Override
    protected List _confirm(Context ctx, Map paramMap) throws BOSException {
        super._confirm(ctx, paramMap);
        List ids = (List)paramMap.get("ids");
        String oql = "select id, taxUnitDeduction.id, taxUnitDeduction.taxUnit.taxNumber,taxUnitDeduction.taxUnit.name, taxUnitDeduction.taxUnit.id, taxUnitDeduction.taxUnit.areaCode, taxUnitDeduction.taxUnit.regNumber,taxUnitDeduction.year, taxUnitDeduction.taxUnit.declPassword, taxUnitDeduction.taxUnit.realPassword, taxUnitDeduction.taxUnit.isAutoDeduct, isDecdut, taxPersonRecordEntry.bill.cardType, taxPersonRecordEntry.bill.cardNumber,taxPersonRecordEntry.bill.reportName,taxPersonRecordEntry.bill.nationality.name where id in " + CmpStrUtil.concatList((List)ids);
        TaxDirectDeductionCollection collection = TaxDirectDeductionFactory.getLocalInstance((Context)ctx).getTaxDirectDeductionCollection(oql);
        logger.error((Object)collection.toString());
        if (null != collection && collection.size() != 0) {
            ArrayList<ObjectUuidPK> arrayList = new ArrayList<ObjectUuidPK>();
            Map<String, List<TaxDirectDeductionInfo>> groups = this.groupByTaxUnit(collection);
            Map<String, String> acceptIdMap = this.getAcceptIdMap(ctx, groups);
            ArrayList<Object[]> params = new ArrayList<Object[]>();
            for (Map.Entry<String, List<TaxDirectDeductionInfo>> entry : groups.entrySet()) {
                TaxDirectDeductionInfo deductionInfo = entry.getValue().get(0);
                TaxUnitDeductionInfo taxUnitDeductionInfo = deductionInfo.getTaxUnitDeduction();
                TaxUnitInfo taxUnitInfo = taxUnitDeductionInfo.getTaxUnit();
                StringBuilder confirmIds = new StringBuilder();
                SixTConfirmInfo sixTConfirmInfo = new SixTConfirmInfo();
                sixTConfirmInfo.setBizNo(deductionInfo.getId().toString());
                sixTConfirmInfo.setQymc(taxUnitInfo.getName());
                sixTConfirmInfo.setMmlx(null);
                sixTConfirmInfo.setSmzh(null);
                sixTConfirmInfo.setSmmm(null);
                sixTConfirmInfo.setJmsmmm(null);
                sixTConfirmInfo.setDjxhid(taxUnitInfo.getRegNumber());
                sixTConfirmInfo.setNsrsbh(taxUnitInfo.getTaxNumber());
                sixTConfirmInfo.setAreaid(taxUnitInfo.getAreaCode());
                sixTConfirmInfo.setBmbh(null);
                sixTConfirmInfo.setBmmc(null);
                sixTConfirmInfo.setSbmm(Base64Utils.decode((String)taxUnitInfo.getDeclPassword()));
                sixTConfirmInfo.setJmsbmm(null);
                sixTConfirmInfo.setSkssnd(String.valueOf(taxUnitDeductionInfo.getYear()));
                sixTConfirmInfo.setAcceptId(acceptIdMap.get(taxUnitDeductionInfo.getId().toString()));
                sixTConfirmInfo.setTAXUNITID(taxUnitInfo.getId().toString());
                int lastYear = CmpDateUtil.getYear((Date)new Date());
                String period = lastYear + "01";
                sixTConfirmInfo.setSdyf(period);
                HashMap<String, Object> map = new HashMap<String, Object>();
                ArrayList kczglb = Lists.newArrayList();
                sixTConfirmInfo.setKczglb(kczglb);
                for (TaxDirectDeductionInfo taxDirectDeductionInfo : entry.getValue()) {
                    SixTPersonInfo sixTPersonInfo = new SixTPersonInfo();
                    kczglb.add(sixTPersonInfo);
                    sixTPersonInfo.setXm(taxDirectDeductionInfo.getTaxPersonRecordEntry().getBill().getReportName());
                    sixTPersonInfo.setZzlx(taxDirectDeductionInfo.getTaxPersonRecordEntry().getBill().getCardType().getAlias());
                    sixTPersonInfo.setZzhm(taxDirectDeductionInfo.getTaxPersonRecordEntry().getBill().getCardNumber());
                    sixTPersonInfo.setGj(taxDirectDeductionInfo.getTaxPersonRecordEntry().getBill().getNationality().getName());
                    sixTPersonInfo.setKcbs(taxDirectDeductionInfo.isIsDecdut() ? "\u662f" : "\u5426");
                    Object[] param = new Object[]{40, taxDirectDeductionInfo.getId().toString()};
                    params.add(param);
                    if (confirmIds.length() > 0) {
                        confirmIds.append(",");
                    }
                    confirmIds.append(taxDirectDeductionInfo.getId().toString());
                }
                map.put("ids", confirmIds.toString());
                map.put("qrgjrylb", kczglb);
                ISYUtilsFacade facade = SYUtilsFacadeFactory.getLocalInstance(ctx);
                String sixTConfirmJSON = JSONUtil.toJsonStr((Object)sixTConfirmInfo);
                logger.error((Object)sixTConfirmJSON);
                String taskId = facade.addTask("getPreDeductConfirm", sixTConfirmJSON, TaskCatalogEnum.COLLECTION_CONFIRM, null);
                String updateSQL = "update T_HR_STaxDirectDeduction set FSate = ?,FTASKID='" + taskId + "' where fid = ?";
                DbUtil.executeBatch((Context)ctx, (String)updateSQL, params);
                arrayList.add(new ObjectUuidPK(taskId));
            }
            return arrayList;
        }
        throw new BOSException("6\u4e07\u76f4\u63a5\u6263\u9664\u4eba\u5458\u786e\u8ba4\uff0c\u672a\u83b7\u53d6\u5230\u5bf9\u5e94\u7684\u4eba\u5458\u6570\u636e\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u68c0\u67e5\u6570\u636e\u662f\u5426\u88ab\u5220\u9664");
    }

    @Override
    protected void _saveConfirm(Context ctx, String taskId, String result) throws BOSException {
        super._saveConfirm(ctx, taskId, result);
    }

    @Override
    protected List _staffCollection(Context ctx, Map paramMap) throws BOSException {
        super._staffCollection(ctx, paramMap);
        if (null != paramMap && null != paramMap.get("taxUnitIds") && null != paramMap.get("period")) {
            String taxUnitIds = (String)paramMap.get("taxUnitIds");
            ArrayList<ObjectUuidPK> arrayList = new ArrayList<ObjectUuidPK>();
            String oql = "select id,name,number,taxNumber,areaCode,regNumber,declPassword,realPassword,isAutoDeduct where id in " + CmpStrUtil.buildInSql((String)taxUnitIds);
            TaxUnitCollection taxUnitCollection = TaxUnitFactory.getLocalInstance((Context)ctx).getTaxUnitCollection(oql);
            ArrayList params = new ArrayList();
            ISYUtilsFacade facade = SYUtilsFacadeFactory.getLocalInstance(ctx);
            Map config = facade.getConfig();
            for (int i = 0; i < taxUnitCollection.size(); ++i) {
                TaxUnitInfo taxUnitInfo = taxUnitCollection.get(i);
                String yearMonth = TaxReportUtil.getCurrentYearMonth((String)((String)paramMap.get("period")));
                int year = Integer.parseInt(yearMonth.substring(0, 4));
                SixTConfirmInfo sixTConfirmInfo = new SixTConfirmInfo();
                sixTConfirmInfo.setBizNo(System.currentTimeMillis() + "");
                sixTConfirmInfo.setQymc(taxUnitInfo.getName());
                sixTConfirmInfo.setMmlx(null);
                sixTConfirmInfo.setSmzh(null);
                sixTConfirmInfo.setSmmm(null);
                sixTConfirmInfo.setJmsmmm(null);
                sixTConfirmInfo.setDjxhid(taxUnitInfo.getRegNumber());
                sixTConfirmInfo.setNsrsbh(taxUnitInfo.getTaxNumber());
                sixTConfirmInfo.setAreaid(taxUnitInfo.getAreaCode());
                sixTConfirmInfo.setBmbh(null);
                sixTConfirmInfo.setBmmc(null);
                sixTConfirmInfo.setSbmm(Base64Utils.decode((String)taxUnitInfo.getDeclPassword()));
                sixTConfirmInfo.setJmsbmm(null);
                sixTConfirmInfo.setSkssnd(String.valueOf(year));
                taxUnitInfo.put("year", (Object)year);
                sixTConfirmInfo.setTAXUNITID(taxUnitInfo.getId().toString());
                String result = facade.addTask("queryPreDeductService", JSONUtil.toJsonStr((Object)sixTConfirmInfo), TaskCatalogEnum.QUERYPREDEDUCTSERVICE, null);
                arrayList.add(new ObjectUuidPK(result));
            }
            return arrayList;
        }
        throw new BOSException("6\u4e07\u76f4\u63a5\u6263\u9664\u4eba\u5458\u5f52\u96c6\u63a5\u53e3\u670d\u52a1\u53c2\u6570\u7f3a\u5931\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570");
    }

    protected String saveTaxUnitDeduction(Context ctx, TaxUnitInfo taxUnit, int year) throws BOSException {
        IObjectPK pk;
        try {
            String taxUnitId = taxUnit.getId().toString();
            String deleteSQL = "delete from t_hr_sTaxDirectDeduction where fTaxUnitDeductionId in (select fid from T_HR_STaxUnitDeduction where fTaxUnitId = '" + taxUnitId + "' and fYear = " + year + ")";
            DbUtil.execute((Context)ctx, (String)deleteSQL);
            deleteSQL = "delete from T_HR_STaxUnitDeduction where fTaxUnitId = '" + taxUnitId + "' and fYear = " + year;
            DbUtil.execute((Context)ctx, (String)deleteSQL);
            TaxUnitDeductionInfo info = new TaxUnitDeductionInfo();
            info.setTaxUnit(taxUnit);
            info.setYear(year);
            info.setIsCollection(true);
            pk = TaxUnitDeductionFactory.getLocalInstance((Context)ctx).save((CoreBaseInfo)info);
        }
        catch (EASBizException var8) {
            logger.error((Object)"_saveStaffCollection error: ", (Throwable)var8);
            throw new BOSException(var8.getMessage());
        }
        return pk.toString();
    }

    protected String getTaxUnitDeduction(Context ctx, TaxUnitInfo taxUnit, int year) throws BOSException {
        String oql = "select id where taxUnit.id = '" + taxUnit.getId().toString() + "' and year = " + year;
        TaxUnitDeductionCollection collection = TaxUnitDeductionFactory.getLocalInstance((Context)ctx).getTaxUnitDeductionCollection(oql);
        if (null != collection && !collection.isEmpty()) {
            return collection.get(0).getId().toString();
        }
        throw new BOSException("\u6ca1\u6709\u627e\u5230\u7eb3\u7a0e\u5355\u4f4d\u5f52\u96c6\u4fe1\u606f");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected synchronized void _saveStaffCollection(Context ctx, TaxUnitInfo taxUnit, String result) throws BOSException {
        List kczglbList;
        super._saveStaffCollection(ctx, taxUnit, result);
        JSONObject object = JSONUtil.parseObj((String)result);
        JSONObject head = object.getJSONObject((Object)"head");
        Map headMap = (Map)object.get((Object)"head");
        Map bodyMap = (Map)object.get((Object)"body");
        if (!"00000000".equals(head.getStr((Object)"code"))) throw new BOSException(result);
        System.out.println("_saveStaffCollection:start");
        List list = kczglbList = bodyMap.containsKey("kczglb") ? (List)bodyMap.get("kczglb") : null;
        if (null == kczglbList || kczglbList.isEmpty()) throw new BOSException(result);
        String prefix = "person_collect_";
        String resource = taxUnit.getId().toString();
        boolean flag = CmpDistributedLockUtils.tryLock((Context)ctx, (String)prefix, (String)resource);
        if (!flag) return;
        try {
            int year = taxUnit.getInt("year");
            String taxUnitDeductionId = this.getTaxUnitDeduction(ctx, taxUnit, year);
            HashMap<String, Integer> personMap = new HashMap<String, Integer>();
            String userId = HRFilterUtils.getCurrentUserId((Context)ctx);
            for (Map stringObjectMap : kczglbList) {
                personMap.put(stringObjectMap.get("zzhm").toString(), "\u662f".equals(stringObjectMap.get("kcbs")) ? 1 : 0);
            }
            String cardNumbers = CmpStrUtil.converMapToString(personMap);
            String sql = "SELECT e.fid, r.fCardNumber FROM t_hr_sTaxPersonRecordEntry e, t_hr_sTaxPersonRecord r WHERE e.fTaxUnitID = '" + resource + "'  and e.fBillId = r.fid  and r.fCardNumber IN (" + cardNumbers + ")";
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            Timestamp createTime = new Timestamp(System.currentTimeMillis());
            ArrayList<Object[]> paramList = new ArrayList<Object[]>();
            HashMap<String, Integer> personSet = new HashMap<String, Integer>();
            while (rowSet.next()) {
                Object[] param = new Object[10];
                String taxPersonRecordEntryId = rowSet.getString(1);
                param[0] = taxPersonRecordEntryId;
                Integer isDirect = (Integer)personMap.get(rowSet.getString(2));
                param[1] = isDirect;
                param[2] = taxUnitDeductionId;
                param[3] = userId;
                param[4] = createTime;
                param[5] = userId;
                param[6] = createTime;
                param[7] = BOSUuid.create((String)"F831C6DA").toString();
                param[8] = "";
                param[9] = 10;
                personSet.put(taxPersonRecordEntryId, isDirect);
                paramList.add(param);
            }
            System.out.println("_saveStaffCollection:" + paramList);
            String batchSql = "INSERT INTO T_HR_STAXDIRECTDEDUCTION( FTaxPersonRecordEntryId, FISDECDUT, FTAXUNITDEDUCTIONID, FCREATORID, FCREATETIME,  FLASTUPDATEUSERID, FLASTUPDATETIME, FID, FTaskId, fSate)  VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
            DbUtil.executeBatch((Context)ctx, (String)batchSql, paramList);
            sql = "UPDATE t_hr_sTaxPersonRecordEntry SET fIsDirect = ? WHERE fid = ?";
            paramList = new ArrayList();
            for (Map.Entry entry : personSet.entrySet()) {
                Object[] param = new Object[]{entry.getValue(), entry.getKey()};
                paramList.add(param);
            }
            DbUtil.executeBatch((Context)ctx, (String)sql, paramList);
            System.out.println("_saveStaffCollection:" + paramList);
            return;
        }
        catch (Exception var33) {
            logger.error((Object)"_saveStaffCollection error: ", (Throwable)var33);
            return;
        }
        finally {
            CmpDistributedLockUtils.unlock((Context)ctx, (String)prefix, (String)resource);
        }
    }
}

