/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.custom.shuiyou.uitls;

import cn.hutool.core.lang.Snowflake;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSON;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.google.common.collect.Maps;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.custom.shuiyou.RequestStateEnum;
import com.kingdee.eas.custom.shuiyou.RequestTypeEnum;
import com.kingdee.eas.custom.shuiyou.interfacelog.LogInfoFactory;
import com.kingdee.eas.custom.shuiyou.interfacelog.LogInfoInfo;
import com.kingdee.eas.custom.shuiyou.task.ITask;
import com.kingdee.eas.custom.shuiyou.task.TaskCatalogEnum;
import com.kingdee.eas.custom.shuiyou.task.TaskCollection;
import com.kingdee.eas.custom.shuiyou.task.TaskFactory;
import com.kingdee.eas.custom.shuiyou.task.TaskInfo;
import com.kingdee.eas.custom.shuiyou.task.TaskRequestParamFactory;
import com.kingdee.eas.custom.shuiyou.task.TaskRequestParamInfo;
import com.kingdee.eas.custom.shuiyou.task.TaskRequestResultFactory;
import com.kingdee.eas.custom.shuiyou.task.TaskRequestResultInfo;
import com.kingdee.eas.custom.shuiyou.task.TaskStateEnum;
import com.kingdee.eas.custom.shuiyou.uitls.AbstractSYUtilsFacadeControllerBean;
import com.kingdee.eas.custom.shuiyou.uitls.SYUConfigUtil;
import com.kingdee.eas.custom.shuiyou.uitls.SYUCronTaskUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.shr.dydeploy.web.executeSql.ExceptionUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.sql.Timestamp;
import java.util.Base64;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.UUID;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.log4j.Logger;

public class SYUtilsFacadeControllerBean
extends AbstractSYUtilsFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.custom.shuiyou.uitls.SYUtilsFacadeControllerBean");

    @Override
    protected Snowflake _getSnowflake(Context ctx) throws BOSException {
        super._getSnowflake(ctx);
        return SYUCronTaskUtil.getInstance().getSnowflake();
    }

    @Override
    protected String _getBizNo(Context ctx) throws BOSException {
        super._getBizNo(ctx);
        return this._getSnowflake(ctx).nextIdStr();
    }

    @Override
    @Deprecated
    protected String _backTask(Context ctx, String url, String requestId, String osfServiceName, String backParam, TaskCatalogEnum catalog) throws BOSException {
        super._backTask(ctx, url, requestId, osfServiceName, backParam, catalog);
        TaskInfo taskInfo = new TaskInfo();
        try {
            taskInfo.setId(BOSUuid.create((BOSObjectType)taskInfo.getBOSType()));
            taskInfo.setUrl(url);
            taskInfo.setRequestId(requestId);
            TaskRequestParamInfo requestParam = new TaskRequestParamInfo();
            requestParam.setTask(taskInfo);
            requestParam.setParamContent(backParam);
            IObjectPK pkp = TaskRequestParamFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)requestParam);
            requestParam.setId(BOSUuid.read((String)pkp.toString()));
            taskInfo.setRequestParam(requestParam);
            taskInfo.setOsfServiceName(osfServiceName);
            taskInfo.setRequestType(RequestTypeEnum.GET);
            taskInfo.setRequestState(RequestStateEnum.NotStarted);
            taskInfo.setState(TaskStateEnum.STANDBY);
            taskInfo.setCatalog(catalog);
            TaskRequestResultInfo resultInfo = new TaskRequestResultInfo();
            resultInfo.setTask(taskInfo);
            IObjectPK pkr = TaskRequestResultFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)resultInfo);
            resultInfo.setId(BOSUuid.read((String)pkr.toString()));
            taskInfo.setRequestResult(resultInfo);
            taskInfo.setName(catalog.getAlias());
            String number = SYUCronTaskUtil.getInstance().getSnowflake().nextIdStr();
            taskInfo.setNumber(number);
            IObjectPK iObjectPK = TaskFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)taskInfo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return taskInfo.getId().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String _post(Context ctx, String url, String param) throws BOSException {
        super._post(ctx, url, param);
        String result = "";
        LogInfoInfo logInfo = new LogInfoInfo();
        try {
            logInfo.setEntrance(this.getClass().getName());
            Long timestampLong = System.currentTimeMillis();
            UserInfo userInfo = (UserInfo)ctx.get((Object)"UserInfo");
            logInfo.setCreator(userInfo);
            Timestamp timestamp = new Timestamp(timestampLong);
            logInfo.setCreateTime(timestamp);
            logInfo.setLastUpdateTime(timestamp);
            logInfo.setLastUpdateUser(userInfo);
            logInfo.setBizDate(timestamp);
            JSONObject paramMap = JSONUtil.parseObj((String)param);
            Map propt = this._getConfig(ctx);
            HashMap signaMap = Maps.newHashMap();
            if (StrUtil.isBlank((CharSequence)paramMap.getStr((Object)"timestamp"))) {
                signaMap.put("timestamp", String.valueOf(timestampLong));
            } else {
                signaMap.put("timestamp", paramMap.getStr((Object)"timestamp"));
            }
            if (StrUtil.isBlank((CharSequence)paramMap.getStr((Object)"xReqNonce"))) {
                String xReqNonce = UUID.randomUUID().toString().replace("-", "");
                signaMap.put("xReqNonce", xReqNonce);
            } else {
                signaMap.put("xReqNonce", paramMap.getStr((Object)"xReqNonce"));
            }
            param = JSONUtil.toJsonStr((JSON)paramMap);
            String signature = this._getSignature(ctx, propt, signaMap);
            HashMap headers = new HashMap();
            headers.put("appKey", propt.get("appKey"));
            headers.put("timestamp", (String)signaMap.get("timestamp"));
            headers.put("version", propt.get("version"));
            headers.put("xReqNonce", (String)signaMap.get("xReqNonce"));
            headers.put("signature", signature);
            OkHttpClient client = new OkHttpClient();
            RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)param);
            Request sYRequest = new Request.Builder().url(url).post(body).headers(Headers.of(headers)).build();
            Response sYResponse = client.newCall(sYRequest).execute();
            if (sYResponse.isSuccessful()) {
                result = sYResponse.body().string();
            } else {
                logInfo.setErrorInfo(sYResponse.message());
            }
            logInfo.setOutParameter(result);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)e);
            logInfo.setOutParameter(ExceptionUtils.getStackTrace((Throwable)e));
        }
        finally {
            logInfo.setInterfaceAddress(url);
            logInfo.setInterfaceName("POST");
            logInfo.setInParameter(param);
            this._log(ctx, logInfo);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String _get(Context ctx, String url, String param) throws BOSException {
        super._get(ctx, url, param);
        String result = "";
        LogInfoInfo logInfo = new LogInfoInfo();
        try {
            logInfo.setEntrance(this.getClass().getName());
            Long timestampLong = System.currentTimeMillis();
            UserInfo userInfo = (UserInfo)ctx.get((Object)"UserInfo");
            logInfo.setCreator(userInfo);
            Timestamp timestamp = new Timestamp(timestampLong);
            logInfo.setCreateTime(timestamp);
            logInfo.setLastUpdateTime(timestamp);
            logInfo.setLastUpdateUser(userInfo);
            logInfo.setBizDate(timestamp);
            JSONObject paramMap = JSONUtil.parseObj((String)param);
            Map propt = this._getConfig(ctx);
            if (StrUtil.isBlank((CharSequence)paramMap.getStr((Object)"timestamp"))) {
                paramMap.set("timestamp", (Object)String.valueOf(timestampLong));
            }
            if (StrUtil.isBlank((CharSequence)paramMap.getStr((Object)"xReqNonce"))) {
                String xReqNonce = UUID.randomUUID().toString().replace("-", "");
                paramMap.set("xReqNonce", (Object)xReqNonce);
            }
            param = JSONUtil.toJsonStr((JSON)paramMap);
            String signature = this._getSignature(ctx, propt, (Map)paramMap);
            HashMap headers = new HashMap();
            headers.put("appKey", propt.get("appKey"));
            headers.put("timestamp", paramMap.getStr((Object)"timestamp"));
            headers.put("version", propt.get("version"));
            headers.put("xReqNonce", paramMap.getStr((Object)"xReqNonce"));
            headers.put("signature", signature);
            OkHttpClient client = new OkHttpClient();
            HttpUrl.Builder urlBuilder = HttpUrl.parse((String)url).newBuilder();
            for (Map.Entry entry : paramMap.entrySet()) {
                Optional op = Optional.ofNullable(entry.getValue());
                urlBuilder.addQueryParameter((String)entry.getKey(), op.orElse("").toString());
            }
            url = urlBuilder.build().toString();
            Request sYRequest = new Request.Builder().url(url).headers(Headers.of(headers)).get().build();
            Response sYResponse = client.newCall(sYRequest).execute();
            if (sYResponse.isSuccessful()) {
                result = sYResponse.body().string();
            } else {
                logInfo.setErrorInfo(sYResponse.message());
            }
        }
        catch (IOException e) {
            logger.error((Object)e);
            logInfo.setErrorInfo(e.getMessage());
        }
        finally {
            logInfo.setInterfaceAddress(url);
            logInfo.setInterfaceName("GET");
            logInfo.setInParameter(param);
            logInfo.setOutParameter(result);
            this._log(ctx, logInfo);
        }
        return result;
    }

    @Override
    protected String _getSignature(Context ctx, Map propt, Map paramMap) throws BOSException {
        String string;
        String string2;
        logger.error((Object)"====\u83b7\u53d6\u7b7e\u540d===\u8fdb\u5165\u5230\u4e86com.kingdee.eas.custom.jiuzhoutong.utils.SYUtils.getSignature=======");
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        String version = (String)propt.get("version");
        String appKey = (String)propt.get("appKey");
        String appSecret = (String)propt.get("appSecret");
        logger.error((Object)"=============\u53c2\u6570\u5217================");
        logger.error((Object)("version\uff1a" + version));
        logger.error((Object)("param\uff1a" + paramMap.toString()));
        logger.error((Object)("appSecret\uff1a" + appSecret));
        logger.error((Object)"==================================");
        treeMap.put("appKey", appKey);
        treeMap.put("appSecret", appSecret);
        treeMap.put("version", version);
        Iterator iterator = paramMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry;
            Map.Entry entry2 = entry = iterator.next();
            treeMap.put((String)entry2.getKey(), StrUtil.toString(entry2.getValue()));
        }
        StringBuilder mergeStr = new StringBuilder();
        for (Map.Entry entry : treeMap.entrySet()) {
            mergeStr.append((String)entry.getValue());
        }
        logger.error((Object)("\u5c06\u4ee5\u4e0akey=value\u5bf9\u7684value\u8fdb\u884c\u5408\u5e76,\u751f\u6210\u4e00\u4e0b\u5b57\u7b26\u4e32mergeStr\uff1a" + mergeStr.toString()));
        Object var9_11 = null;
        try {
            string2 = URLEncoder.encode(mergeStr.toString(), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            throw new RuntimeException("url\u7f16\u7801\u5931\u8d25");
        }
        logger.error((Object)("\u5c06\u751f\u6210\u7684mergeStr\u8fdb\u884cUrl\u7f16\u7801\uff1a" + string2));
        String string3 = "";
        try {
            Mac mac = Mac.getInstance("HmacSHA256");
            SecretKeySpec signingKey = new SecretKeySpec(appSecret.getBytes(), "HmacSHA256");
            mac.init(signingKey);
            byte[] signData = mac.doFinal(string2.getBytes());
            byte[] resultBytes = Base64.getEncoder().encode(signData);
            string = new String(resultBytes, "UTF-8");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("\u5e73\u53f0\u4e0d\u652f\u6301 HmacSHA \u6458\u8981\u65b9\u5f0f");
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException("Speicified access secret is not valid.");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("\u8f6c\u7801\u5931\u8d25");
        }
        logger.error((Object)("\u7528HmacSHA256\u7b97\u6cd5\u5bf9signStr\u8fdb\u884c\u54c8\u5e0c\u8fd0\u7b97\u751f\u6210\u6d88\u606f\u6458\u8981,\u6458\u8981\u7ed3\u679c\u4ee5Base64\u7ed3\u679c\u5f62\u5f0f\u8fd4\u56de\uff0csignStr\u5373\u4e3a\u8bf7\u6c42\u53c2\u6570\u4e2d\u7684signature\u5b57\u6bb5" + string));
        logger.error((Object)"==========================\u9000\u51fa================================");
        return string;
    }

    @Override
    protected String _getSignature(Context ctx, String param) throws BOSException {
        super._getSignature(ctx, param);
        JSONObject paramMap = JSONUtil.parseObj((String)param);
        return this._getSignature(ctx, this._getConfig(ctx), (Map)paramMap);
    }

    @Override
    protected void _initConfig(Context ctx, String filePath) throws BOSException {
        super._initConfig(ctx, filePath);
        SYUConfigUtil.getInstance().initConfig(filePath);
        SYUCronTaskUtil.getInstance().refreshPropt();
    }

    @Override
    protected LogInfoInfo _log(Context ctx, LogInfoInfo logInfo) throws BOSException {
        try {
            super._log(ctx, logInfo);
            IObjectPK pk = LogInfoFactory.getLocalInstance(ctx).save((CoreBaseInfo)logInfo);
            logInfo.setId(BOSUuid.read((String)pk.toString()));
        }
        catch (EASBizException e) {
            logger.error((Object)e);
        }
        return logInfo;
    }

    @Override
    protected Map _getConfig(Context ctx) throws BOSException {
        super._getConfig(ctx);
        Map<String, String> map = SYUConfigUtil.getInstance().getConfig();
        return map;
    }

    @Override
    protected String _addTask(Context ctx, String osfServiceName, String param, TaskCatalogEnum catalog, String taskPreId, String sourceBillId) throws BOSException {
        super._addTask(ctx, osfServiceName, param, catalog, taskPreId, sourceBillId);
        TaskInfo taskInfo = new TaskInfo();
        try {
            if (StrUtil.isNotBlank((CharSequence)taskPreId)) {
                TaskInfo taskPreInfo = new TaskInfo();
                taskPreInfo.setId(BOSUuid.read((String)taskPreId));
                taskInfo.setTaskPre(taskPreInfo);
            }
            taskInfo.setSourceBillId(sourceBillId);
            taskInfo.setId(BOSUuid.create((BOSObjectType)taskInfo.getBOSType()));
            TaskRequestParamInfo requestParam = new TaskRequestParamInfo();
            requestParam.setTask(taskInfo);
            requestParam.setParamContent(param);
            IObjectPK pkp = TaskRequestParamFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)requestParam);
            requestParam.setId(BOSUuid.read((String)pkp.toString()));
            taskInfo.setRequestParam(requestParam);
            taskInfo.setOsfServiceName(osfServiceName);
            taskInfo.setRequestState(RequestStateEnum.NotStarted);
            taskInfo.setState(TaskStateEnum.STANDBY);
            taskInfo.setCatalog(catalog);
            TaskRequestResultInfo resultInfo = new TaskRequestResultInfo();
            resultInfo.setTask(taskInfo);
            IObjectPK pkr = TaskRequestResultFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)resultInfo);
            resultInfo.setId(BOSUuid.read((String)pkr.toString()));
            taskInfo.setRequestResult(resultInfo);
            taskInfo.setName(catalog.getAlias());
            String number = SYUCronTaskUtil.getInstance().getSnowflake().nextIdStr();
            taskInfo.setNumber(number);
            IObjectPK iObjectPK = TaskFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)taskInfo);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return taskInfo.getId().toString();
    }

    @Override
    protected String _addTask(Context ctx, String osfServiceName, String param, TaskCatalogEnum catalog, String taskPreId) throws BOSException {
        super._addTask(ctx, osfServiceName, param, catalog, taskPreId);
        return this._addTask(ctx, osfServiceName, param, catalog, taskPreId, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    protected boolean _delTask(Context ctx, String taskId) throws BOSException {
        super._delTask(ctx, taskId);
        boolean isSe = true;
        try {
            ObjectUuidPK pk = new ObjectUuidPK(taskId);
            ITask iTask = TaskFactory.getLocalInstance(ctx);
            EntityViewInfo viewInfo = new EntityViewInfo();
            SelectorItemCollection sc = new SelectorItemCollection();
            sc.add(new SelectorItemInfo("id"));
            sc.add(new SelectorItemInfo("taskPre.id"));
            viewInfo.setSelector(sc);
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)taskId, CompareType.EQUALS));
            viewInfo.setFilter(filterInfo);
            TaskCollection collection = iTask.getTaskCollection(viewInfo);
            for (int i = 0; i < collection.size(); ++i) {
                TaskInfo taskInfo = collection.get(i);
                Optional<TaskInfo> op = Optional.ofNullable(taskInfo.getTaskPre());
                BOSUuid uuid = op.orElse(new TaskInfo()).getId();
                if (null == uuid) continue;
                FilterInfo delFilterInfo = new FilterInfo();
                delFilterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)uuid.toString(), CompareType.EQUALS));
                iTask.delete(delFilterInfo);
            }
            FilterInfo filterNextInfo = new FilterInfo();
            filterNextInfo.getFilterItems().add(new FilterItemInfo("taskPre.id", (Object)taskId, CompareType.EQUALS));
            iTask.delete(filterNextInfo);
            iTask.delete(filterInfo);
        }
        catch (Exception e) {
            logger.error((Object)e);
            isSe = false;
        }
        return isSe;
    }
}

