/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.devicev4.crypto_hsm.sds.cmd.hsm.socket;

import com.sansec.devicev4.api.CryptoException;
import com.sansec.devicev4.api.UnavailableException;
import com.sansec.devicev4.crypto_hsm.sds.cmd.hsm.socket.HSMPool;
import com.sansec.devicev4.crypto_hsm.sds.cmd.hsm.socket.HSMSession;
import com.sansec.devicev4.crypto_hsm.sds.cmd.hsm.socket.HSMSocket;
import com.sansec.devicev4.crypto_hsm.sds.cmd.hsm.socket.HSMSocketException;
import com.sansec.devicev4.crypto_hsm.sds.cmd.hsm.socket.RepairPool;
import com.sansec.devicev4.crypto_hsm.sds.cmd.hsm.socket.SocketRepairException;
import com.sansec.devicev4.crypto_hsm.sds.cmd.hsm.socket.bean.Request;
import com.sansec.devicev4.crypto_hsm.sds.cmd.hsm.socket.bean.Response;
import com.sansec.devicev4.log.CryptoLogger;
import com.sansec.devicev4.util.BytesUtil;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NetCommunication {
    Logger logger = CryptoLogger.logger;
    private HSMPool pool = HSMPool.getPool();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Response socketCommunication(Request request) throws CryptoException, UnavailableException {
        this.logger.fine("-> socketCommunication()...");
        this.logger.fine("=> request=" + request.toString());
        Response response = null;
        HSMSession session = this.pool.getSession();
        int size = session.getSize();
        try {
            for (int i = 0; i < size; ++i) {
                HSMSocket hsmSocket = session.getHsmSocket();
                try {
                    if (hsmSocket.getStatus() != 0) {
                        if (request.forSync()) {
                            throw new CryptoException("This is sync request, but hsm is not ok, so throw exception");
                        }
                        if (i != size - 1) continue;
                        int newSize = session.getSize();
                        if (newSize < size) {
                            i = 0;
                            continue;
                        }
                        this.logger.severe("error: all Socket( in session ) can not connected failed! session size=" + size);
                        throw new UnavailableException("all hsm can not connected ");
                    }
                    try {
                        response = this.primaryService(hsmSocket, request, false);
                    }
                    catch (Exception e) {
                        if (e instanceof SocketRepairException) {
                            hsmSocket.setStatus(1);
                            this.logger.severe("info: new Thread.RepairPool(hsmSocket)).start(), ip=" + hsmSocket.getIp() + " status=" + hsmSocket.getStatus());
                            RepairPool rt = new RepairPool(hsmSocket);
                            Thread t1 = new Thread(rt);
                            t1.setDaemon(true);
                            t1.setName("RepairPool");
                            t1.start();
                        } else if (e instanceof CryptoException) {
                            throw (CryptoException)e;
                        }
                        if (request.forSync()) {
                            throw new CryptoException("This is sync request, but hsm is not ok, so throw exception", e);
                        }
                        if (i != size - 1) {
                            this.logger.severe("select another hsm,continue");
                            session.releaseHsmSocket(hsmSocket);
                            continue;
                        }
                        int newSize = session.getSize();
                        if (newSize < size) {
                            i = 0;
                            session.releaseHsmSocket(hsmSocket);
                            continue;
                        }
                        this.logger.severe("error: all Socket( in session ) can not connected failed!... session size=" + size);
                        throw new UnavailableException("all hsm can not connected ", e);
                    }
                    if (request.forSync()) continue;
                    break;
                    {
                        catch (Exception e) {
                            e.printStackTrace();
                            throw new CryptoException(e);
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    session.releaseHsmSocket(hsmSocket);
                }
            }
        }
        finally {
            this.pool.release(session);
        }
        this.logger.fine("<- socketCommunication() end");
        return response;
    }

    private Response primaryService(HSMSocket hsmSocket, Request request, boolean repair) throws CryptoException, SocketRepairException, HSMSocketException {
        this.logger.fine("-> primaryService()...");
        this.logger.info("=> hsmSocket=" + hsmSocket);
        this.logger.fine("=> request=" + BytesUtil.bytes2hex(request.encode()));
        this.logger.fine("=> repair=" + repair);
        if (repair) {
            try {
                if (!request.forSync()) {
                    hsmSocket.repair(Thread.currentThread().getId());
                } else {
                    hsmSocket.repair(Thread.currentThread().getId());
                }
            }
            catch (HSMSocketException ex) {
                this.logger.log(Level.SEVERE, hsmSocket + " repair socket failed: ", ex);
                throw new SocketRepairException(hsmSocket + "repair socket failed:" + ex.getMessage(), ex);
            }
        }
        Response response = null;
        try {
            response = hsmSocket.sendAndReceive(request.encode());
        }
        catch (HSMSocketException ex) {
            if (!repair) {
                this.logger.log(Level.WARNING, hsmSocket + " first sendAndReceive failded: ", ex);
                return this.primaryService(hsmSocket, request, true);
            }
            this.logger.log(Level.SEVERE, hsmSocket + " second sendAndReceive failded: ", ex);
            throw new HSMSocketException(hsmSocket + " sendAndReceive failded", ex);
        }
        if (response.getErrorCode() != 0) {
            this.logger.severe(hsmSocket + " sendAndReceive return: " + response.getErrorInfo());
            throw new CryptoException(hsmSocket + " return( " + response.getErrorInfo() + " )");
        }
        if (response.getTaskSN() != request.getnTaskSN()) {
            if (!repair) {
                this.logger.warning(hsmSocket + " first sendAndReceive response.getTaskSN() [" + response.getTaskSN() + "] != request.getnTaskSN() [ " + request.getnTaskSN() + "] ");
                return this.primaryService(hsmSocket, request, true);
            }
            this.logger.severe(hsmSocket + " second sendAndReceive response.getTaskSN() [" + response.getTaskSN() + "] != request.getnTaskSN() [ " + request.getnTaskSN() + "] ");
            throw new CryptoException(hsmSocket + " task not equal");
        }
        this.logger.fine("<- primaryService() end");
        return response;
    }
}

