/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.devicev4.crypto_hsm.sds.cmd.hsm.socket;

import com.sansec.devicev4.api.HSMStateListener;
import com.sansec.devicev4.crypto_hsm.sds.cmd.hsm.socket.HSMPool;
import com.sansec.devicev4.crypto_hsm.sds.cmd.hsm.socket.HSMSession;
import com.sansec.devicev4.crypto_hsm.sds.cmd.hsm.socket.HSMSocket;
import com.sansec.devicev4.crypto_hsm.sds.cmd.hsm.socket.RepairExceptionHandler;
import com.sansec.devicev4.log.CryptoLogger;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class RepairPool
implements Runnable {
    private Logger logger = CryptoLogger.logger;
    private static RepairExceptionHandler exceptionHandler = new RepairExceptionHandler();
    private HSMSocket hsmSocket;
    private static List<String> repairHsmIP = new ArrayList<String>();
    static HSMPool pool = HSMPool.getPool();
    static List<HSMSession> allSessions = pool.getAllSessions();

    public RepairPool(HSMSocket hsmSocket) {
        this.hsmSocket = hsmSocket;
    }

    public static List<String> getRepairHsmIP() {
        return repairHsmIP;
    }

    public static synchronized int checkHsmIP(String IP) {
        int i;
        for (i = 0; i < repairHsmIP.size(); ++i) {
            if (!repairHsmIP.get(i).equalsIgnoreCase(IP)) continue;
            return 1;
        }
        repairHsmIP.add(IP);
        for (i = 0; i < allSessions.size(); ++i) {
            HSMSession session = allSessions.get(i);
            int size = session.getSize();
            for (int j = 0; j < size; ++j) {
                HSMSocket hsmSocket2 = null;
                hsmSocket2 = session.getEverySocket();
                if (hsmSocket2 == null || !hsmSocket2.getIp().equals(IP)) continue;
                hsmSocket2.setStatus(1);
            }
        }
        return 0;
    }

    @Override
    public void run() {
        Thread curthread = new Thread(this);
        curthread.setUncaughtExceptionHandler(exceptionHandler);
        this.logger.warning("class RepairPool ->run......first line...... , curthread.getId=" + curthread.getId());
        String ip = this.hsmSocket.getIp();
        if (RepairPool.checkHsmIP(ip) == 1) {
            this.logger.warning(ip + " is already in repairpool.");
            this.logger.warning("class RepairPool -> checkHsmIP(hsmSocket.getIp())==1......return , curthread.getId=" + curthread.getId());
            return;
        }
        this.logger.warning(ip + " is added in repairpool.");
        int stateFlag = 1;
        String stateMsg = "unavailable";
        HSMStateListener listener = pool.getHsmStateListener();
        if (listener != null) {
            listener.changeState(this.hsmSocket.getIp(), stateFlag, stateMsg);
        }
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException e) {
            this.logger.warning("class RepairPool -> Thread.sleep InterruptedException ,IP:" + this.hsmSocket.getIp() + " " + e.getMessage());
        }
        for (int i = 0; i < allSessions.size(); ++i) {
            HSMSession session = allSessions.get(i);
            int size = session.getSize();
            for (int j = 0; j < size; ++j) {
                HSMSocket hsmSocket2 = session.getEverySocket();
                if (hsmSocket2 == null || !hsmSocket2.getIp().equals(this.hsmSocket.getIp())) continue;
                if (hsmSocket2.getStatus() == 1) {
                    while (hsmSocket2.getStatus() == 1) {
                        try {
                            this.logger.warning("class RepairPool -> hsmSocket.repair() run...... , curthread.getId=" + curthread.getId());
                            hsmSocket2.repair(curthread.getId());
                        }
                        catch (Exception e) {
                            this.logger.warning("class RepairPool -> hsmSocket.repair() CryptoException ,IP:" + this.hsmSocket.getIp() + " " + e.getMessage());
                        }
                        if (hsmSocket2.getStatus() == 1) {
                            try {
                                Thread.sleep(3000L);
                            }
                            catch (InterruptedException e) {
                                this.logger.warning("class RepairPool -> Thread.sleep InterruptedException ,IP:" + this.hsmSocket.getIp() + " " + e.getMessage());
                            }
                            continue;
                        }
                        stateFlag = 0;
                        stateMsg = "available";
                    }
                }
                if (hsmSocket2.getStatus() != 3) continue;
                stateFlag = 2;
                stateMsg = "removed";
            }
        }
        RepairPool.removeHsmIP(ip);
        this.logger.warning(ip + " is removed from repairpool.");
        if (listener != null) {
            this.logger.warning("do changeState");
            listener.changeState(this.hsmSocket.getIp(), stateFlag, stateMsg);
        }
        this.logger.warning("class RepairPool -> hsmSocket.repair()   success......last line..... , curthread.getId=" + curthread.getId());
    }

    public static synchronized int removeHsmIP(String IP) {
        for (int i = 0; i < repairHsmIP.size(); ++i) {
            if (!repairHsmIP.get(i).equalsIgnoreCase(IP)) continue;
            repairHsmIP.remove(i);
            return 0;
        }
        return 1;
    }
}

