/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.devicev4.gb.struct.key.dsa;

import com.sansec.devicev4.api.CryptoException;
import com.sansec.devicev4.gb.struct.key.IKeyPair;
import com.sansec.devicev4.util.BytesUtil;
import com.sun.jna.Structure;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public class DSArefSignature
extends Structure
implements IKeyPair {
    public byte[] r = new byte[32];
    public byte[] s = new byte[32];

    public DSArefSignature() {
    }

    public DSArefSignature(byte[] r, byte[] s) {
        this.r = r;
        this.s = s;
    }

    public byte[] getR() {
        return this.r;
    }

    public byte[] getS() {
        return this.s;
    }

    @Override
    public void decode(byte[] signature) throws CryptoException {
        int pos = 0;
        int len = signature.length / 2;
        this.r = new byte[len];
        System.arraycopy(signature, pos, this.r, 0, len);
        this.s = new byte[len];
        System.arraycopy(signature, pos += len, this.s, 0, len);
        if ((pos += len) != signature.length) {
            throw new CryptoException("inputData length != DSASignature length");
        }
    }

    @Override
    public byte[] encode() throws CryptoException {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        try {
            buf.write(this.r);
            buf.write(this.s);
        }
        catch (IOException e) {
            throw new CryptoException("DSArefSignature encode error.", e);
        }
        return buf.toByteArray();
    }

    @Override
    public int size() {
        return this.r.length + this.s.length;
    }

    @Override
    public String toString() {
        return "DSArefSignature{r=" + BytesUtil.bytes2hex(this.r) + ", s=" + BytesUtil.bytes2hex(this.s) + '}';
    }

    protected List getFieldOrder() {
        return Arrays.asList("r", "s");
    }

    public static class ByValue
    extends DSArefSignature
    implements Structure.ByValue {
    }

    public static class ByReference
    extends DSArefSignature
    implements Structure.ByReference {
    }
}

