/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.devicev4.gb.struct.key.ecdsa;

import com.sansec.devicev4.api.CryptoException;
import com.sansec.devicev4.gb.struct.key.IKeyPair;
import com.sansec.devicev4.util.BytesUtil;
import com.sun.jna.Structure;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;

public class ECIESrefCipher
extends Structure
implements IKeyPair {
    private int mode = 0;
    public byte[] x = new byte[80];
    public byte[] y = new byte[80];
    public byte[] M = new byte[64];
    public int cLength = 1;
    public byte[] C = new byte[1];

    public ECIESrefCipher() {
    }

    public ECIESrefCipher(int mode, byte[] x, byte[] y, byte[] c, byte[] m) {
        this.mode = mode;
        this.cLength = c.length;
        this.x = x;
        this.y = y;
        this.M = m;
        this.C = new byte[this.cLength];
        System.arraycopy(c, 0, this.C, 0, c.length);
    }

    public int getMode() {
        return this.mode;
    }

    public byte[] getX() {
        return this.x;
    }

    public byte[] getY() {
        return this.y;
    }

    public byte[] getC() {
        return this.C;
    }

    public byte[] getM() {
        return this.M;
    }

    public int getCLength() {
        return this.cLength;
    }

    @Override
    public void decode(byte[] cipher) throws CryptoException {
        int pos = 0;
        this.mode = BytesUtil.bytes2int(cipher);
        System.arraycopy(cipher, pos += 4, this.x, 0, 80);
        System.arraycopy(cipher, pos += this.x.length, this.y, 0, 80);
        System.arraycopy(cipher, pos += this.y.length, this.M, 0, 64);
        this.cLength = BytesUtil.bytes2int(cipher, pos += this.M.length);
        this.C = new byte[this.cLength];
        System.arraycopy(cipher, pos += 4, this.C, 0, this.cLength);
        if ((pos += this.C.length) != cipher.length) {
            throw new CryptoException("inputData length != ECIESrefCipher length");
        }
    }

    @Override
    public byte[] encode() throws CryptoException {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        try {
            buf.write(BytesUtil.int2bytes(this.mode));
            buf.write(this.x);
            buf.write(this.y);
            buf.write(this.M);
            buf.write(BytesUtil.int2bytes(this.cLength));
            buf.write(this.C);
        }
        catch (IOException e) {
            throw new CryptoException("ECIESrefCipher encode error.", e);
        }
        return buf.toByteArray();
    }

    @Override
    public int size() {
        return 232 + this.cLength;
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer();
        String nl = System.getProperty("line.separator");
        buf.append(nl);
        buf.append("   mode: ").append(this.mode).append(nl);
        buf.append("      x: ").append(new BigInteger(1, this.x).toString(16)).append(nl);
        buf.append("      y: ").append(new BigInteger(1, this.y).toString(16)).append(nl);
        buf.append("      M: ").append(new BigInteger(1, this.M).toString(16)).append(nl);
        buf.append("cLength: ").append(this.cLength).append(nl);
        buf.append("      C: ").append(new BigInteger(1, this.C).toString(16)).append(nl);
        return buf.toString();
    }

    protected List getFieldOrder() {
        return Arrays.asList("mode", "x", "y", "M", "cLength", "C");
    }

    public static class ByValue
    extends ECIESrefCipher
    implements Structure.ByValue {
    }

    public static class ByReference
    extends ECIESrefCipher
    implements Structure.ByReference {
    }
}

