package cn.com.servyou.ca.dto;

import lombok.Data;

/**
 * 客户端私钥签名
 *
 * @author zhouww
 * @since 20211028
 */
@Data
public class SignRequestDTO {

    /**
     * 签名原文
     */
    private String data;

    /**
     * 随机数
     */
    private String random;

    /**
     * 操作员证书
     */
    private String cert;

    /**
     * 使用操作员私钥对请求数据签名后的Base64数据
     */
    private String randomSign;

    /**
     * 时间戳（yyyyMMddHHmmss）
     */
    private String time;

    /**
     * 使用接口私钥对请求数据签名后的Base64数据
     */
    private String sign;

    /**
     * 签名算法
     */
    private String signAlg;
}
