package cn.com.servyou.ca.enums;


/**
 * url相关枚举
 *
 * @author : wulg
 * @since 20220414
 */
public enum UrlMatchEnum {
    REGISTER("/gateway/socins/hrss/employee/shanghai/register", "参保", "cbrymd"),
    REGISTER_V2("/gateway/socins/hrss/employee/v2/register", "参保", "cbrymd"),
    STOP("/gateway/socins/hrss/employee/stop", "停保", "tbrymd"),
    STOP_V2("/gateway/socins/hrss/employee/v2/stop", "停保V2", "tbrymd"),
    RADIX_ADJUSTMENT("/gateway/socins/hrss/paymentRadixAdjustment/v2/radixAdjustment", "缴费基数调整", "rylb"),
    RESIGN("/gateway/socins/hrss/employee/sendResign", "退工", "rylb");

    /**
     * 请求地址
     */
    private String url;

    /**
     * 说明
     */
    private String desc;

    /**
     * 需要取的对象名称
     */
    private String paramName;

    public String getUrl() {
        return url;
    }

    public String getDesc() {
        return desc;
    }

    public String getParamName() {
        return paramName;
    }

    /**
     * 根据地址模糊匹配
     *
     * @param url
     * @return
     */
    public static UrlMatchEnum matchByUrl(String url) {
        for (UrlMatchEnum obj : UrlMatchEnum.values()) {
            if (url.contains(obj.url)) {
                return obj;
            }
        }
        return null;
    }

    UrlMatchEnum(String url, String desc, String paramName) {
        this.url = url;
        this.desc = desc;
        this.paramName = paramName;
    }
}
