package cn.com.servyou.ca.request;

import cn.com.servyou.ca.dto.ActiveRequestDTO;
import cn.com.servyou.ca.dto.ActiveResultDTO;
import cn.com.servyou.ca.dto.CertRequestDTO;
import cn.com.servyou.ca.dto.CertResultDTO;
import cn.com.servyou.ca.dto.SignRequestDTO;
import cn.com.servyou.ca.dto.SignResultDTO;
import cn.com.servyou.constant.RMIConstant;
import cn.com.servyou.rmi.client.ServiceClient;
import cn.com.servyou.rmi.http.FormUrlEncodedRequestBody;
import cn.com.servyou.rmi.http.RequestMapping;
import cn.com.servyou.rmi.http.RequestMethod;

/**
 * 通用请求
 *
 * @author zhouww
 * @since 20211028
 */
@ServiceClient(value = RMIConstant.CA_SERVER)
public interface CaRequest {

    /**
     * 远程证书激活
     *
     * @param activeRequestDTO activeRequestDTO
     * @return 请求结果
     */
    @RequestMapping(value = "/v1/cert/active", method = RequestMethod.POST, headers = {"Content-Type=application/x-www-form-urlencoded"})
    ActiveResultDTO active(@FormUrlEncodedRequestBody ActiveRequestDTO activeRequestDTO);

    /**
     * 获取客户证书
     *
     * @param certRequestDTO certRequestDTO
     * @return 请求结果
     */
    @RequestMapping(value = "/v1/user/cert", method = RequestMethod.POST, headers = {"Content-Type=application/x-www-form-urlencoded"})
    CertResultDTO cert(@FormUrlEncodedRequestBody CertRequestDTO certRequestDTO);

    /**
     * 获取客户证书
     *
     * @param signRequestDTO signRequestDTO
     * @return 请求结果
     */
    @RequestMapping(value = "/v1/user/sign", method = RequestMethod.POST, headers = {"Content-Type=application/x-www-form-urlencoded"})
    SignResultDTO sign(@FormUrlEncodedRequestBody SignRequestDTO signRequestDTO);
}
