package cn.com.servyou.ca.service.impl;

import cn.com.servyou.ca.service.SignService;
import cn.com.servyou.constant.ServyouKeyConstant;
import cn.com.servyou.utils.LoggerUtil;
import com.sansec.jce.provider.SwxaProvider;
import lombok.extern.slf4j.Slf4j;

import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import java.util.Base64;

/**
 * 签名服务器
 *
 * @author zhouww
 * @since 20211028
 */
@Slf4j
public class SignServiceImpl implements SignService {

    private String userConfigFile = "";

    private SwxaProvider swxaProvider2;

    private static final String signMode = "SHA256WithRSA";

    public SignServiceImpl(String userConfigFile) {
        this.userConfigFile = userConfigFile;
    }

    @Override
    public String signRandom(String random, int inKeyIndex) {
        try {
            init();

            KeyPairGenerator kpg = KeyPairGenerator.getInstance("RSA", swxaProvider2);

            //Key index,Need to move 16 bits left
            kpg.initialize(inKeyIndex << 16);
            KeyPair inDSAKeyPair = kpg.genKeyPair();

            PrivateKey privateKey = inDSAKeyPair.getPrivate();
            PublicKey publicKey = inDSAKeyPair.getPublic();

            Signature outSignature = Signature.getInstance(signMode, swxaProvider2);
            outSignature.initSign(privateKey);
            outSignature.update(random.getBytes(ServyouKeyConstant.ENCODING_UTF8));
            byte[] signOut = outSignature.sign();

            String result = Base64.getEncoder().encodeToString(signOut);

            outSignature.initVerify(publicKey);
            outSignature.update(random.getBytes(ServyouKeyConstant.ENCODING_UTF8));
            boolean flag = outSignature.verify(signOut);
            if (flag) {
                return result;
            } else {
                throw new RuntimeException("签名失败");
            }
        } catch (Exception e) {
            LoggerUtil.error(log, e, "ca签名失败");
            throw new RuntimeException(e);
        }
    }

    private void init() {
        if (null == swxaProvider2) {
            synchronized (this) {
                if (null == swxaProvider2) {
                    swxaProvider2 = new SwxaProvider("", userConfigFile);
                    Security.addProvider(swxaProvider2);
                }
            }
        }
    }
}
