package cn.com.servyou.ca.utils;

import java.io.UnsupportedEncodingException;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Base64;

/**
 * CA密码
 *
 * @author zhouww
 * @date: 20210928
 */
public class CASecurityUtil {
	/**
	 * 编码格式
	 */
	private static final String UTF8 = "UTF-8";

	private static String SIGN_ALG = "SHA256withRSA";

	public static String signature(String privateKey, String data) {
		String result = null;
		try {
			byte[] signature = signature(privateKey, data.getBytes(UTF8));
			if (signature != null && signature.length > 0) {

				result = new String(Base64.getEncoder().encode(signature), UTF8);
			}
		} catch (UnsupportedEncodingException e) {
			e.printStackTrace();
		}
		return result;
	}

	private static byte[] signature(String privateKey, byte[] bData) {
		try {
			PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(Base64.getDecoder().decode(privateKey.getBytes(UTF8)));
			KeyFactory keyFactory = KeyFactory.getInstance("RSA");
			PrivateKey priKey = keyFactory.generatePrivate(keySpec);

			Signature oSig = Signature.getInstance(SIGN_ALG);
			oSig.initSign(priKey);
			oSig.update(bData);
			return oSig.sign();
		} catch (Exception e) {
			e.printStackTrace();
			return null;
		}
	}
}
