package cn.com.servyou.demo;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

/**
 * @author zhouww
 * @version 20211028
 */
@Data
public class CaDemoRequest {

    /**
     * 外部业务订单号
     */
    private String bizNo;

    /**
     * 登记序号
     */
    @JsonProperty("djxhid")
    private String registrationNumber;

    /**
     * 企业名称
     */
    @JsonProperty("qymc")
    private String name;

    /**
     * 税号
     */
    @JsonProperty("nsrsbh")
    private String taxNo;

    /**
     * 行政区划代码
     */
    @JsonProperty("areaid")
    private String area;

    /**
     * 部门编号
     */
    @JsonProperty("bmbh")
    private String deptNo;

    /**
     * 部门名称
     */
    @JsonProperty("bmmc")
    private String deptName;

    /**
     * 税款所属期
     */
    @JsonProperty("skssq")
    private String month;

    /**
     * 密码类型
     */
    @JsonProperty("mmlx")
    private String passwordType;

    /**
     * 单位编号
     */
    @JsonProperty("dwbh")
    private String socinsNumber;

    /**
     * ca证书
     */
    @JsonProperty("cazs")
    private String caCertificate;

    /**
     * 是否填充CA
     * true 填充CA
     * false 不填充CA
     */
    private boolean allowFillCA;

    /**
     * 获取ca用-操作员凭证
     */
    private String operatorCert;

    /**
     * 获取ca用-操作员姓名
     */
    private String operatorName;

    /**
     * 获取ca用-号码
     */
    private String cardNo;

    /**
     * ca索引号
     */
    private String inKeyIndex;
}
